/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.io.IncrementalClassifierPersistence;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import java.io.IOException;
import java.io.InputStream;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class PelletIncremantalReasonerFactory
implements OWLReasonerFactory {
    private static final PelletIncremantalReasonerFactory INSTANCE = new PelletIncremantalReasonerFactory();

    public static PelletIncremantalReasonerFactory getInstance() {
        return INSTANCE;
    }

    public String getReasonerName() {
        return "Pellet (Incremental)";
    }

    public String toString() {
        return this.getReasonerName();
    }

    public IncrementalClassifier createReasoner(InputStream inputStream) throws IOException {
        return IncrementalClassifierPersistence.load(inputStream);
    }

    public IncrementalClassifier createReasoner(InputStream inputStream, OWLOntology oWLOntology) throws IOException {
        return IncrementalClassifierPersistence.load(inputStream, oWLOntology);
    }

    public IncrementalClassifier createReasoner(PelletReasoner pelletReasoner) {
        return new IncrementalClassifier(pelletReasoner);
    }

    public IncrementalClassifier createReasoner(OWLOntology oWLOntology) {
        return new IncrementalClassifier(oWLOntology);
    }

    public IncrementalClassifier createReasoner(OWLOntology oWLOntology, ModuleExtractor moduleExtractor) {
        return new IncrementalClassifier(oWLOntology, moduleExtractor);
    }

    public IncrementalClassifier createReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) throws IllegalConfigurationException {
        return new IncrementalClassifier(oWLOntology, oWLReasonerConfiguration);
    }

    public IncrementalClassifier createNonBufferingReasoner(OWLOntology oWLOntology) {
        return new IncrementalClassifier(oWLOntology);
    }

    public IncrementalClassifier createNonBufferingReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) throws IllegalConfigurationException {
        return new IncrementalClassifier(oWLOntology, oWLReasonerConfiguration);
    }
}

