import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as cdk from '@aws-cdk/core';
/**
 * Amazon ECS Capacity Providers for AWS Fargate.
 *
 * @stability stable
 */
export declare enum FargateCapacityProviderType {
    /**
     * @stability stable
     */
    FARGATE = "FARGATE",
    /**
     * @stability stable
     */
    FARGATE_SPOT = "FARGATE_SPOT"
}
/**
 * The Capacity Provider strategy.
 *
 * @stability stable
 */
export interface CapacityProviderStrategyItem {
    /**
     * @stability stable
     */
    readonly base?: number;
    /**
     * @stability stable
     */
    readonly weight: number;
    /**
     * @stability stable
     */
    readonly capacityProvider: FargateCapacityProviderType;
}
/**
 * Properties for the FargateRunner.
 *
 * @stability stable
 */
export interface FargateRunnerProps {
    /**
     * VPC for the fargate.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * tags for the runner.
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The security group for Fargate CI task.
     *
     * @stability stable
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * subnet for fargate CI task.
     *
     * @stability stable
     */
    readonly fargateJobSubnet?: ec2.SubnetSelection;
    /**
     * GitLab registration token for the runner.
     *
     * @stability stable
     */
    readonly registrationToken?: string;
    /**
     * gitlab URL prefix.
     *
     * @default - 'https://gitlab.com'
     * @stability stable
     */
    readonly gitlabURL?: string;
    /**
     * Fargate job executor options.
     *
     * @stability stable
     */
    readonly executor?: FargateJobExecutor;
    /**
     * Default capacity provider strategy for the Amazon ECS cluster.
     *
     * @default DEFAULT_CLUSTER_CAPACITY_PROVIDER_STRATEGY
     * @stability stable
     */
    readonly clusterDefaultCapacityProviderStrategy?: CapacityProviderStrategyItem[];
    /**
     * Default capacity provider strategy for the Amazon ECS service.
     *
     * @default DEFAULT_SERVICE_CAPACITY_PROVIDER_STRATEGY
     * @stability stable
     */
    readonly serviceDefaultCapacityProviderStrategy?: CapacityProviderStrategyItem[];
    /**
     * The docker image for the job runner container.
     *
     * @stability stable
     */
    readonly image?: JobRunnerImage;
}
/**
 * The docker image for the job executor.
 *
 * @stability stable
 */
export declare class JobExecutorImage {
    readonly uri: string;
    /**
     * Debian.
     *
     * @see https://gitlab.com/tmaczukin-test-projects/fargate-driver-debian
     * @stability stable
     */
    static readonly DEBIAN: JobExecutorImage;
    /**
     * Node.
     *
     * @see https://gitlab.com/aws-fargate-driver-demo/docker-nodejs-gitlab-ci-fargate
     * @stability stable
     */
    static readonly NODE: JobExecutorImage;
    /**
     * JSII for AWS CDK.
     *
     * @see https://gitlab.com/pahud/docker-jsii-cdk-gitlab-ci-fargate
     * @stability stable
     */
    static readonly JSII: JobExecutorImage;
    /**
     * Custom image.
     *
     * @param image custom image registry URI.
     * @stability stable
     */
    static of(image: string): JobExecutorImage;
    /**
     *
     * @param image job executor image URI
     */
    private constructor();
}
/**
 * The docker image for the job runner.
 *
 * @stability stable
 */
export declare class JobRunnerImage {
    readonly uri: string;
    /**
     * Debian.
     *
     * @see https://gitlab.com/pahud/docker-gitlab-runner-fargate-driver
     * @stability stable
     */
    static readonly DEFAULT: JobRunnerImage;
    /**
     * Custom image.
     *
     * @param image custom image registry URI.
     * @stability stable
     */
    static of(image: string): JobRunnerImage;
    /**
     *
     * @param image job runner image URI
     */
    private constructor();
}
/**
 * The FargateRunner.
 *
 * @stability stable
 */
export declare class FargateRunner extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: FargateRunnerProps);
    private synthesizeTags;
    private createSecurityGroup;
}
/**
 * The properties for the FargateJobExecutor.
 *
 * @stability stable
 */
export interface FargateJobExecutorProps {
    /**
     * The docker image for the job executor container.
     *
     * @stability stable
     */
    readonly image?: JobExecutorImage;
    /**
     * AWS region for the job executor.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * @stability stable
     */
    readonly cluster?: ecs.ICluster;
    /**
     * @stability stable
     */
    readonly subnet?: ec2.ISubnet;
    /**
     * @stability stable
     */
    readonly securityGroup?: ec2.ISecurityGroup;
}
/**
 * The FargateJobExecutor.
 *
 * @stability stable
 */
export declare class FargateJobExecutor extends cdk.Construct {
    /**
     * task definition arn.
     *
     * @stability stable
     */
    readonly taskDefinitionArn: string;
    /**
     * @stability stable
     */
    readonly region: string;
    /**
     * @stability stable
     */
    readonly cluster?: ecs.ICluster;
    /**
     * @stability stable
     */
    readonly subnet?: ec2.ISubnet;
    /**
     * @stability stable
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: FargateJobExecutorProps);
}
