from enum import Enum, unique

@unique
class AccountType(Enum):
    CFD = 'CFD'
    PHYSICAL = 'PHYSICAL'
    SPREADBET = 'SPREADBET'

@unique
class AccountStatus(Enum):
    DISABLED = 'DISABLED'
    ENABLED = 'ENABLED'
    SUSPENDED_FROM_DEALING = 'SUSPENDED_FROM_DEALING'

@unique
class HistoryActivityChannel(Enum):
    DEALER = 'DEALER'
    MOBILE = 'MOBILE'
    PUBLIC_FIX_API = 'PUBLIC_FIX_API'
    PUBLIC_WEB_API = 'PUBLIC_WEB_API'
    SYSTEM = 'SYSTEM'
    WEB = 'WEB'

@unique
class DealActionType(Enum):
    LIMIT_ORDER_AMENDED = 'LIMIT_ORDER_AMENDED'
    LIMIT_ORDER_DELETED = 'LIMIT_ORDER_DELETED'
    LIMIT_ORDER_FILLED = 'LIMIT_ORDER_FILLED'
    LIMIT_ORDER_OPENED = 'LIMIT_ORDER_OPENED'
    LIMIT_ORDER_ROLLED = 'LIMIT_ORDER_ROLLED'
    POSITION_CLOSED = 'POSITION_CLOSED'
    POSITION_DELETED = 'POSITION_DELETED'
    POSITION_OPENED = 'POSITION_OPENED'
    POSITION_PARTIALLY_CLOSED = 'POSITION_PARTIALLY_CLOSED'
    POSITION_ROLLED = 'POSITION_ROLLED'
    STOP_LIMIT_AMENDED = 'STOP_LIMIT_AMENDED'
    STOP_ORDER_AMENDED = 'STOP_ORDER_AMENDED'
    STOP_ORDER_DELETED = 'STOP_ORDER_DELETED'
    STOP_ORDER_FILLED = 'STOP_ORDER_FILLED'
    STOP_ORDER_OPENED = 'STOP_ORDER_OPENED'
    STOP_ORDER_ROLLED = 'STOP_ORDER_ROLLED'
    UNKNOWN = 'UNKNOWN'
    WORKING_ORDER_DELETED = 'WORKING_ORDER_DELETED'

@unique
class DealDirection(Enum):
    BUY = 'BUY'
    SELL = 'SELL'

@unique
class ActivityStatus(Enum):
    ACCEPTED = 'ACCEPTED'
    REJECTED = 'REJECTED'
    UNKNOWN = 'UNKNOWN'

@unique
class ActivityType(Enum):
    EDIT_STOP_AND_LIMIT = 'EDIT_STOP_AND_LIMIT'
    POSITION = 'POSITION'
    SYSTEM = 'SYSTEM'
    WORKING_ORDER = 'WORKING_ORDER'

@unique
class TransactionType(Enum):
    ALL = 'ALL'
    ALL_DEAL = 'ALL_DEAL'
    DEPOSIT = 'DEPOSIT'
    WITHDRAWAL = 'WITHDRAWAL'

@unique
class DealStatus(Enum):
    AMENDED = 'AMENDED'
    DELETED = 'DELETED'
    FULLY_CLOSED = 'FULLY_CLOSED'
    OPENED = 'OPENED'
    PARTIALLY_CLOSED = 'PARTIALLY_CLOSED'

@unique
class AcceptReject(Enum):
    ACCEPTED = 'ACCEPTED'
    REJECTED = 'REJECTED'

@unique
class DealResultReason(Enum):
    ACCOUNT_NOT_ENABLED_TO_TRADING = 'ACCOUNT_NOT_ENABLED_TO_TRADING'
    ATTACHED_ORDER_LEVEL_ERROR = 'ATTACHED_ORDER_LEVEL_ERROR'
    ATTACHED_ORDER_TRAILING_STOP_ERROR = 'ATTACHED_ORDER_TRAILING_STOP_ERROR'
    CANNOT_CHANGE_STOP_TYPE = 'CANNOT_CHANGE_STOP_TYPE'
    CANNOT_REMOVE_STOP = 'CANNOT_REMOVE_STOP'
    CLOSING_ONLY_TRADES_ACCEPTED_ON_THIS_MARKET = 'CLOSING_ONLY_TRADES_ACCEPTED_ON_THIS_MARKET'
    CLOSINGS_ONLY_ACCOUNT = 'CLOSINGS_ONLY_ACCOUNT'
    CONFLICTING_ORDER = 'CONFLICTING_ORDER'
    CONTACT_SUPPORT_INSTRUMENT_ERROR = 'CONTACT_SUPPORT_INSTRUMENT_ERROR'
    CR_SPACING = 'CR_SPACING'
    DUPLICATE_ORDER_ERROR = 'DUPLICATE_ORDER_ERROR'
    EXCHANGE_MANUAL_OVERRIDE = 'EXCHANGE_MANUAL_OVERRIDE'
    EXPIRY_LESS_THAN_SPRINT_MARKET_MIN_EXPIRY = 'EXPIRY_LESS_THAN_SPRINT_MARKET_MIN_EXPIRY'
    FINANCE_REPEAT_DEALING = 'FINANCE_REPEAT_DEALING'
    FORCE_OPEN_ON_SAME_MARKET_DIFFERENT_CURRENCY = 'FORCE_OPEN_ON_SAME_MARKET_DIFFERENT_CURRENCY'
    GENERAL_ERROR = 'GENERAL_ERROR'
    GOOD_TILL_DATE_IN_THE_PAST = 'GOOD_TILL_DATE_IN_THE_PAST'
    INSTRUMENT_NOT_FOUND = 'INSTRUMENT_NOT_FOUND'
    INSTRUMENT_NOT_TRADEABLE_IN_THIS_CURRENCY = 'INSTRUMENT_NOT_TRADEABLE_IN_THIS_CURRENCY'
    INSUFFICIENT_FUNDS = 'INSUFFICIENT_FUNDS'
    LEVEL_TOLERANCE_ERROR = 'LEVEL_TOLERANCE_ERROR'
    LIMIT_ORDER_WRONG_SIDE_OF_MARKET = 'LIMIT_ORDER_WRONG_SIDE_OF_MARKET'
    MANUAL_ORDER_TIMEOUT = 'MANUAL_ORDER_TIMEOUT'
    MARGIN_ERROR = 'MARGIN_ERROR'
    MARKET_CLOSED = 'MARKET_CLOSED'
    MARKET_CLOSED_WITH_EDITS = 'MARKET_CLOSED_WITH_EDITS'
    MARKET_CLOSING = 'MARKET_CLOSING'
    MARKET_NOT_BORROWABLE = 'MARKET_NOT_BORROWABLE'
    MARKET_OFFLINE = 'MARKET_OFFLINE'
    MARKET_ORDERS_NOT_ALLOWED_ON_INSTRUMENT = 'MARKET_ORDERS_NOT_ALLOWED_ON_INSTRUMENT'
    MARKET_PHONE_ONLY = 'MARKET_PHONE_ONLY'
    MARKET_ROLLED = 'MARKET_ROLLED'
    MARKET_UNAVAILABLE_TO_CLIENT = 'MARKET_UNAVAILABLE_TO_CLIENT'
    MAX_AUTO_SIZE_EXCEEDED = 'MAX_AUTO_SIZE_EXCEEDED'
    MINIMUM_ORDER_SIZE_ERROR = 'MINIMUM_ORDER_SIZE_ERROR'
    MOVE_AWAY_ONLY_LIMIT = 'MOVE_AWAY_ONLY_LIMIT'
    MOVE_AWAY_ONLY_STOP = 'MOVE_AWAY_ONLY_STOP'
    MOVE_AWAY_ONLY_TRIGGER_LEVEL = 'MOVE_AWAY_ONLY_TRIGGER_LEVEL'
    NCR_POSITIONS_ON_CR_ACCOUNT = 'NCR_POSITIONS_ON_CR_ACCOUNT'
    OPPOSING_DIRECTION_ORDERS_NOT_ALLOWED = 'OPPOSING_DIRECTION_ORDERS_NOT_ALLOWED'
    OPPOSING_POSITIONS_NOT_ALLOWED = 'OPPOSING_POSITIONS_NOT_ALLOWED'
    ORDER_DECLINED = 'ORDER_DECLINED'
    ORDER_LOCKED = 'ORDER_LOCKED'
    ORDER_NOT_FOUND = 'ORDER_NOT_FOUND'
    ORDER_SIZE_CANNOT_BE_FILLED = 'ORDER_SIZE_CANNOT_BE_FILLED'
    OVER_NORMAL_MARKET_SIZE = 'OVER_NORMAL_MARKET_SIZE'
    PARTIALY_CLOSED_POSITION_NOT_DELETED = 'PARTIALY_CLOSED_POSITION_NOT_DELETED'
    POSITION_ALREADY_EXISTS_IN_OPPOSITE_DIRECTION = 'POSITION_ALREADY_EXISTS_IN_OPPOSITE_DIRECTION'
    POSITION_NOT_AVAILABLE_TO_CANCEL = 'POSITION_NOT_AVAILABLE_TO_CANCEL'
    POSITION_NOT_AVAILABLE_TO_CLOSE = 'POSITION_NOT_AVAILABLE_TO_CLOSE'
    POSITION_NOT_FOUND = 'POSITION_NOT_FOUND'
    REJECT_CFD_ORDER_ON_SPREADBET_ACCOUNT = 'REJECT_CFD_ORDER_ON_SPREADBET_ACCOUNT'
    REJECT_SPREADBET_ORDER_ON_CFD_ACCOUNT = 'REJECT_SPREADBET_ORDER_ON_CFD_ACCOUNT'
    SIZE_INCREMENT = 'SIZE_INCREMENT'
    SPRINT_MARKET_EXPIRY_AFTER_MARKET_CLOSE = 'SPRINT_MARKET_EXPIRY_AFTER_MARKET_CLOSE'
    STOP_OR_LIMIT_NOT_ALLOWED = 'STOP_OR_LIMIT_NOT_ALLOWED'
    STOP_REQUIRED_ERROR = 'STOP_REQUIRED_ERROR'
    STRIKE_LEVEL_TOLERANCE = 'STRIKE_LEVEL_TOLERANCE'
    SUCCESS = 'SUCCESS'
    TRAILING_STOP_NOT_ALLOWED = 'TRAILING_STOP_NOT_ALLOWED'
    UNKNOWN = 'UNKNOWN'
    WRONG_SIDE_OF_MARKET = 'WRONG_SIDE_OF_MARKET'

@unique
class InstrumentType(Enum):
    BINARY = 'BINARY'
    BUNGEE_CAPPED = 'BUNGEE_CAPPED'
    BUNGEE_COMMODITIES = 'BUNGEE_COMMODITIES'
    BUNGEE_CURRENCIES = 'BUNGEE_CURRENCIES'
    BUNGEE_INDICES = 'BUNGEE_INDICES'
    COMMODITIES = 'COMMODITIES'
    CURRENCIES = 'CURRENCIES'
    INDICES = 'INDICES'
    KNOCKOUTS_COMMODITIES = 'KNOCKOUTS_COMMODITIES'
    KNOCKOUTS_CURRENCIES = 'KNOCKOUTS_CURRENCIES'
    KNOCKOUTS_INDICES = 'KNOCKOUTS_INDICES'
    KNOCKOUTS_SHARES = 'KNOCKOUTS_SHARES'
    OPT_COMMODITIES = 'OPT_COMMODITIES'
    OPT_CURRENCIES = 'OPT_CURRENCIES'
    OPT_INDICES = 'OPT_INDICES'
    OPT_RATES = 'OPT_RATES'
    OPT_SHARES = 'OPT_SHARES'
    RATES = 'RATES'
    SECTORS = 'SECTORS'
    SHARES = 'SHARES'
    SPRINT_MARKET = 'SPRINT_MARKET'
    TEST_MARKET = 'TEST_MARKET'
    UNKNOWN = 'UNKNOWN'

@unique
class MarketStatus(Enum):
    CLOSED = 'CLOSED'
    EDITS_ONLY = 'EDITS_ONLY'
    OFFLINE = 'OFFLINE'
    ON_AUCTION = 'ON_AUCTION'
    ON_AUCTION_NO_EDITS = 'ON_AUCTION_NO_EDITS'
    SUSPENDED = 'SUSPENDED'
    TRADEABLE = 'TRADEABLE'

@unique
class OrderType(Enum):
    LIMIT = 'LIMIT'
    MARKET = 'MARKET'
    QUOTE = 'QUOTE'
    STOP = 'STOP'

@unique
class TimeInForce(Enum):
    EXECUTE_AND_ELIMINATE = 'EXECUTE_AND_ELIMINATE'
    FILL_OR_KILL = 'FILL_OR_KILL'
    GOOD_TILL_CANCELLED = 'GOOD_TILL_CANCELLED'
    GOOD_TILL_DATE = 'GOOD_TILL_DATE'

@unique
class MarketDetailsFilter(Enum):
    ALL = 'ALL'
    SNAPSHOT_ONLY = 'SNAPSHOT_ONLY'

@unique
class MarketOrderPreference(Enum):
    AVAILABLE_DEFAULT_OFF = 'AVAILABLE_DEFAULT_OFF'
    AVAILABLE_DEFAULT_ON = 'AVAILABLE_DEFAULT_ON'
    NOT_AVAILABLE = 'NOT_AVAILABLE'

@unique
class UnitType(Enum):
    PERCENTAGE = 'PERCENTAGE'
    POINTS = 'POINTS'

@unique
class TrailingStopPref(Enum):
    AVAILABLE = 'AVAILABLE'
    NOT_AVAILABLE = 'NOT_AVAILABLE'

@unique
class TradeUnit(Enum):
    AMOUNT = 'AMOUNT'
    CONTRACTS = 'CONTRACTS'
    SHARES = 'SHARES'

@unique
class Resolution(Enum):
    DAY = 'DAY'
    HOUR = 'HOUR'
    HOUR_2 = 'HOUR_2'
    HOUR_3 = 'HOUR_3'
    HOUR_4 = 'HOUR_4'
    MINUTE = 'MINUTE'
    MINUTE_10 = 'MINUTE_10'
    MINUTE_15 = 'MINUTE_15'
    MINUTE_2 = 'MINUTE_2'
    MINUTE_3 = 'MINUTE_3'
    MINUTE_30 = 'MINUTE_30'
    MINUTE_5 = 'MINUTE_5'
    MONTH = 'MONTH'
    SECOND = 'SECOND'
    WEEK = 'WEEK'

@unique
class CreateWatchlistRepsp(Enum):
    SUCCESS = 'SUCCESS'
    SUCCESS_NOT_ALL_INSTRUMENTS_ADDED = 'SUCCESS_NOT_ALL_INSTRUMENTS_ADDED'

@unique
class AppStatus(Enum):
    DISABLED = 'DISABLED'
    ENABLED = 'ENABLED'
    REVOKED = 'REVOKED'


@unique
class ReroutingEnvironment(Enum):
    DEMO = 'DEMO'
    LIVE = 'LIVE'
    TEST = 'TEST'
    UAT = 'UAT'