from types import ModuleType
from typing import Callable, Dict, Tuple, Type, TypeVar
from ..values import ABCMeta, abstractmethod
from ..input import KeyCode, KeyState, MouseCode

def checkModule(name: str) -> ModuleType: ...
def glfwCheck() -> None: ...
def sdl2Check() -> None: ...
def glutCheck() -> None: ...

providers: Dict[str, Tuple[str, Callable[[], None]]] = ...

def GetWindowProvider() -> ModuleType: ...
def SetWindowProvider(name: str) -> ModuleType: ...
T = TypeVar("T")
def CustomWindowProvider(cls: Type[T]) -> Type[T]: ...

class ABCWindow(metaclass=ABCMeta):
    @abstractmethod
    def __init__(self, name: str, resize: Callable[[int, int], None]) -> None: ...
    @abstractmethod
    def get_mouse(self, mousecode: MouseCode, keystate) -> None: ...
    @abstractmethod
    def get_key(self, keycode: KeyCode, keystate: KeyState) -> None: ...
    @abstractmethod
    def get_mouse_pos(self) -> None: ...
    @abstractmethod
    def quit(self) -> None: ...
    @abstractmethod
    def start(self, update_func: Callable[[float], None]) -> None: ...
