from typing import Callable, Iterable, TypeVar, List
from .abc import ABCMeta, abstractmethod, abstractproperty

def clamp(x: float, _min: float, _max: float) -> float: ...

T = TypeVar("T", bound="Vector")

class Vector(metaclass=ABCMeta):
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __getitem__(self) -> float: ...
    @abstractmethod
    def __iter__(self) -> Iterable[float]: ...
    def __list__(self) -> List[float]: ...
    @abstractmethod
    def __len__(self) -> int: ...
    def __eq__(self: T, o: T) -> bool: ...
    def __ne__(self: T, o: T) -> bool: ...
    def __gt__(self: T, o: T) -> bool: ...
    def __ge__(self: T, o: T) -> bool: ...
    def __lt__(self: T, o: T) -> bool: ...
    def __le__(self: T, o: T) -> bool: ...
    def __bool__(self) -> bool: ...
    def _o1(self: T, f: Callable[[float], float]) -> T: ...
    def _o2(self: T, other: T, f: Callable[[float, float], float]) -> T: ...
    def _r_o2(self: T, other: T, f: Callable[[float, float], float]) -> T: ...
    def _io(self: T, other: T, f: Callable[[float, float], float]) -> T: ...
    def __add__(self: T, other: T) -> T: ...
    def __radd__(self: T, other: T) -> T: ...
    def __iadd__(self: T, other: T) -> T: ...
    def __sub__(self: T, other: T) -> T: ...
    def __rsub__(self: T, other: T) -> T: ...
    def __isub__(self: T, other: T) -> T: ...
    def __mul__(self: T, other: T) -> T: ...
    def __rmul__(self: T, other: T) -> T: ...
    def __imul__(self: T, other: T) -> T: ...
    def __div__(self: T, other: T) -> T: ...
    def __rdiv__(self: T, other: T) -> T: ...
    def __idiv__(self: T, other: T) -> T: ...
    def __floordiv__(self: T, other: T) -> T: ...
    def __rfloordiv__(self: T, other: T) -> T: ...
    def __ifloordiv__(self: T, other: T) -> T: ...
    def __truediv__(self: T, other: T) -> T: ...
    def __rtruediv__(self: T, other: T) -> T: ...
    def __itruediv__(self: T, other: T) -> T: ...
    def __mod__(self: T, other: T) -> T: ...
    def __rmod__(self: T, other: T) -> T: ...
    def __imod__(self: T, other: T) -> T: ...
    def __lshift__(self: T, other: T) -> T: ...
    def __rlshift__(self: T, other: T) -> T: ...
    def __ilshift__(self: T, other: T) -> T: ...
    def __rshift__(self: T, other: T) -> T: ...
    def __rrshift__(self: T, other: T) -> T: ...
    def __irshift__(self: T, other: T) -> T: ...
    def __and__(self: T, other: T) -> T: ...
    def __rand__(self: T, other: T) -> T: ...
    def __or__(self: T, other: T) -> T: ...
    def __ror__(self: T, other: T) -> T: ...
    def __xor__(self: T, other: T) -> T: ...
    def __rxor__(self: T, other: T) -> T: ...
    def __neg__(self: T) -> T: ...
    def __pos__(self: T) -> T: ...
    def __abs__(self: T) -> T: ...
    def abs(self) -> float: ...
    def __round__(self: T) -> T: ...
    def __invert__(self: T) -> T: ...
    @abstractproperty
    def length(self) -> float: ...

class Vector2(Vector):
    x: float
    y: float
    def __init__(self, x_or_list: float = ..., y: float = ...) -> None: ...
    def __iter__(self) -> Iterable[float]: ...
    def __len__(self) -> int: ...
    def _o1(self: Vector2, f: Callable[[float], float]) -> Vector2: ...
    def _o2(self: Vector2, other: Vector2, f: Callable[[float, float], float]) -> Vector2: ...
    def _r_o2(self: Vector2, other: Vector2, f: Callable[[float, float], float]) -> Vector2: ...
    def _io(self: Vector2, other: Vector2, f: Callable[[float, float], float]) -> Vector2: ...
    def copy(self) -> Vector2: ...
    def get_length_sqrd(self) -> float: ...
    def normalized(self) -> Vector2: ...
    def normalize_return_length(self) -> float: ...
    def get_distance(self) -> float: ...
    def get_dist_sqrd(self) -> float: ...
    def clamp(self, min: Vector2, max: Vector2) -> None: ...
    def dot(self, other: Vector2) -> Vector2: ...
    def cross(self, other: Vector2) -> Vector2: ...

    @staticmethod
    def zero() -> Vector2: ...
    @staticmethod
    def one() -> Vector2: ...
    @staticmethod
    def up() -> Vector2: ...
    @staticmethod
    def down() -> Vector2: ...
    @staticmethod
    def left() -> Vector2: ...
    @staticmethod
    def right() -> Vector2: ...
    @staticmethod
    def min(a: Vector2, b: Vector2) -> Vector2: ...
    @staticmethod
    def max(a: Vector2, b: Vector2) -> Vector2: ...

    @property
    def length(self) -> float: ...
    @property
    def int_tuple(self) -> tuple: ...
    @property
    def rounded(self) -> tuple: ...

class Vector3(Vector):
    x: float
    y: float
    z: float
    def __init__(self, x_or_list: float = ..., y: float = ..., z: float = ...) -> None: ...
    def __iter__(self) -> Iterable[float]: ...
    def __len__(self) -> int: ...
    def _o1(self: Vector3, f: Callable[[float], float]) -> Vector3: ...
    def _o2(self: Vector3, other: Vector3, f: Callable[[float, float], float]) -> Vector3: ...
    def _r_o2(self: Vector3, other: Vector3, f: Callable[[float, float], float]) -> Vector3: ...
    def _io(self: Vector3, other: Vector3, f: Callable[[float, float], float]) -> Vector3: ...
    def copy(self) -> Vector3: ...
    def get_length_sqrd(self) -> float: ...
    def normalized(self) -> Vector3: ...
    def normalize_return_length(self) -> float: ...
    def get_distance(self) -> float: ...
    def get_dist_sqrd(self) -> float: ...
    def clamp(self, min: Vector3, max: Vector3) -> None: ...
    def dot(self, other: Vector3) -> Vector3: ...
    def cross(self, other: Vector3) -> Vector3: ...

    @staticmethod
    def zero() -> Vector3: ...
    @staticmethod
    def one() -> Vector3: ...
    @staticmethod
    def forward() -> Vector3: ...
    @staticmethod
    def back() -> Vector3: ...
    @staticmethod
    def up() -> Vector3: ...
    @staticmethod
    def down() -> Vector3: ...
    @staticmethod
    def left() -> Vector3: ...
    @staticmethod
    def right() -> Vector3: ...
    @staticmethod
    def min(a: Vector3, b: Vector3) -> Vector3: ...
    @staticmethod
    def max(a: Vector3, b: Vector3) -> Vector3: ...

    @property
    def length(self) -> float: ...
    @property
    def int_tuple(self) -> tuple: ...
    @property
    def rounded(self) -> tuple: ...
