from typing import List, NoReturn, Optional
from ..values import Vector3, ABCMeta, abstractmethod
from ..core import Component, Transform
from ..scenes import Scene

Infinity: float = ...

class PhysicMaterial:
    restitution: float
    friction: float
    combine: int
    def exception(self, *args, **kwargs) -> NoReturn: ...
    def __init__(self, restitution: float = ..., friction: float = ..., immutable: bool = ...) -> None: ...

class Manifold:
    a: Collider
    b: Collider
    normal: Vector3
    penetration: float
    def __init__(self, a: Collider, b: Collider, normal: Vector3, penetration: float) -> None: ...

class Collider(Component, metaclass=ABCMeta):
    @abstractmethod
    def collidingWith(self, other: Collider) -> Optional[Manifold]: ...

class SphereCollider(Collider):
    min: Vector3 = ...
    max: Vector3 = ...
    pos: Vector3 = ...
    radius: float = ...

    def __init__(self, transform: Transform) -> None: ...
    def SetSize(self, radius: float, offset: Vector3) -> None: ...
    def collidingWith(self, other: Collider) -> Optional[Manifold]: ...
    def CheckOverlap(self, other: Collider) -> bool: ...

class AABBoxCollider(Collider):
    min: Vector3 = ...
    max: Vector3 = ...
    pos: Vector3 = ...
    def __init__(self, transform: Transform) -> None: ...
    def SetSize(self, min: Vector3, max: Vector3) -> None: ...
    def collidingWith(self, other: Collider) -> Optional[Manifold]: ...
    def CheckOverlap(self, other: Collider) -> bool: ...

class Rigidbody(Component):
    mass: float = ...
    position: Vector3 = ...
    velocity: Vector3 = ...
    physicMaterial: PhysicMaterial = ...
    force: Vector3 = ...
    gravity: bool = ...

    def __init__(self, transform: Transform, dummy: bool = ...) -> None: ...
    def Move(self, dt: float) -> None: ...
    def MovePos(self, offset: Vector3) -> None: ...
    def AddForce(self, force: Vector3) -> None: ...
    def AddImpulse(self, impulse: Vector3) -> None: ...

class CollManager:
    rigidbodies: dict[Rigidbody, List[Collider]]
    dummyRigidbody: Rigidbody
    steps: int

    def __init__(self) -> None: ...
    def AddPhysicsInfo(self, scene: Scene) -> None: ...
    def GetRestitution(self, a: Rigidbody, b: Rigidbody) -> float: ...
    def CheckCollisions(self) -> None: ...
    def correct_inf(self, a: float, b: float, correction: float, target: float) -> float: ...
    def Step(self, dt: float) -> None: ...
