from typing import List, Optional, Dict, Type, Tuple
from .meshes import Mesh
from .scenes import Scene
from .files import Project
from .values import ImmutableStruct

def LoadObj(filename: str) -> Mesh: ...
def SaveObj(mesh: Mesh, name: str, filePath: Optional[str] = ...) -> None: ...
def LoadMesh(filename: str) -> Mesh: ...
def SaveMesh(mesh: Mesh, name: str, filePath: Optional[str] = ...) -> None: ...
def GetImports(file: str) -> str: ...
def SaveAllScenes(name: str, filePath: str) -> Project: ...
def SaveSceneToProject(scene: Scene, filePath: Optional[str] = ..., name: Optional[str] = ...) -> Project: ...
def GetId(ids: Dict[int: str], obj: object) -> str: ...
def SaveScene(scene: Scene, project: Project) -> None: ...

class ObjectInfo:
    uuid: str
    type: str
    attrs: Dict[str, str]
    def __init__(self, uuid: str, type: str, attrs: Dict[str, str]) -> None: ...
    def __getattr__(slef, attr: str) -> str: ...

components: Dict[str, Type] = ...

def parse_string(string: str) -> Tuple[bool, object]: ...
def LoadProject(filePath: str) -> Project: ...

class Primitives(metaclass=ImmutableStruct):
    _names: List[str] = ...
    __path: str = ...
    cube: Mesh = ...
    quad: Mesh = ...
    double_quad: Mesh = ...
    sphere: Mesh = ...
    capsule: Mesh = ...
    cylinder: Mesh = ...
