import enum
from typing import Callable, Dict, List, NoReturn, Optional, Tuple, Type, Union
from PIL import ImageFont
from .core import Component, SingleComponent, Transform
from .values import Vector2, ABCMeta, abstractmethod, Color
from .files import Texture2D
from .input import KeyState, MouseCode
from .scenes import Scene

class Canvas(Component):
    def Update(self, updated: List[Transform]) -> None: ...

class RectData:
    min: Vector2
    max: Vector2
    def __init__(self, min_or_both: Optional[Vector2] = ..., max: Optional[Vector2] = ...) -> None: ...
    def __repr__(self) -> str: ...
    def __add__(self, other: Union[RectData, Vector2, float]) -> RectData: ...
    def __sub__(self, other: Union[RectData, Vector2, float]) -> RectData: ...
    def __mul__(self, other: Union[RectData, Vector2, float]) -> RectData: ...

class RectAnchors(RectData):
    def SetPoint(self, p: Vector2) -> None: ...
    def RelativeTo(self, other: RectData) -> RectData: ...

class RectOffset(RectData):
    @staticmethod
    def Square(size: Vector2, center: Vector2 = ...) -> RectOffset: ...
    def Move(self, pos: Vector2) -> None: ...
    def SetCenter(self, pos: Vector2) -> None: ...

class RectTransform(SingleComponent):
    anchors: RectAnchors = ...
    offset: RectOffset = ...
    pivot: Vector2 = ...
    rotation: float = ...
    parent: RectTransform
    def __init__(self, transform: Transform) -> None: ...
    def GetRect(self) -> RectData: ...

class GuiComponent(Component, metaclass=ABCMeta):
    @abstractmethod
    def Update(self) -> None: ...

class NoResponseGuiComponent(GuiComponent):
    def Update(self) -> None: ...

class Image2D(NoResponseGuiComponent):
    texture: Texture2D = ...
    depth: float = ...
    rectTransform: RectTransform
    def __init__(self, transform: Transform) -> None: ...

class Button(GuiComponent):
    callback: Callable[[], None] = ...
    state: KeyState = ...
    mouseButton: MouseCode = ...
    pressed: bool = ...

    def Update(self) -> None: ...

textureDir: str = ...
buttonDefault: Texture2D = ...
checkboxDefaults: List[Texture2D] = ...

class _FontLoader:
    fonts: Dict[str, Font]

    @classmethod
    def LoadFont(cls, name: str, size: int) -> Font: ...
    @classmethod
    def LoadFile(cls, name: str) -> NoReturn: ...

class WinFontLoader(_FontLoader):
    @classmethod
    def LoadFile(cls, name: str) -> str: ...

class UnixFontLoader(_FontLoader):
    @classmethod
    def LoadFile(cls, name: str) -> str: ...

FontLoader: Type[_FontLoader]

class Font:
    _font: ImageFont.FreeTypeFont
    name: str
    size: int
    def __init__(self, name: str, size: 16, imagefont: ImageFont.FreeTypeFont) -> None: ...
    def __reduce__(self) -> Tuple[Callable[[str, int], Font], Tuple[str, int]]: ...

class TextAlign(enum.IntEnum):
    Left: TextAlign = ...
    Center: TextAlign = ...
    Right: TextAlign = ...

class Text(NoResponseGuiComponent):
    font: Font = ...
    text: str = ...
    color: Color = ...
    depth: float = ...
    centeredX: TextAlign = ...
    centeredY: TextAlign = ...
    rect: RectTransform
    texture: Texture2D
    def __init__(self, transform: Transform) -> None: ...
    def GenTexture(self) -> None: ...
    def __setattr__(self, name: str, value: object) -> None: ...

class CheckBox(GuiComponent):
    checked: bool = ...
    def Update(self) -> None: ...

class Gui:
    @classmethod
    def MakeButton(
        cls, name: str, scene: Scene, text: str = ..., 
        font: Font = ..., color: Color = ..., texture: Texture2D = ...
        ) -> Tuple[RectTransform, Button, Text]: ...
    @classmethod
    def MakeCheckBox(cls, name: str, scene: Scene) -> Tuple[RectTransform, CheckBox]: ...
