from typing import Generator, List, Optional, Type, TypeVar, Union, Dict
from .values import Vector3, Quaternion, Color, Material
from .scenes import Scene
from .meshes import Mesh
import enum

class Tag:
    tags: List[str] = ...
    tag: int
    tagName: str
    @classmethod
    def AddTag(cls, name: str) -> int: ...
    def __init__(self, tagNumOrName: Union[str, int]) -> None: ...

class GameObject:
    name: str
    components: List[Component]
    tag: Tag
    transform: Transform
    enabled: bool
    scene: Scene
    def __init__(self, name: str = ..., parent: Optional[GameObject] = ...) -> None: ...
    @staticmethod
    def BareObject(name: str = ...) -> GameObject: ...
    T = TypeVar("T", bound=GameObject)
    def AddComponent(self, componentClass: Type[T]) -> T: ...
    def GetComponent(self, componentClass: Type[T]) -> T: ...
    def RemoveComponent(self, componentClass: Type[T]) -> None: ...
    def GetComponents(self, componentClass: Type[T]) -> List[T]: ...
    def RemoveComponents(self, componentClass: Type[T]) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...

class HideInInspector:
    T = TypeVar("T", bound=HideInInspector)
    type: Type[T]
    default: T
    name: Optional[str]
    def __init__(self, type: Optional[Type[T]] = ..., default: Optional[T] = ...) -> None: ...

class ShowInInspector(HideInInspector):
    T = TypeVar("T", bound=ShowInInspector)
    def __init__(self, type: Optional[Type[T]] = ..., default: Optional[T] = ..., name: Optional[str] = ...): ...

class Component:
    shown: Dict[str, HideInInspector] = ...
    saved: Dict[str, HideInInspector] = ...
    gameObject: GameObject
    transform: Transform
    enabled: bool
    def __init__(self, transform: Transform, is_dummy: bool = ...) -> None: ...
    def __init_subclass__(cls) -> None: ...
    T = TypeVar("T", bound=Component)
    def AddComponent(self, componentClass: Type[T]) -> T: ...
    def GetComponent(self, componentClass: Type[T]) -> T: ...
    def RemoveComponent(self, componentClass: Type[T]) -> None: ...
    def GetComponents(self, componentClass: Type[T]) -> List[T]: ...
    def RemoveComponents(self, componentClass: Type[T]) -> None: ...
    @property
    def scene(self) -> Scene: ...

class SingleComponent(Component): ...

class Transform(SingleComponent):
    localPosition: Vector3 = ...
    localRotation: Quaternion = ...
    localScale: Vector3 = ...
    parent: Optional[Transform]
    children: List[Transform]
    @property
    def position(self) -> Vector3: ...
    @property
    def rotation(self) -> Quaternion: ...
    @property
    def localEulerAngles(self) -> Vector3: ...
    @property
    def eulerAngles(self) -> Vector3: ...
    @property
    def scale(self) -> Vector3: ...

    def __init__(self, transform: Transform) -> None: ...
    def ReparentTo(self, parent: Transform) -> None: ...
    def List(self) -> None: ...
    def GetDescendants(self) -> Generator[Transform]: ...
    def FullPath(self) -> str: ...
    def LookAtTransform(self, transform: Transform) -> None: ...
    def LookAtGameObject(self, gameObject: GameObject) -> None: ...
    def LookAtPoint(self, vec: Vector3) -> None: ...
    def LookInDirection(self, vec: Vector3) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...

class LightType(enum.IntEnum):
    Point: LightType = ...
    Directional: LightType = ...
    Spot: LightType = ...

class Light(SingleComponent):
    intensity: int = ...
    color: Color = ...
    type: LightType = ...

class MeshRenderer(SingleComponent):
    DefaultMaterial: Material = ...
    mesh: Mesh = ...
    mat: Material = ...
    def Render(self) -> None: ...
