/*
 * buildcode.c
 *
 *  Created on: 25 sept. 2012
 *      Author: coissac
 */

#include <stdio.h>
#include <inttypes.h>

int main(int argc, char *argv[])
{
	uint32_t code;
	uint32_t icode;
	char     nuc[5];
	int i;

	nuc[4]=0;

	printf("/**\n");
	printf(" * \n");
	printf(" * source file automatically generated by\n");
	printf(" * the program buildexpand8bits. Do not modify manually\n");
	printf(" *\n");
	printf(" */ \n");
	printf("\n");
	printf("#include <inttypes.h>\n");
	printf("\n");
	printf("\n");
	printf("uint32_t expanded8bitsnuc[] = {\n");

	for (code=0; code <= 0xFF; code++)
	{
		icode = code;

		for (i=0; i < 4; i++)
			nuc[3-i] = (icode >> (i*2))  & 3;

//#ifdef LITTLE_END
//		*((uint32_t*)nuc) = *((uint32_t*)nuc) >> 24 | \
//				*((uint32_t*)nuc) << 24 | \
//			  ((*((uint32_t*)nuc) >> 8) & 0x0000FF00) | \
//			  ((*((uint32_t*)nuc) << 8) & 0x00FF0000);
//#endif

		if (code < 0xFF)
			fprintf(stdout,"    0x%08XUL,  // %04X\n", *((uint32_t*)nuc),code);
		else
			fprintf(stdout,"    0x%08XUL   // %04X\n", *((uint32_t*)nuc),code);
	}

	printf("};\n");

	return 0;
}
