/*
 * buildcode.c
 *
 *  Created on: 25 sept. 2012
 *      Author: coissac
 */

#include <stdio.h>
#include <inttypes.h>

int main(int argc, char *argv[])
{
	uint32_t code;
	uint32_t compnuc[4]={2,3,0,1};
	uint32_t icode;
	uint32_t nuccode;
	char     nuc[5];
	char     cnuc[5];

	int i;
//	uint16_t mask;

	nuc[4]=0;
	cnuc[4]=0;

	printf("/**\n");
	printf(" * \n");
	printf(" * source file automatically generated by\n");
	printf(" * the program buildcomplement. Do not modify manually\n");
	printf(" *\n");
	printf(" */ \n");
	printf("\n");
	printf("#include <inttypes.h>\n");
	printf("\n");
	printf("\n");
	printf("uint8_t complement4nuc[] = {\n");

	for (code=0; code <= 0xFF; code++)
	{
		icode = 0;

		for (i=0; i < 4; i++)
		{
			nuccode = (code >> (i * 2)) & 3;
			nuc[3-i]="ACTG"[nuccode];
			cnuc[i]="ACTG"[compnuc[nuccode]];
			icode |= compnuc[nuccode] << ((3-i) * 2);
		}
		if (code < 0xFF)
			fprintf(stdout,"    0x%02X,  // %02X : %4s --> %4s \n", icode,code,nuc,cnuc);
		else
			fprintf(stdout,"    0x%02X   // %02X : %4s --> %4s \n", icode,code,nuc,cnuc);
	}

	printf("};\n");

	return 0;
}
