/*
 * buildcode.c
 *
 *  Created on: 25 sept. 2012
 *      Author: coissac
 */

#include <stdio.h>
#include <inttypes.h>

int main(int argc, char *argv[])
{
	uint32_t code;
	uint32_t icode;
	char     nuc[9];
	int i;
//	uint16_t mask;

	nuc[8]=0;

	printf("/**\n");
	printf(" * \n");
	printf(" * source file automatically generated by\n");
	printf(" * the program buildcode. Do not modify manually\n");
	printf(" *\n");
	printf(" */ \n");
	printf("\n");
	printf("#include <inttypes.h>\n");
	printf("\n");
	printf("\n");
	printf("uint64_t decode16bitsnuc[] = {\n");

	for (code=0; code <= 0xFFFF; code++)
	{
		icode = code;

#ifdef LITTLE_END
		icode = (code << 8) | (code >> 8);
#endif
		for (i=0; i < 8; i++)
			nuc[7-i] = "ACTG"[(icode >> (i*2))  & 3];

		if (code < 0xFFFF)
			fprintf(stdout,"    INT64_C(0x%16llX),  // %04X --> %8s \n", *((uint64_t*)nuc),code,nuc);
		else
			fprintf(stdout,"    INT64_C(0x%16llX)   // %04X --> %8s \n", *((uint64_t*)nuc),code,nuc);
	}

	printf("};\n");

	return 0;
}
