#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['wellmap']

package_data = \
{'': ['*']}

install_requires = \
['pandas', 'toml>=0.10', 'inform>=1.15', 'docopt', 'matplotlib', 'colorcet']

extras_require = \
{'docs': ['sphinxcontrib-programoutput', 'sphinx_rtd_theme', 'myst-parser'],
 'tests': ['pytest',
           'pytest-cov',
           'pytest-unordered',
           'pytest-subtests',
           'parametrize_from_file',
           'hypothesis',
           'coveralls',
           'attrs']}

entry_points = \
{'console_scripts': ['wellmap = wellmap.plot:main']}

setup(name='wellmap',
      version='3.2.0',
      description='File format for 96-well plate layouts.',
      author='Kale Kundert',
      author_email='kale@thekunderts.net',
      url='https://github.com/kalekundert/wellmap',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='~=3.6',
     )
