# Generated by Django 1.11.20 on 2019-04-22 09:41

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import shortuuidfield.fields

def from_transmitter_to_observation(apps, schema_editor):
    Observation = apps.get_model('base', 'Observation')
    observations = Observation.objects.all()
    for observation in observations:
        observation.transmitter_uuid = observation.transmitter.uuid
        observation.transmitter_description = observation.transmitter.description
        observation.transmitter_type = observation.transmitter.type
        observation.transmitter_uplink_low = observation.transmitter.uplink_low
        observation.transmitter_uplink_high = observation.transmitter.uplink_high
        observation.transmitter_uplink_drift = observation.transmitter.uplink_drift
        observation.transmitter_downlink_low = observation.transmitter.downlink_low
        observation.transmitter_downlink_high = observation.transmitter.downlink_high
        observation.transmitter_downlink_drift = observation.transmitter.downlink_drift
        observation.transmitter_mode = observation.transmitter.mode
        observation.transmitter_invert = observation.transmitter.invert
        observation.transmitter_baud = observation.transmitter.baud
        observation.save()

def reverse_from_transmitter_to_observation(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('base', '0057_no_null_demoddata_observation_field'),
    ]

    operations = [
        migrations.AddField(
            model_name='observation',
            name='transmitter_baud',
            field=models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)]),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_created',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_description',
            field=models.TextField(default=''),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_downlink_drift',
            field=models.IntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_downlink_high',
            field=models.BigIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_downlink_low',
            field=models.BigIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_invert',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_mode',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observations', to='base.Mode'),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_type',
            field=models.CharField(choices=[('Transmitter', 'Transmitter'), ('Transceiver', 'Transceiver'), ('Transponder', 'Transponder')], default='Transmitter', max_length=11),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_uplink_drift',
            field=models.IntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_uplink_high',
            field=models.BigIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_uplink_low',
            field=models.BigIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='observation',
            name='transmitter_uuid',
            field=shortuuidfield.fields.ShortUUIDField(blank=True, db_index=True, editable=False, max_length=22),
        ),
        migrations.RunPython(from_transmitter_to_observation, reverse_from_transmitter_to_observation),
        migrations.RemoveField(
            model_name='observation',
            name='transmitter',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='alive',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='baud',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='description',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='downlink_drift',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='downlink_high',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='downlink_low',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='invert',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='mode',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='satellite',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='type',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='uplink_drift',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='uplink_high',
        ),
        migrations.RemoveField(
            model_name='transmitter',
            name='uplink_low',
        ),
    ]
