# Copyright 2015 Cisco Systems, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
This is a auto-generated helper module for bios token configuration

"""


bios_tokens_table = {
    "classic": {
        "aspmSupport": {"mo_name": "BiosVfASPMSupport", "prop_name": "vp_aspm_support"},
        "adjacentCacheLinePrefetch": {"mo_name": "BiosVfAdjacentCacheLinePrefetch", "prop_name": "vp_adjacent_cache_line_prefetch"},
        "altitude": {"mo_name": "BiosVfAltitude", "prop_name": "vp_altitude"},
        "assertNmiOnPerr": {"mo_name": "BiosVfAssertNMIOnPERR", "prop_name": "vp_assert_nmi_on_perr"},
        "assertNmiOnSerr": {"mo_name": "BiosVfAssertNMIOnSERR", "prop_name": "vp_assert_nmi_on_serr"},
        "autoCcState": {"mo_name": "BiosVfAutoCCState", "prop_name": "vp_auto_cc_state"},
        "autonumousCstateEnable": {"mo_name": "BiosVfAutonumousCstateEnable", "prop_name": "vp_autonumous_cstate_enable"},
        "bmeDmaMitigation": {"mo_name": "BiosVfBmeDmaMitigation", "prop_name": "vp_bme_dma_mitigation"},
        "bootOptionNumRetry": {"mo_name": "BiosVfBootOptionNumRetry", "prop_name": "vp_boot_option_num_retry"},
        "bootOptionReCoolDown": {"mo_name": "BiosVfBootOptionReCoolDown", "prop_name": "vp_boot_option_re_cool_down"},
        "bootOptionRetry": {"mo_name": "BiosVfBootOptionRetry", "prop_name": "vp_boot_option_retry"},
        "bootPerformanceMode": {"mo_name": "BiosVfBootPerformanceMode", "prop_name": "vp_boot_performance_mode"},
        "cdnEnable": {"mo_name": "BiosVfCDNEnable", "prop_name": "vp_cdn_enable"},
        "cdnSupport": {"mo_name": "BiosVfCDNSupport", "prop_name": "vp_cdn_support"},
        "cpuEnergyPerformance": {"mo_name": "BiosVfCPUEnergyPerformance", "prop_name": "vp_cpu_energy_performance"},
        "cpuFrequencyFloor": {"mo_name": "BiosVfCPUFrequencyFloor", "prop_name": "vp_cpu_frequency_floor"},
        "cpuPerformance": {"mo_name": "BiosVfCPUPerformance", "prop_name": "vp_cpu_performance"},
        "cpuPowerManagement": {"mo_name": "BiosVfCPUPowerManagement", "prop_name": "vp_cpu_power_management"},
        "cbsCmnCpuCpb": {"mo_name": "BiosVfCbsCmnCpuCpb", "prop_name": "vp_cbs_cmn_cpu_cpb"},
        "cbsCmnCpuGenDowncoreCtrl": {"mo_name": "BiosVfCbsCmnCpuGenDowncoreCtrl", "prop_name": "vp_cbs_cmn_cpu_gen_downcore_ctrl"},
        "cbsCmnCpuGlobalCstateCtrl": {"mo_name": "BiosVfCbsCmnCpuGlobalCstateCtrl", "prop_name": "vp_cbs_cmn_cpu_global_cstate_ctrl"},
        "cbsCmnCpuL1streamHwPrefetcher": {"mo_name": "BiosVfCbsCmnCpuL1StreamHwPrefetcher", "prop_name": "vp_cbs_cmn_cpu_l1_stream_hw_prefetcher"},
        "cbsCmnCpuL2streamHwPrefetcher": {"mo_name": "BiosVfCbsCmnCpuL2StreamHwPrefetcher", "prop_name": "vp_cbs_cmn_cpu_l2_stream_hw_prefetcher"},
        "cbsCmnDeterminismSlider": {"mo_name": "BiosVfCbsCmnDeterminismSlider", "prop_name": "vp_cbs_cmn_determinism_slider"},
        "cbsCmnGnbNbIommu": {"mo_name": "BiosVfCbsCmnGnbNbIOMMU", "prop_name": "vp_cbs_cmn_gnb_nb_iommu"},
        "cbsCmnMemCtrlBankGroupSwapDdr4": {"mo_name": "BiosVfCbsCmnMemCtrlBankGroupSwapDdr4", "prop_name": "vp_cbs_cmn_mem_ctrl_bank_group_swap_ddr4"},
        "cbsCmnMemMapBankInterleaveDdr4": {"mo_name": "BiosVfCbsCmnMemMapBankInterleaveDdr4", "prop_name": "vp_cbs_cmn_mem_map_bank_interleave_ddr4"},
        "cbsCmncTdpCtl": {"mo_name": "BiosVfCbsCmncTDPCtl", "prop_name": "vp_cbs_cmnc_tdp_ctl"},
        "cbsDfCmnMemIntlv": {"mo_name": "BiosVfCbsDfCmnMemIntlv", "prop_name": "vp_cbs_df_cmn_mem_intlv"},
        "cbsDfCmnMemIntlvSize": {"mo_name": "BiosVfCbsDfCmnMemIntlvSize", "prop_name": "vp_cbs_df_cmn_mem_intlv_size"},
        "ciscoAdaptiveMemTraining": {"mo_name": "BiosVfCiscoAdaptiveMemTraining", "prop_name": "vp_cisco_adaptive_mem_training"},
        "ciscoDebugLevel": {"mo_name": "BiosVfCiscoDebugLevel", "prop_name": "vp_cisco_debug_level"},
        "ciscoOpromLaunchOptimization": {"mo_name": "BiosVfCiscoOpromLaunchOptimization", "prop_name": "vp_cisco_oprom_launch_optimization"},
        "ckeLowPolicy": {"mo_name": "BiosVfCkeLowPolicy", "prop_name": "vp_cke_low_policy"},
        "closedLoopThermThrotl": {"mo_name": "BiosVfClosedLoopThermThrotl", "prop_name": "vp_closed_loop_therm_throtl"},
        "cmciEnable": {"mo_name": "BiosVfCmciEnable", "prop_name": "vp_cmci_enable"},
        "configTdp": {"mo_name": "BiosVfConfigTDP", "prop_name": "vp_config_tdp"},
        "baudRate": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_baud_rate"},
        "consoleRedirection": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_console_redirection"},
        "flowControl": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_flow_control"},
        "legacyOsRedirection": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_legacy_os_redirection"},
        "puttyKeyPad": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_putty_key_pad"},
        "redirectionAfterPost": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_redirection_after_post"},
        "terminalType": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_terminal_type"},
        "coreMultiProcessing": {"mo_name": "BiosVfCoreMultiProcessing", "prop_name": "vp_core_multi_processing"},
        "dcpmmFirmwareDowngrade": {"mo_name": "BiosVfDCPMMFirmwareDowngrade", "prop_name": "vp_dcpmm_firmware_downgrade"},
        "ipPrefetch": {"mo_name": "BiosVfDCUPrefetch", "prop_name": "vp_ip_prefetch"},
        "streamerPrefetch": {"mo_name": "BiosVfDCUPrefetch", "prop_name": "vp_streamer_prefetch"},
        "dramClockThrottling": {"mo_name": "BiosVfDRAMClockThrottling", "prop_name": "vp_dram_clock_throttling"},
        "demandScrub": {"mo_name": "BiosVfDemandScrub", "prop_name": "vp_demand_scrub"},
        "directCacheAccess": {"mo_name": "BiosVfDirectCacheAccess", "prop_name": "vp_direct_cache_access"},
        "dramRefreshRate": {"mo_name": "BiosVfDramRefreshRate", "prop_name": "vp_dram_refresh_rate"},
        "eppProfile": {"mo_name": "BiosVfEPPProfile", "prop_name": "vp_epp_profile"},
        "energyEfficientTurbo": {"mo_name": "BiosVfEnergyEfficientTurbo", "prop_name": "vp_energy_efficient_turbo"},
        "engPerfTuning": {"mo_name": "BiosVfEngPerfTuning", "prop_name": "vp_eng_perf_tuning"},
        "enhancedIntelSpeedStepTech": {"mo_name": "BiosVfEnhancedIntelSpeedStepTech", "prop_name": "vp_enhanced_intel_speed_step_tech"},
        "executeDisableBit": {"mo_name": "BiosVfExecuteDisableBit", "prop_name": "vp_execute_disable_bit"},
        "extendedApic": {"mo_name": "BiosVfExtendedAPIC", "prop_name": "vp_extended_apic"},
        "frb2enable": {"mo_name": "BiosVfFRB2Enable", "prop_name": "vp_fr_b2_enable"},
        "hwpmEnable": {"mo_name": "BiosVfHWPMEnable", "prop_name": "vp_hwpm_enable"},
        "hardwarePrefetch": {"mo_name": "BiosVfHardwarePrefetch", "prop_name": "vp_hardware_prefetch"},
        "imcInterleave": {"mo_name": "BiosVfIMCInterleave", "prop_name": "vp_imc_interleave"},
        "iohResource": {"mo_name": "BiosVfIOHResource", "prop_name": "vp_ioh_resource"},
        "ipv4pxe": {"mo_name": "BiosVfIPV4PXE", "prop_name": "vp_ip_v4_pxe"},
        "ipv6pxe": {"mo_name": "BiosVfIPV6PXE", "prop_name": "vp_ip_v6_pxe"},
        "intelHyperThreadingTech": {"mo_name": "BiosVfIntelHyperThreadingTech", "prop_name": "vp_intel_hyper_threading_tech"},
        "intelSpeedSelect": {"mo_name": "BiosVfIntelSpeedSelect", "prop_name": "vp_intel_speed_select"},
        "intelTurboBoostTech": {"mo_name": "BiosVfIntelTurboBoostTech", "prop_name": "vp_intel_turbo_boost_tech"},
        "intelVtdatsSupport": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vtdats_support"},
        "intelVtdCoherencySupport": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vtd_coherency_support"},
        "intelVtdInterruptRemapping": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vtd_interrupt_remapping"},
        "intelVtdPassThroughDmaSupport": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vtd_pass_through_dma_support"},
        "intelVtForDirectedIo": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vt_for_directed_io"},
        "intelVirtualizationTechnology": {"mo_name": "BiosVfIntelVirtualizationTechnology", "prop_name": "vp_intel_virtualization_technology"},
        "iohErrorEnable": {"mo_name": "BiosVfIohErrorEn", "prop_name": "vp_ioh_error_enable"},
        "ktiPrefetch": {"mo_name": "BiosVfKTIPrefetch", "prop_name": "vp_kti_prefetch"},
        "llcPrefetch": {"mo_name": "BiosVfLLCPrefetch", "prop_name": "vp_llc_prefetch"},
        "lomPort0state": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_port0_state"},
        "lomPort1state": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_port1_state"},
        "lomPort2state": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_port2_state"},
        "lomPort3state": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_port3_state"},
        "lomPortsAllState": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_ports_all_state"},
        "legacyUsbSupport": {"mo_name": "BiosVfLegacyUSBSupport", "prop_name": "vp_legacy_usb_support"},
        "lvDdrMode": {"mo_name": "BiosVfLvDIMMSupport", "prop_name": "vp_lv_ddr_mode"},
        "mmcfgBase": {"mo_name": "BiosVfMMCFGBase", "prop_name": "vp_mmcfg_base"},
        "channelInterLeave": {"mo_name": "BiosVfMemoryInterleave", "prop_name": "vp_channel_inter_leave"},
        "memoryInterLeave": {"mo_name": "BiosVfMemoryInterleave", "prop_name": "vp_memory_inter_leave"},
        "rankInterLeave": {"mo_name": "BiosVfMemoryInterleave", "prop_name": "vp_rank_inter_leave"},
        "memoryMappedIoAbove4gb": {"mo_name": "BiosVfMemoryMappedIOAbove4GB", "prop_name": "vp_memory_mapped_io_above4_gb"},
        "memorySizeLimit": {"mo_name": "BiosVfMemorySizeLimit", "prop_name": "vp_memory_size_limit"},
        "mirroringMode": {"mo_name": "BiosVfMirroringMode", "prop_name": "vp_mirroring_mode"},
        "numaOptimized": {"mo_name": "BiosVfNUMAOptimized", "prop_name": "vp_numa_optimized"},
        "networkStack": {"mo_name": "BiosVfNetworkStack", "prop_name": "vp_network_stack"},
        "osBootWatchdogTimer": {"mo_name": "BiosVfOSBootWatchdogTimer", "prop_name": "vp_os_boot_watchdog_timer"},
        "osBootWatchdogTimerPolicy": {"mo_name": "BiosVfOSBootWatchdogTimerPolicy", "prop_name": "vp_os_boot_watchdog_timer_policy"},
        "osBootWatchdogTimerTimeout": {"mo_name": "BiosVfOSBootWatchdogTimerTimeout", "prop_name": "vp_os_boot_watchdog_timer_timeout"},
        "onboard10gbitLom": {"mo_name": "BiosVfOnboardNIC", "prop_name": "vp_onboard10_gbit_lom"},
        "onboardGbitLom": {"mo_name": "BiosVfOnboardNIC", "prop_name": "vp_onboard_gbit_lom"},
        "onboardScuStorageSupport": {"mo_name": "BiosVfOnboardStorage", "prop_name": "vp_onboard_scu_storage_support"},
        "onboardScuStorageSwStack": {"mo_name": "BiosVfOnboardStorageSWStack", "prop_name": "vp_onboard_scu_storage_sw_stack"},
        "outOfBandMgmtPort": {"mo_name": "BiosVfOutOfBandMgmtPort", "prop_name": "vp_out_of_band_mgmt_port"},
        "pciOptionRoMs": {"mo_name": "BiosVfPCIOptionROMs", "prop_name": "vp_pci_option_ro_ms"},
        "acsControlGpu1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_gp_u1_state"},
        "acsControlGpu2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_gp_u2_state"},
        "acsControlGpu3state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_gp_u3_state"},
        "acsControlGpu4state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_gp_u4_state"},
        "acsControlGpu5state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_gp_u5_state"},
        "acsControlGpu6state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_gp_u6_state"},
        "acsControlGpu7state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_gp_u7_state"},
        "acsControlGpu8state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_gp_u8_state"},
        "acsControlSlot11state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_slot11_state"},
        "acsControlSlot12state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_slot12_state"},
        "acsControlSlot13state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_slot13_state"},
        "acsControlSlot14state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_acs_control_slot14_state"},
        "slot10linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot10_link_speed"},
        "slot10state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot10_state"},
        "slot11linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot11_link_speed"},
        "slot11state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot11_state"},
        "slot12linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot12_link_speed"},
        "slot12state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot12_state"},
        "slot13state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot13_state"},
        "slot14state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot14_state"},
        "slot1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot1_link_speed"},
        "slot1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot1_state"},
        "slot2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot2_link_speed"},
        "slot2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot2_state"},
        "slot3linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot3_link_speed"},
        "slot3state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot3_state"},
        "slot4linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot4_link_speed"},
        "slot4state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot4_state"},
        "slot5linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot5_link_speed"},
        "slot5state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot5_state"},
        "slot6linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot6_link_speed"},
        "slot6state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot6_state"},
        "slot7linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot7_link_speed"},
        "slot7state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot7_state"},
        "slot8linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot8_link_speed"},
        "slot8state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot8_state"},
        "slot9linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot9_link_speed"},
        "slot9state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot9_state"},
        "slotFlomLinkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_flom_link_speed"},
        "slotFrontNvme1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_front_nvme1_link_speed"},
        "slotFrontNvme2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_front_nvme2_link_speed"},
        "slotFrontSlot5linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_front_slot5_link_speed"},
        "slotFrontSlot6linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_front_slot6_link_speed"},
        "slotGpu1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_gp_u1_state"},
        "slotGpu2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_gp_u2_state"},
        "slotGpu3state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_gp_u3_state"},
        "slotGpu4state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_gp_u4_state"},
        "slotGpu5state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_gp_u5_state"},
        "slotGpu6state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_gp_u6_state"},
        "slotGpu7state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_gp_u7_state"},
        "slotGpu8state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_gp_u8_state"},
        "slotHbaLinkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_hba_link_speed"},
        "slotHbaState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_hba_state"},
        "slotLom1link": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_lo_m1_link"},
        "slotLom2link": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_lo_m2_link"},
        "slotMlomLinkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_mlom_link_speed"},
        "slotMlomState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_mlom_state"},
        "slotMraidLinkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_mraid_link_speed"},
        "slotMraidState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_mraid_state"},
        "slotMezzState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_mezz_state"},
        "slotN10state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n10_state"},
        "slotN11state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n11_state"},
        "slotN12state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n12_state"},
        "slotN13state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n13_state"},
        "slotN14state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n14_state"},
        "slotN15state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n15_state"},
        "slotN16state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n16_state"},
        "slotN17state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n17_state"},
        "slotN18state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n18_state"},
        "slotN19state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n19_state"},
        "slotN1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n1_state"},
        "slotN20state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n20_state"},
        "slotN21state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n21_state"},
        "slotN22state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n22_state"},
        "slotN23state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n23_state"},
        "slotN24state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n24_state"},
        "slotN2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n2_state"},
        "slotN3state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n3_state"},
        "slotN4state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n4_state"},
        "slotN5state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n5_state"},
        "slotN6state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n6_state"},
        "slotN7state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n7_state"},
        "slotN8state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n8_state"},
        "slotN9state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n9_state"},
        "slotRaidLinkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_raid_link_speed"},
        "slotRaidState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_raid_state"},
        "slotRearNvme1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme1_link_speed"},
        "slotRearNvme1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme1_state"},
        "slotRearNvme2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme2_link_speed"},
        "slotRearNvme2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme2_state"},
        "slotRearNvme3state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme3_state"},
        "slotRearNvme4state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme4_state"},
        "slotRearNvme5state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme5_state"},
        "slotRearNvme6state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme6_state"},
        "slotRearNvme7state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme7_state"},
        "slotRearNvme8state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_rear_nvme8_state"},
        "slotRiser1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_riser1_link_speed"},
        "slotRiser1slot1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_riser1_slot1_link_speed"},
        "slotRiser1slot2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_riser1_slot2_link_speed"},
        "slotRiser1slot3linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_riser1_slot3_link_speed"},
        "slotRiser2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_riser2_link_speed"},
        "slotRiser2slot4linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_riser2_slot4_link_speed"},
        "slotRiser2slot5linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_riser2_slot5_link_speed"},
        "slotRiser2slot6linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_riser2_slot6_link_speed"},
        "slotSasState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sas_state"},
        "slotSsdSlot1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ssd_slot1_link_speed"},
        "slotSsdSlot2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ssd_slot2_link_speed"},
        "pcIeRasSupport": {"mo_name": "BiosVfPCIeRASSupport", "prop_name": "vp_pc_ie_ras_support"},
        "pcIeSsdHotPlugSupport": {"mo_name": "BiosVfPCIeSSDHotPlugSupport", "prop_name": "vp_pc_ie_ssd_hot_plug_support"},
        "postErrorPause": {"mo_name": "BiosVfPOSTErrorPause", "prop_name": "vp_post_error_pause"},
        "psata": {"mo_name": "BiosVfPSata", "prop_name": "vp_p_sata"},
        "pstateCoordType": {"mo_name": "BiosVfPStateCoordType", "prop_name": "vp_p_state_coord_type"},
        "packageCstateLimit": {"mo_name": "BiosVfPackageCStateLimit", "prop_name": "vp_package_c_state_limit"},
        "partialMirrorModeConfig": {"mo_name": "BiosVfPartialMirrorModeConfig", "prop_name": "vp_partial_mirror_mode_config"},
        "partialMirrorPercent": {"mo_name": "BiosVfPartialMirrorPercent", "prop_name": "vp_partial_mirror_percent"},
        "partialMirrorValue1": {"mo_name": "BiosVfPartialMirrorValue1", "prop_name": "vp_partial_mirror_value1"},
        "partialMirrorValue2": {"mo_name": "BiosVfPartialMirrorValue2", "prop_name": "vp_partial_mirror_value2"},
        "partialMirrorValue3": {"mo_name": "BiosVfPartialMirrorValue3", "prop_name": "vp_partial_mirror_value3"},
        "partialMirrorValue4": {"mo_name": "BiosVfPartialMirrorValue4", "prop_name": "vp_partial_mirror_value4"},
        "patrolScrub": {"mo_name": "BiosVfPatrolScrub", "prop_name": "vp_patrol_scrub"},
        "patrolScrubDuration": {"mo_name": "BiosVfPatrolScrubDuration", "prop_name": "vp_patrol_scrub_duration"},
        "pchUsb30mode": {"mo_name": "BiosVfPchUsb30Mode", "prop_name": "vp_pch_usb30_mode"},
        "pciRomClp": {"mo_name": "BiosVfPciRomClp", "prop_name": "vp_pci_rom_clp"},
        "popSupport": {"mo_name": "BiosVfPowerOnPasswordSupport", "prop_name": "vp_pop_support"},
        "processorC1e": {"mo_name": "BiosVfProcessorC1E", "prop_name": "vp_processor_c1_e"},
        "processorC3report": {"mo_name": "BiosVfProcessorC3Report", "prop_name": "vp_processor_c3_report"},
        "processorC6report": {"mo_name": "BiosVfProcessorC6Report", "prop_name": "vp_processor_c6_report"},
        "processorCstate": {"mo_name": "BiosVfProcessorCState", "prop_name": "vp_processor_c_state"},
        "pwrPerfTuning": {"mo_name": "BiosVfPwrPerfTuning", "prop_name": "vp_pwr_perf_tuning"},
        "qpiLinkFrequency": {"mo_name": "BiosVfQPIConfig", "prop_name": "vp_qpi_link_frequency"},
        "qpiSnoopMode": {"mo_name": "BiosVfQpiSnoopMode", "prop_name": "vp_qpi_snoop_mode"},
        "resumeOnAcPowerLoss": {"mo_name": "BiosVfResumeOnACPowerLoss", "prop_name": "vp_resume_on_ac_power_loss"},
        "smee": {"mo_name": "BiosVfSMEE", "prop_name": "vp_smee"},
        "sataModeSelect": {"mo_name": "BiosVfSataModeSelect", "prop_name": "vp_sata_mode_select"},
        "selectMemoryRasConfiguration": {"mo_name": "BiosVfSelectMemoryRASConfiguration", "prop_name": "vp_select_memory_ras_configuration"},
        "selectPprType": {"mo_name": "BiosVfSelectPprType", "prop_name": "vp_select_ppr_type"},
        "serialPortAenable": {"mo_name": "BiosVfSerialPortAEnable", "prop_name": "vp_serial_port_a_enable"},
        "singlePctlEnable": {"mo_name": "BiosVfSinglePCTLEnable", "prop_name": "vp_single_pctl_enable"},
        "smtMode": {"mo_name": "BiosVfSmtMode", "prop_name": "vp_smt_mode"},
        "sparingMode": {"mo_name": "BiosVfSparingMode", "prop_name": "vp_sparing_mode"},
        "srIov": {"mo_name": "BiosVfSrIov", "prop_name": "vp_sr_iov"},
        "snc": {"mo_name": "BiosVfSubNumaClustering", "prop_name": "vp_snc"},
        "svmMode": {"mo_name": "BiosVfSvmMode", "prop_name": "vp_svm_mode"},
        "tpmControl": {"mo_name": "BiosVfTPMControl", "prop_name": "vp_tpm_control"},
        "tpmSupport": {"mo_name": "BiosVfTPMSupport", "prop_name": "vp_tpm_support"},
        "txtSupport": {"mo_name": "BiosVfTXTSupport", "prop_name": "vp_txt_support"},
        "ucsmBootOrderRule": {"mo_name": "BiosVfUCSMBootOrderRuleControl", "prop_name": "vp_ucsm_boot_order_rule"},
        "makeDeviceNonBootable": {"mo_name": "BiosVfUSBBootConfig", "prop_name": "vp_make_device_non_bootable"},
        "usbEmul6064": {"mo_name": "BiosVfUSBEmulation", "prop_name": "vp_usb_emul6064"},
        "allUsbDevices": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_all_usb_devices"},
        "usbPortFront": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_front"},
        "usbPortInternal": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_internal"},
        "usbPortKvm": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_kvm"},
        "usbPortRear": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_rear"},
        "usbPortSdCard": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_sd_card"},
        "usbPortVmedia": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_v_media"},
        "usbXhciSupport": {"mo_name": "BiosVfUsbXhciSupport", "prop_name": "vp_usb_xhci_support"},
        "vmdEnable": {"mo_name": "BiosVfVMDEnable", "prop_name": "vp_vmd_enable"},
        "vgaPriority": {"mo_name": "BiosVfVgaPriority", "prop_name": "vp_vga_priority"},
        "workLoadConfig": {"mo_name": "BiosVfWorkLoadConfig", "prop_name": "vp_work_load_config"},
        "xptPrefetch": {"mo_name": "BiosVfXPTPrefetch", "prop_name": "vp_xpt_prefetch"},
    },

    "modular": {
        "aspmSupport": {"mo_name": "BiosVfASPMSupport", "prop_name": "vp_aspm_support"},
        "adjacentCacheLinePrefetch": {"mo_name": "BiosVfAdjacentCacheLinePrefetch", "prop_name": "vp_adjacent_cache_line_prefetch"},
        "altitude": {"mo_name": "BiosVfAltitude", "prop_name": "vp_altitude"},
        "assertNmiOnPerr": {"mo_name": "BiosVfAssertNMIOnPERR", "prop_name": "vp_assert_nmi_on_perr"},
        "assertNmiOnSerr": {"mo_name": "BiosVfAssertNMIOnSERR", "prop_name": "vp_assert_nmi_on_serr"},
        "autoCcState": {"mo_name": "BiosVfAutoCCState", "prop_name": "vp_auto_cc_state"},
        "autonumousCstateEnable": {"mo_name": "BiosVfAutonumousCstateEnable", "prop_name": "vp_autonumous_cstate_enable"},
        "bmeDmaMitigation": {"mo_name": "BiosVfBmeDmaMitigation", "prop_name": "vp_bme_dma_mitigation"},
        "bootOptionRetry": {"mo_name": "BiosVfBootOptionRetry", "prop_name": "vp_boot_option_retry"},
        "bootPerformanceMode": {"mo_name": "BiosVfBootPerformanceMode", "prop_name": "vp_boot_performance_mode"},
        "cdnEnable": {"mo_name": "BiosVfCDNEnable", "prop_name": "vp_cdn_enable"},
        "cdnSupport": {"mo_name": "BiosVfCDNSupport", "prop_name": "vp_cdn_support"},
        "cpuEnergyPerformance": {"mo_name": "BiosVfCPUEnergyPerformance", "prop_name": "vp_cpu_energy_performance"},
        "cpuFrequencyFloor": {"mo_name": "BiosVfCPUFrequencyFloor", "prop_name": "vp_cpu_frequency_floor"},
        "cpuPerformance": {"mo_name": "BiosVfCPUPerformance", "prop_name": "vp_cpu_performance"},
        "cpuPowerManagement": {"mo_name": "BiosVfCPUPowerManagement", "prop_name": "vp_cpu_power_management"},
        "ciscoAdaptiveMemTraining": {"mo_name": "BiosVfCiscoAdaptiveMemTraining", "prop_name": "vp_cisco_adaptive_mem_training"},
        "ciscoDebugLevel": {"mo_name": "BiosVfCiscoDebugLevel", "prop_name": "vp_cisco_debug_level"},
        "ciscoOpromLaunchOptimization": {"mo_name": "BiosVfCiscoOpromLaunchOptimization", "prop_name": "vp_cisco_oprom_launch_optimization"},
        "ckeLowPolicy": {"mo_name": "BiosVfCkeLowPolicy", "prop_name": "vp_cke_low_policy"},
        "cmciEnable": {"mo_name": "BiosVfCmciEnable", "prop_name": "vp_cmci_enable"},
        "baudRate": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_baud_rate"},
        "consoleRedirection": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_console_redirection"},
        "flowControl": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_flow_control"},
        "puttyKeyPad": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_putty_key_pad"},
        "redirectionAfterPost": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_redirection_after_post"},
        "terminalType": {"mo_name": "BiosVfConsoleRedirection", "prop_name": "vp_terminal_type"},
        "coreMultiProcessing": {"mo_name": "BiosVfCoreMultiProcessing", "prop_name": "vp_core_multi_processing"},
        "dcpmmFirmwareDowngrade": {"mo_name": "BiosVfDCPMMFirmwareDowngrade", "prop_name": "vp_dcpmm_firmware_downgrade"},
        "ipPrefetch": {"mo_name": "BiosVfDCUPrefetch", "prop_name": "vp_ip_prefetch"},
        "streamerPrefetch": {"mo_name": "BiosVfDCUPrefetch", "prop_name": "vp_streamer_prefetch"},
        "dramClockThrottling": {"mo_name": "BiosVfDRAMClockThrottling", "prop_name": "vp_dram_clock_throttling"},
        "demandScrub": {"mo_name": "BiosVfDemandScrub", "prop_name": "vp_demand_scrub"},
        "directCacheAccess": {"mo_name": "BiosVfDirectCacheAccess", "prop_name": "vp_direct_cache_access"},
        "dramRefreshRate": {"mo_name": "BiosVfDramRefreshRate", "prop_name": "vp_dram_refresh_rate"},
        "eppProfile": {"mo_name": "BiosVfEPPProfile", "prop_name": "vp_epp_profile"},
        "energyEfficientTurbo": {"mo_name": "BiosVfEnergyEfficientTurbo", "prop_name": "vp_energy_efficient_turbo"},
        "enhancedIntelSpeedStepTech": {"mo_name": "BiosVfEnhancedIntelSpeedStepTech", "prop_name": "vp_enhanced_intel_speed_step_tech"},
        "executeDisableBit": {"mo_name": "BiosVfExecuteDisableBit", "prop_name": "vp_execute_disable_bit"},
        "extendedApic": {"mo_name": "BiosVfExtendedAPIC", "prop_name": "vp_extended_apic"},
        "frb2enable": {"mo_name": "BiosVfFRB2Enable", "prop_name": "vp_fr_b2_enable"},
        "hwpmEnable": {"mo_name": "BiosVfHWPMEnable", "prop_name": "vp_hwpm_enable"},
        "hardwarePrefetch": {"mo_name": "BiosVfHardwarePrefetch", "prop_name": "vp_hardware_prefetch"},
        "imcInterleave": {"mo_name": "BiosVfIMCInterleave", "prop_name": "vp_imc_interleave"},
        "iohResource": {"mo_name": "BiosVfIOHResource", "prop_name": "vp_ioh_resource"},
        "ipv4pxe": {"mo_name": "BiosVfIPV4PXE", "prop_name": "vp_ip_v4_pxe"},
        "ipv6pxe": {"mo_name": "BiosVfIPV6PXE", "prop_name": "vp_ip_v6_pxe"},
        "intelHyperThreadingTech": {"mo_name": "BiosVfIntelHyperThreadingTech", "prop_name": "vp_intel_hyper_threading_tech"},
        "intelSpeedSelect": {"mo_name": "BiosVfIntelSpeedSelect", "prop_name": "vp_intel_speed_select"},
        "intelTurboBoostTech": {"mo_name": "BiosVfIntelTurboBoostTech", "prop_name": "vp_intel_turbo_boost_tech"},
        "intelVtdatsSupport": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vtdats_support"},
        "intelVtdCoherencySupport": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vtd_coherency_support"},
        "intelVtdInterruptRemapping": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vtd_interrupt_remapping"},
        "intelVtdPassThroughDmaSupport": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vtd_pass_through_dma_support"},
        "intelVtForDirectedIo": {"mo_name": "BiosVfIntelVTForDirectedIO", "prop_name": "vp_intel_vt_for_directed_io"},
        "intelVirtualizationTechnology": {"mo_name": "BiosVfIntelVirtualizationTechnology", "prop_name": "vp_intel_virtualization_technology"},
        "ktiPrefetch": {"mo_name": "BiosVfKTIPrefetch", "prop_name": "vp_kti_prefetch"},
        "llcPrefetch": {"mo_name": "BiosVfLLCPrefetch", "prop_name": "vp_llc_prefetch"},
        "lomPort0state": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_port0_state"},
        "lomPort1state": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_port1_state"},
        "lomPort2state": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_port2_state"},
        "lomPort3state": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_port3_state"},
        "lomPortsAllState": {"mo_name": "BiosVfLOMPortOptionROM", "prop_name": "vp_lom_ports_all_state"},
        "legacyUsbSupport": {"mo_name": "BiosVfLegacyUSBSupport", "prop_name": "vp_legacy_usb_support"},
        "lvDdrMode": {"mo_name": "BiosVfLvDIMMSupport", "prop_name": "vp_lv_ddr_mode"},
        "mmcfgBase": {"mo_name": "BiosVfMMCFGBase", "prop_name": "vp_mmcfg_base"},
        "channelInterLeave": {"mo_name": "BiosVfMemoryInterleave", "prop_name": "vp_channel_inter_leave"},
        "memoryInterLeave": {"mo_name": "BiosVfMemoryInterleave", "prop_name": "vp_memory_inter_leave"},
        "rankInterLeave": {"mo_name": "BiosVfMemoryInterleave", "prop_name": "vp_rank_inter_leave"},
        "memoryMappedIoAbove4gb": {"mo_name": "BiosVfMemoryMappedIOAbove4GB", "prop_name": "vp_memory_mapped_io_above4_gb"},
        "memorySizeLimit": {"mo_name": "BiosVfMemorySizeLimit", "prop_name": "vp_memory_size_limit"},
        "mirroringMode": {"mo_name": "BiosVfMirroringMode", "prop_name": "vp_mirroring_mode"},
        "numaOptimized": {"mo_name": "BiosVfNUMAOptimized", "prop_name": "vp_numa_optimized"},
        "networkStack": {"mo_name": "BiosVfNetworkStack", "prop_name": "vp_network_stack"},
        "osBootWatchdogTimer": {"mo_name": "BiosVfOSBootWatchdogTimer", "prop_name": "vp_os_boot_watchdog_timer"},
        "osBootWatchdogTimerPolicy": {"mo_name": "BiosVfOSBootWatchdogTimerPolicy", "prop_name": "vp_os_boot_watchdog_timer_policy"},
        "osBootWatchdogTimerTimeout": {"mo_name": "BiosVfOSBootWatchdogTimerTimeout", "prop_name": "vp_os_boot_watchdog_timer_timeout"},
        "onboard10gbitLom": {"mo_name": "BiosVfOnboardNIC", "prop_name": "vp_onboard10_gbit_lom"},
        "onboardGbitLom": {"mo_name": "BiosVfOnboardNIC", "prop_name": "vp_onboard_gbit_lom"},
        "onboardScuStorageSupport": {"mo_name": "BiosVfOnboardStorage", "prop_name": "vp_onboard_scu_storage_support"},
        "onboardScuStorageSwStack": {"mo_name": "BiosVfOnboardStorageSWStack", "prop_name": "vp_onboard_scu_storage_sw_stack"},
        "outOfBandMgmtPort": {"mo_name": "BiosVfOutOfBandMgmtPort", "prop_name": "vp_out_of_band_mgmt_port"},
        "pciOptionRoMs": {"mo_name": "BiosVfPCIOptionROMs", "prop_name": "vp_pci_option_ro_ms"},
        "ioeSlot1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_ioe_slot1_state"},
        "ioeSlot2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_ioe_slot2_state"},
        "slot10linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot10_link_speed"},
        "slot10state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot10_state"},
        "slot1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot1_link_speed"},
        "slot1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot1_state"},
        "slot2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot2_link_speed"},
        "slot2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot2_state"},
        "slot3linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot3_link_speed"},
        "slot3state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot3_state"},
        "slot4linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot4_link_speed"},
        "slot4state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot4_state"},
        "slot5linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot5_link_speed"},
        "slot5state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot5_state"},
        "slot6linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot6_link_speed"},
        "slot6state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot6_state"},
        "slot7linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot7_link_speed"},
        "slot7state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot7_state"},
        "slot8linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot8_link_speed"},
        "slot8state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot8_state"},
        "slot9linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot9_link_speed"},
        "slot9state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot9_state"},
        "slotHbaState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_hba_state"},
        "slotIoeMezz1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ioe_mezz1_link_speed"},
        "slotIoeMezz1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ioe_mezz1_state"},
        "slotIoenvMe1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ioenv_me1_link_speed"},
        "slotIoenvMe1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ioenv_me1_state"},
        "slotIoenvMe2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ioenv_me2_link_speed"},
        "slotIoenvMe2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ioenv_me2_state"},
        "slotIoeSlot1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ioe_slot1_link_speed"},
        "slotIoeSlot2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_ioe_slot2_link_speed"},
        "slotMlomState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_mlom_state"},
        "slotMlinkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_m_link_speed"},
        "slotMezzState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_mezz_state"},
        "slotN1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n1_state"},
        "slotN2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_n2_state"},
        "slotSasState": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sas_state"},
        "slotSbLom1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sb_lom1_state"},
        "slotSbMezz1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sb_mezz1_link_speed"},
        "slotSbMezz1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sb_mezz1_state"},
        "slotSbMezz2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sb_mezz2_link_speed"},
        "slotSbMezz2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sb_mezz2_state"},
        "slotSbnvMe1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sbnv_me1_link_speed"},
        "slotSbnvMe1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sbnv_me1_state"},
        "slotSbnvMe2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sbnv_me2_link_speed"},
        "slotSbnvMe2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sbnv_me2_state"},
        "slotSioc1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sio_c1_link_speed"},
        "slotSioc1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sio_c1_state"},
        "slotSioc2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sio_c2_link_speed"},
        "slotSioc2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sio_c2_state"},
        "slotSiocnvMe1linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_siocnv_me1_link_speed"},
        "slotSiocnvMe2linkSpeed": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_siocnv_me2_link_speed"},
        "slotSiocNvme1state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sioc_nvme1_state"},
        "slotSiocNvme2state": {"mo_name": "BiosVfPCISlotOptionROMEnable", "prop_name": "vp_slot_sioc_nvme2_state"},
        "pcIeRasSupport": {"mo_name": "BiosVfPCIeRASSupport", "prop_name": "vp_pc_ie_ras_support"},
        "postErrorPause": {"mo_name": "BiosVfPOSTErrorPause", "prop_name": "vp_post_error_pause"},
        "psata": {"mo_name": "BiosVfPSata", "prop_name": "vp_p_sata"},
        "pstateCoordType": {"mo_name": "BiosVfPStateCoordType", "prop_name": "vp_p_state_coord_type"},
        "packageCstateLimit": {"mo_name": "BiosVfPackageCStateLimit", "prop_name": "vp_package_c_state_limit"},
        "partialMirrorModeConfig": {"mo_name": "BiosVfPartialMirrorModeConfig", "prop_name": "vp_partial_mirror_mode_config"},
        "partialMirrorPercent": {"mo_name": "BiosVfPartialMirrorPercent", "prop_name": "vp_partial_mirror_percent"},
        "partialMirrorValue1": {"mo_name": "BiosVfPartialMirrorValue1", "prop_name": "vp_partial_mirror_value1"},
        "partialMirrorValue2": {"mo_name": "BiosVfPartialMirrorValue2", "prop_name": "vp_partial_mirror_value2"},
        "partialMirrorValue3": {"mo_name": "BiosVfPartialMirrorValue3", "prop_name": "vp_partial_mirror_value3"},
        "partialMirrorValue4": {"mo_name": "BiosVfPartialMirrorValue4", "prop_name": "vp_partial_mirror_value4"},
        "patrolScrub": {"mo_name": "BiosVfPatrolScrub", "prop_name": "vp_patrol_scrub"},
        "patrolScrubDuration": {"mo_name": "BiosVfPatrolScrubDuration", "prop_name": "vp_patrol_scrub_duration"},
        "pchUsb30mode": {"mo_name": "BiosVfPchUsb30Mode", "prop_name": "vp_pch_usb30_mode"},
        "pciRomClp": {"mo_name": "BiosVfPciRomClp", "prop_name": "vp_pci_rom_clp"},
        "popSupport": {"mo_name": "BiosVfPowerOnPasswordSupport", "prop_name": "vp_pop_support"},
        "processorC1e": {"mo_name": "BiosVfProcessorC1E", "prop_name": "vp_processor_c1_e"},
        "processorC3report": {"mo_name": "BiosVfProcessorC3Report", "prop_name": "vp_processor_c3_report"},
        "processorC6report": {"mo_name": "BiosVfProcessorC6Report", "prop_name": "vp_processor_c6_report"},
        "processorCstate": {"mo_name": "BiosVfProcessorCState", "prop_name": "vp_processor_c_state"},
        "pwrPerfTuning": {"mo_name": "BiosVfPwrPerfTuning", "prop_name": "vp_pwr_perf_tuning"},
        "qpiLinkFrequency": {"mo_name": "BiosVfQPIConfig", "prop_name": "vp_qpi_link_frequency"},
        "qpiSnoopMode": {"mo_name": "BiosVfQpiSnoopMode", "prop_name": "vp_qpi_snoop_mode"},
        "resumeOnAcPowerLoss": {"mo_name": "BiosVfResumeOnACPowerLoss", "prop_name": "vp_resume_on_ac_power_loss"},
        "sataModeSelect": {"mo_name": "BiosVfSataModeSelect", "prop_name": "vp_sata_mode_select"},
        "selectMemoryRasConfiguration": {"mo_name": "BiosVfSelectMemoryRASConfiguration", "prop_name": "vp_select_memory_ras_configuration"},
        "selectPprType": {"mo_name": "BiosVfSelectPprType", "prop_name": "vp_select_ppr_type"},
        "serialPortAenable": {"mo_name": "BiosVfSerialPortAEnable", "prop_name": "vp_serial_port_a_enable"},
        "sparingMode": {"mo_name": "BiosVfSparingMode", "prop_name": "vp_sparing_mode"},
        "srIov": {"mo_name": "BiosVfSrIov", "prop_name": "vp_sr_iov"},
        "snc": {"mo_name": "BiosVfSubNumaClustering", "prop_name": "vp_snc"},
        "tpmControl": {"mo_name": "BiosVfTPMControl", "prop_name": "vp_tpm_control"},
        "tpmSupport": {"mo_name": "BiosVfTPMSupport", "prop_name": "vp_tpm_support"},
        "txtSupport": {"mo_name": "BiosVfTXTSupport", "prop_name": "vp_txt_support"},
        "ucsmBootOrderRule": {"mo_name": "BiosVfUCSMBootOrderRuleControl", "prop_name": "vp_ucsm_boot_order_rule"},
        "makeDeviceNonBootable": {"mo_name": "BiosVfUSBBootConfig", "prop_name": "vp_make_device_non_bootable"},
        "usbEmul6064": {"mo_name": "BiosVfUSBEmulation", "prop_name": "vp_usb_emul6064"},
        "allUsbDevices": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_all_usb_devices"},
        "usbPortFront": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_front"},
        "usbPortInternal": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_internal"},
        "usbPortKvm": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_kvm"},
        "usbPortRear": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_rear"},
        "usbPortSdCard": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_sd_card"},
        "usbPortVmedia": {"mo_name": "BiosVfUSBPortsConfig", "prop_name": "vp_usb_port_v_media"},
        "usbXhciSupport": {"mo_name": "BiosVfUsbXhciSupport", "prop_name": "vp_usb_xhci_support"},
        "vgaPriority": {"mo_name": "BiosVfVgaPriority", "prop_name": "vp_vga_priority"},
        "workLoadConfig": {"mo_name": "BiosVfWorkLoadConfig", "prop_name": "vp_work_load_config"},
        "xptPrefetch": {"mo_name": "BiosVfXPTPrefetch", "prop_name": "vp_xpt_prefetch"},
    },

}
