# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['parselcli']

package_data = \
{'': ['*']}

install_requires = \
['Brotli>=1.0.9,<2.0.0',
 'beautifulsoup4>=4.10.0,<5.0.0',
 'click>=8.0.1,<9.0.0',
 'loguru>=0.5.3,<0.6.0',
 'parsel>=1.6.0,<2.0.0',
 'prompt-toolkit>=3.0.20,<4.0.0',
 'requests-cache>=0.8.1,<0.9.0',
 'rich>=10.11.0,<11.0.0',
 'toml>=0.10.2,<0.11.0']

entry_points = \
{'console_scripts': ['parsel = parselcli.cli:cli']}

setup_kwargs = {
    'name': 'parselcli',
    'version': '1.1.0',
    'description': 'CLI interpreter for xpath/css selectors',
    'long_description': '\n# About parselcli   \n\n![PyPI](https://img.shields.io/pypi/v/parselcli?style=flat-square) ![PyPi version](https://img.shields.io/pypi/pyversions/parselcli?style=flat-square) ![License](https://img.shields.io/pypi/l/parselcli?style=flat-square)\n![Chat](https://img.shields.io/matrix/web-scraping:matrix.org?style=flat-square)\n\n`parselcli` is a command line interface and interactive shell for [parsel](https://github.com/scrapy/parsel) package for evaluating css and xpath selectors in real time against web urls or local html files.\n\n> Parsel is a library to extract data from HTML and XML using XPath and CSS selectors\n\nMain goal of this tool is to ease document parser development (usually in the context of web-scraping).\n\n\n## Features:\n\n![screenshot of parsel shell](screenshot.png)\n\n* Supports `css` and `xpath` selector expressions either.\n* [Prompt Toolkit] powered interactive shell with autocomplete, hints, vi mode etc.\n* [Click] powered unix CLI (with pipe support)\n* Cache support for repeated usage.\n* Extensive and instant text processing via text processor flags.\n* User configs `~/.config/parsel.toml`\n\n\n## Example Usage\n\nCalling command `parsel` with any http url will drop terminal into prompt. \nIn the prompt css and xpath selector can be entered together with commands and processing options\n\n```\n$ parsel "https://github.com/granitosaurus/parsel-cli"\n\n# help command is always there to show available commands and processor flags\n> help\nCommands:\n--help                   print help\n--reset                  reset session processors\n--embed                  embed repl\n--info                   show context info\n--css                    switch to css input\n--xpath                  switch to xpath input\n--open                   open current url in web browser\n--view                   open current doc in web browser\n--vi                     toggle input to/from vi mode\n--fetch                  request new url\nProcessors:\n--first, -1              take only 1st value\n--pretty, -p             pretty format html\n--slice, -[              take slice\n--re                     filter values by regex or if capture groups are present return them\n--sum                    sum all values if possible\n--repr, -r               represent output (e.g. show newline chars)\n--len, -l                return total length\n--strip, -s              strip away trailing chars\n--absolute, -a           turn relative urls to absolute ones\n--collapse, -c           collapse single element lists\n--join, -j               join results\n--join-with, -J          join results with specified character\n-n                       take n-th element\n\n# css selector support\n> h1::text\n[\'\\n    \', \'\\n  \', \'\\n  \', \'\\n  \', \'\\n\\n  \', \'\\n\', \'About parselcli\']\n\n# css selectors with inline processors\n> h1::text --join --strip \nAbout parselcli\n\n# or short form inline processors\n> h1::text -js\nAbout parselcli\n\n# or session processors\n> --join --strip\nactive processors: [Join(\' \'), Strip]\n> h1::text\nAbout parselcli\n\n# switching to xpath\n> --xpath\nswitched to xpath\n> //h1/text()\nAbout parselcli\n```\n\nFor usage recipes, see [recipes.md](/recipes.md) documentations.\n\n\n## Details\n\n```\n$ parsel --help                                                                                                      \nUsage: parsel [OPTIONS] [URL]\n\n  Interactive shell for css and xpath selectors\n\nOptions:\n  -h TEXT                         request headers, e.g. -h "user-agent=cat\n                                  bot"\n  -f, --file FILENAME             input from html file instead of url\n  -c TEXT                         compile css and return it\n  -x TEXT                         compile xpath and return it\n  -i TEXT                         initial input\n  --xpath                         start in xpath mode instead of css\n  --cache                         cache requests\n  --no-color                      disable output colors\n  --warn-limit INTEGER\n  --config TEXT                   config file  [default:\n                                  /home/<user>/.config/parsel.toml]\n  --embed                         start in embedded python shell\n  -v                              verbosity level  [x>=0]\n  --shell [ptpython|ipython|bpython|python]\n                                  preferred embedded shell; default auto\n                                  resolve in order\n  --help                          Show this message and exit.\n```\n\n`parselcli` reads XML or HTML file from url or disk and starts interpreter for xpath or css selectors.\nBy default it starts in css interpreter mode but can be switched to xpath by `-xpath` command and switched back with `-css`.\n\n\n\n### Processors and Commands\n\n`parselcli` supports processors and commands in shell for advance usage:\n\n    $ parsel "https://github.com/granitosaurus/parsel-cli"                                                               \n    > --help                                                                                                              \n    Commands:\n    --help                   print help\n    --embed                  embed repl\n    --info                   show context info\n    --css                    switch to css input\n    --xpath                  siwtch to xpath input\n    --open                   open current url in web browser\n    --view                   open current doc in web browser\n    --fetch                  request new url\n    Processors:\n    --first, -1              take only 1st value\n    --len, -l                return total length\n    --strip, -s              strip away trailing chars\n    --absolute, -a           turn relative urls to absolute ones\n    --collapse, -c           collapse single element lists\n    --join, -j               join results\n    --join-with, -J          join results with specified character\n    -n  <number>             take n-th element\n\nCommands can be called at any point in the prompter:\n\n    > --fetch "http://some-other-url.com"\n    requesting "http://some-other-url.com"\n    > --view\n    opening document in browser\n\nProcessor options can be either activated for specific prompt (inline processors):\n\n    > h1::text --first\n    # will take first element\n\nOr can be set for current session (session processors):\n\n    > --first\n    default processors: [First]\n    # will process every following command with new processors\n\n## Install\n    \n    pip install parselcli\n    \nor install from github:\n\n    pip install --user git+https://github.com/Granitosaurus/parsel-cli@1.0.0\n    \n## Config\n\n`parselcli` can be configured via `toml` configuration file found in `$XDG_HOME/parsel.toml` (usually `~/.config/parsel.toml`):\n\n    # input on parsel launch - usually used to enable session processors\n    initial_input = [ "--collapse --strip"]\n    # whether input coloring is enabled \n    color = True\n    # whether input is in vi mode\n    vi_mode = False\n    # where ptpython history is located\n    history_file_css = "/home/user/.cache/parsel/history_css"\n    history_file_xpath = "/home/user/.cache/parsel/history_xpath"\n    history_file_embed = "/home/user/.cache/parsel/history_embed"\n    \n    [requests]\n    # when using --cache flag for using cached responses\n    cache_expire = 86400\n    # where sqlite cache file is stored for cache\n    cache_file = "/home/user/.cache/parsel/requests.cache"\n\n    [requests.headers]\n    # here headers can be defined for requests to avoid bot detection etc.\n    User-Agent = "parselcli web inspector"\n    # e.g. chrome on windows use\n    # User-Agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36"\n\n \n[Prompt Toolkit]: https://github.com/prompt-toolkit/python-prompt-toolkit\n[Click]: https://github.com/pallets/click',
    'author': 'granitosaurus',
    'author_email': 'bernardas.alisauskas@pm.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://scrapecrow.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
