# AUTOGENERATED! DO NOT EDIT! File to edit: 02_explore.ipynb (unless otherwise specified).

__all__ = ['show_correlation']

# Cell
import pandas as pd

from .delegate import delegates

# Cell
@delegates(pd.DataFrame().style.background_gradient)
def show_correlation(df: pd.DataFrame, method="pearson", **kwargs):
    """Show correlation heatmap

    Parameters:
    - `df`: DataFrame
    - `method`: Method of correlation to pass to `df.corr()`
    """
    kwargs = {**{"cmap": "bwr", "vmin": -1, "vmax": 1}, **kwargs}
    return df.corr(method=method).style.background_gradient(**kwargs).format("{0:,.2f}")