import sys
from threading import Condition
from threading import RLock
from typing import Any
from typing import Deque
from typing import Generic
from typing import NoReturn
from typing import Optional
from typing import TypeVar

_T = TypeVar("_T")

class Empty(Exception): ...
class Full(Exception): ...

class Queue(Generic[_T]):
    maxsize: int = ...
    mutex: RLock = ...
    not_empty: Condition = ...
    not_full: Condition = ...
    use_lifo: bool = ...
    queue: Deque[_T] = ...
    def __init__(self, maxsize: int = ..., use_lifo: bool = ...) -> None: ...
    def qsize(self) -> int: ...
    def empty(self) -> bool: ...
    def full(self) -> bool: ...
    def put(
        self, item: _T, block: bool = ..., timeout: Optional[float] = ...
    ) -> None: ...
    def put_nowait(self, item: _T) -> None: ...
    def get(self, block: bool = ..., timeout: Optional[float] = ...) -> _T: ...
    def get_nowait(self) -> _T: ...

class AsyncAdaptedQueue(Generic[_T]):
    use_lifo: bool = ...
    maxsize: int = ...
    @staticmethod
    def await_(awaitable: Any) -> Any: ...
    def __init__(self, maxsize: int = ..., use_lifo: bool = ...) -> None: ...
    if sys.version_info >= (3, 0):
        def empty(self) -> bool: ...
        def full(self) -> bool: ...
        def qsize(self) -> int: ...
        def put_nowait(self, item: _T) -> None: ...
        async def put(
            self, item: _T, block: bool = ..., timeout: Optional[float] = ...
        ) -> None: ...
        def get_nowait(self) -> _T: ...
        async def get(
            self, block: bool = ..., timeout: Optional[float] = ...
        ) -> _T: ...
    else:
        def empty(self) -> NoReturn: ...
        def full(self) -> NoReturn: ...
        def qsize(self) -> NoReturn: ...
        def put_nowait(self, item: Any) -> NoReturn: ...
        def put(
            self, item: Any, block: bool = ..., timeout: Optional[float] = ...
        ) -> NoReturn: ...
        def get_nowait(self) -> NoReturn: ...
        def get(
            self, block: bool = ..., timeout: Optional[float] = ...
        ) -> NoReturn: ...

class FallbackAsyncAdaptedQueue(AsyncAdaptedQueue[_T]):
    @staticmethod
    def await_(awaitable: Any) -> Any: ...
