from typing import Any
from typing import Callable
from typing import Generic
from typing import Iterable
from typing import Iterator
from typing import Optional
from typing import overload
from typing import Set
from typing import Tuple as _TypingTuple
from typing import Type
from typing import TypeVar
from typing import Union

from typing_extensions import Protocol

from . import operators
from . import roles
from . import sqltypes
from . import type_api
from .annotation import Annotated
from .annotation import SupportsWrappingAnnotations
from .base import ColumnSet
from .base import Executable
from .base import Immutable
from .base import SingletonConstant
from .compiler import SQLCompiler
from .functions import FunctionElement
from .schema import ForeignKey
from .selectable import TextualSelect
from .traversals import HasCopyInternals
from .traversals import MemoizedHasCacheKey
from .visitors import Traversible
from .. import util
from ..engine import Connection
from ..engine import Dialect
from ..engine import Engine
from ..util import HasMemoized
from ..util import langhelpers

_T = TypeVar("_T")
_T_co = TypeVar("_T_co", covariant=True)
_U_co = TypeVar("_U_co", covariant=True)

_TE = TypeVar("_TE", bound=type_api.TypeEngine[Any])
_OTE = TypeVar("_OTE", bound=type_api.TypeEngine[Any])
_CLE = TypeVar("_CLE", bound=ClauseElement)
_COLE = TypeVar("_COLE", bound=ColumnElement[Any])
_TC = TypeVar("_TC", bound=TextClause)
_CL = TypeVar("_CL", bound=ClauseList[Any])
_BCL = TypeVar("_BCL", bound=BooleanClauseList[Any])
_TU = TypeVar("_TU", bound=_TypingTuple[Any])
_SL = TypeVar("_SL", bound=Slice)
_GE = TypeVar("_GE", bound=GroupedElement)
_FF = TypeVar("_FF", bound=FunctionFilter[Any])
_TYC = TypeVar("_TYC", bound=TypeCoerce[Any, Any])
_UE = TypeVar("_UE", bound=UnaryExpression[Any])
_AB = TypeVar("_AB", bound=AsBoolean[Any])
_BE = TypeVar("_BE", bound=BinaryExpression[Any])
_QN = TypeVar("_QN", bound=quoted_name)
_TL = TypeVar("_TL", bound=_truncated_label)

_OverByType = Union[ClauseElement, str]

def collate(expression: Any, collation: str) -> BinaryExpression[_TE]: ...
def between(
    expr: Any,
    lower_bound: Any,
    upper_bound: Any,
    symmetric: bool = ...,
) -> BinaryExpression[_TE]: ...
@overload
def literal(value: _T) -> BindParameter[type_api.TypeEngine[_T]]: ...
@overload
def literal(
    value: Any, type_: Optional[Union[_TE, Type[_TE]]]
) -> BindParameter[_TE]: ...
@overload
def outparam(key: Any) -> BindParameter[Any]: ...
@overload
def outparam(
    key: Any, type_: Optional[Union[_TE, Type[_TE]]]
) -> BindParameter[_TE]: ...
def not_(
    clause: Any,
) -> UnaryExpression[sqltypes.NullType]: ...

class ClauseElement(
    roles.SQLRole,
    SupportsWrappingAnnotations,
    MemoizedHasCacheKey,
    HasCopyInternals,
    Traversible,
):
    __visit_name__: str = ...
    supports_execution: bool = ...
    stringify_dialect: str = ...
    bind: Any = ...
    description: Any = ...
    is_clause_element: bool = ...
    is_selectable: bool = ...
    def unique_params(
        self: _CLE, *optionaldict: Any, **kwargs: Any
    ) -> _CLE: ...
    def params(self: _CLE, *optionaldict: Any, **kwargs: Any) -> _CLE: ...
    def compare(self, other: Any, **kw: Any) -> bool: ...
    def get_children(
        self, omit_attrs: Any = ..., **kw: Any
    ) -> Iterable[Any]: ...
    def self_group(self, against: Optional[Any] = ...) -> ClauseElement: ...
    def compile(
        self,
        bind: Optional[Any] = ...,
        dialect: Optional[Dialect] = ...,
        **kw: Any,
    ) -> SQLCompiler: ...
    def __and__(self, other: Any) -> BooleanClauseList: ...
    def __or__(self, other: Any) -> BooleanClauseList: ...
    def __invert__(self) -> Any: ...
    def __bool__(self) -> bool: ...
    def __nonzero__(self) -> bool: ...

class ColumnElement(
    roles.ColumnArgumentOrKeyRole,
    roles.StatementOptionRole,
    roles.WhereHavingRole,
    roles.BinaryElementRole,
    roles.OrderByRole,
    roles.ColumnsClauseRole,
    roles.LimitOffsetRole,
    roles.DMLColumnRole,
    roles.DDLConstraintColumnRole,
    roles.DDLExpressionRole,
    operators.ColumnOperators[_TE],
    ClauseElement,
    Generic[_TE],
):
    __visit_name__: str = ...
    primary_key: Union[bool, ColumnSet[Any]] = ...
    foreign_keys: Any = ...
    key: Any = ...
    def self_group(
        self: _COLE, against: Optional[Any] = ...
    ) -> Union[_COLE, Grouping[_TE], AsBoolean[_COLE]]: ...
    @util.memoized_property
    def type(self) -> _TE: ...
    @HasMemoized.memoized_attribute
    def comparator(self) -> type_api.TypeEngine.Comparator[_TE]: ...
    def __getattr__(self, key: Any) -> Any: ...
    def operate(
        self, op: Any, *other: Any, **kwargs: Any
    ) -> ClauseElement: ...
    def reverse_operate(
        self, op: Any, other: Any, **kwargs: Any
    ) -> ClauseElement: ...
    @property
    def expression(self: _COLE) -> _COLE: ...
    @util.memoized_property
    def base_columns(self) -> util.column_set[Any]: ...
    @util.memoized_property
    def proxy_set(self) -> util.column_set[Any]: ...
    def shares_lineage(self, othercolumn: Any) -> bool: ...
    def cast(
        self: _COLE, type_: Union[Type[_OTE], _OTE]
    ) -> Cast[_OTE, _COLE]: ...
    def label(self, name: Any) -> Label[_TE]: ...
    @util.memoized_property
    def anon_label(self) -> Any: ...
    @util.memoized_property
    def anon_key_label(self) -> Any: ...

class WrapsColumnExpression(Generic[_CLE]):
    @property
    def wrapped_column_expression(self) -> _CLE: ...
    @property
    def anon_label(self) -> Any: ...

class BindParameter(roles.InElementRole, ColumnElement[_TE]):
    __visit_name__: str = ...
    inherit_cache: bool = ...
    key: Any = ...
    unique: bool = ...
    value: Any = ...
    callable: Optional[Callable[[], Any]] = ...
    isoutparam: Any = ...
    required: bool = ...
    expanding: Any = ...
    literal_execute: Any = ...
    type: _TE = ...  # type: ignore
    def __init__(
        self,
        key: Any,
        value: Any = ...,
        type_: Optional[Union[Type[_TE], _TE]] = ...,
        unique: bool = ...,
        required: bool = ...,
        quote: Optional[bool] = ...,
        callable_: Optional[Callable[[], Any]] = ...,
        expanding: bool = ...,
        isoutparam: bool = ...,
        literal_execute: bool = ...,
        _compared_to_operator: Optional[Any] = ...,
        _compared_to_type: Optional[Any] = ...,
        _is_crud: bool = ...,
    ) -> None: ...
    @property
    def effective_value(self) -> Any: ...

class TypeClause(ClauseElement, Generic[_TE]):
    __visit_name__: str = ...
    type: _TE = ...
    def __init__(self, type_: _TE) -> None: ...

class TextClause(
    roles.DDLConstraintColumnRole,
    roles.DDLExpressionRole,
    roles.StatementOptionRole,
    roles.WhereHavingRole,
    roles.OrderByRole,
    roles.FromClauseRole,
    roles.SelectStatementRole,
    roles.BinaryElementRole,
    roles.InElementRole,
    Executable,
    ClauseElement,
):
    __visit_name__: str = ...
    def __and__(
        self: _TC, other: _CLE
    ) -> BooleanClauseList[Union[_TC, _CLE]]: ...
    key: Any = ...
    text: Any = ...
    def __init__(self, text: util.text_type, bind: Optional[Any] = ...): ...
    @classmethod
    def _create_text(
        cls,
        text: util.text_type,
        bind: Optional[Union[Engine, Connection]] = ...,
    ) -> TextClause: ...
    def bindparams(self: _TC, *binds: Any, **names_to_values: Any) -> _TC: ...
    def columns(self, *cols: Any, **types: Any) -> TextualSelect: ...
    @property
    def type(self) -> sqltypes.NullType: ...
    @property
    def comparator(self) -> sqltypes.NullType.Comparator: ...
    def self_group(
        self: _TC, against: Optional[Any] = ...
    ) -> Union[Grouping[sqltypes.NullType], _TC]: ...

class Null(
    SingletonConstant,
    roles.ConstExprRole,
    ColumnElement[sqltypes.NullType],
):
    __visit_name__: str = ...
    @classmethod
    def _instance(cls) -> Null: ...

class False_(
    SingletonConstant,
    roles.ConstExprRole,
    ColumnElement[sqltypes.Boolean],
):
    __visit_name__: str = ...
    @classmethod
    def _instance(cls) -> False_: ...

class True_(
    SingletonConstant,
    roles.ConstExprRole,
    ColumnElement[sqltypes.Boolean],
):
    __visit_name__: str = ...
    @classmethod
    def _instance(cls) -> True_: ...

class ClauseList(
    roles.InElementRole,
    roles.OrderByRole,
    roles.ColumnsClauseRole,
    roles.DMLColumnRole,
    ClauseElement,
    Generic[_CLE],
):
    __visit_name__: str = ...
    operator: Any = ...
    group: Any = ...
    group_contents: Any = ...
    clauses: Any = ...
    def __init__(self, *clauses: _CLE, **kwargs: Any) -> None: ...
    def __iter__(self) -> Iterator[_CLE]: ...
    def __len__(self) -> int: ...
    def append(self, clause: _CLE) -> None: ...
    def self_group(
        self: _CL, against: Optional[Any] = ...
    ) -> Union[_CL, Grouping[sqltypes.NullType]]: ...

class BooleanClauseList(
    ClauseList[_CLE], ColumnElement[sqltypes.Boolean], Generic[_CLE]
):
    __visit_name__: str = ...
    inherit_cache: bool = ...
    def __init__(self, *arg: Any, **kw: Any) -> None: ...
    @classmethod
    def and_(cls, *clauses: _CLE) -> BooleanClauseList[_CLE]: ...
    @classmethod
    def or_(cls, *clauses: _CLE) -> BooleanClauseList[_CLE]: ...
    def self_group(  # type: ignore[override]
        self: _BCL, against: Optional[Any] = ...
    ) -> Union[_BCL, Grouping[sqltypes.Boolean]]: ...

and_ = BooleanClauseList.and_
or_ = BooleanClauseList.or_

class Tuple(ClauseList[_CLE], ColumnElement[_TE]):
    __visit_name__: str = ...
    type: sqltypes.TupleType[_TE] = ...  # type: ignore[assignment]
    def __init__(self, *clauses: _CLE, **kw: Any) -> None: ...
    def self_group(self: _TU, against: Optional[Any] = ...) -> _TU: ...  # type: ignore

class Case(ColumnElement[_TE]):
    __visit_name__: str = ...
    value: Any = ...
    type: Any = ...
    whens: Any = ...
    else_: Any = ...
    def __init__(self, *whens: Any, **kw: Any) -> None: ...

@overload
def literal_column(
    text: str, type_: None = ...
) -> ColumnClause[sqltypes.NullType]: ...
@overload
def literal_column(
    text: str, type_: Union[_TE, Type[_TE]]
) -> ColumnClause[_TE]: ...

class Cast(WrapsColumnExpression[_CLE], ColumnElement[_TE], Generic[_TE, _CLE]):  # type: ignore[misc]
    __visit_name__: str = ...
    type: _TE = ...  # type: ignore[assignment]
    clause: _CLE = ...
    typeclause: TypeClause[_TE] = ...
    def __init__(
        self, expression: _CLE, type_: Union[_TE, Type[_TE]]
    ) -> None: ...
    @property
    def wrapped_column_expression(self) -> _CLE: ...

class TypeCoerce(WrapsColumnExpression[_CLE], ColumnElement[_TE], Generic[_TE, _CLE]):  # type: ignore[misc]
    __visit_name__: str = ...
    type: _TE = ...  # type: ignore[assignment]
    clause: _CLE = ...
    def __init__(
        self, expression: _CLE, type_: Union[_TE, Type[_TE]]
    ) -> None: ...
    @HasMemoized.memoized_attribute
    def typed_expression(self) -> Any: ...
    @property
    def wrapped_column_expression(self) -> _CLE: ...
    def self_group(
        self: _TYC, against: Optional[Any] = ...
    ) -> Union[_TYC, Grouping[Any]]: ...

class Extract(ColumnElement[sqltypes.Integer]):
    __visit_name__: str = ...
    type: sqltypes.Integer = ...  # type: ignore[assignment]
    field: Any = ...
    expr: Any = ...
    def __init__(self, field: Any, expr: Any, **kwargs: Any) -> None: ...

class _label_reference(ColumnElement[sqltypes.NullType]):
    __visit_name__: str = ...
    element: Any = ...
    def __init__(self, element: Any) -> None: ...

class _textual_label_reference(ColumnElement[sqltypes.NullType]):
    __visit_name__: str = ...
    element: Any = ...
    def __init__(self, element: Any) -> None: ...

class UnaryExpression(ColumnElement[_TE]):
    __visit_name__: str = ...
    operator: Any = ...
    modifier: Any = ...
    element: Any = ...
    type: _TE = ...  # type: ignore[assignment]
    wraps_column_expression: Any = ...
    @overload
    def __init__(
        self,
        element: Any,
        *,
        operator: Any = ...,
        modifier: Any = ...,
        type_: Union[_TE, Type[_TE]],
        wraps_column_expression: bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        element: Any,
        operator: Any,
        modifier: Any,
        type_: Union[_TE, Type[_TE]],
        wraps_column_expression: bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self: UnaryExpression[sqltypes.NullType],
        element: Any,
        operator: Optional[Any] = ...,
        modifier: Optional[Any] = ...,
        type_: None = ...,
        wraps_column_expression: bool = ...,
    ) -> None: ...
    @classmethod
    def _create_nulls_first(
        cls, column: Any
    ) -> UnaryExpression[sqltypes.NullType]: ...
    @classmethod
    def _create_nulls_last(
        cls, column: Any
    ) -> UnaryExpression[sqltypes.NullType]: ...
    @classmethod
    def _create_desc(
        cls, column: Any
    ) -> UnaryExpression[sqltypes.NullType]: ...
    @classmethod
    def _create_asc(
        cls, column: Any
    ) -> UnaryExpression[sqltypes.NullType]: ...
    @classmethod
    def _create_distinct(cls, column: Any) -> UnaryExpression[_OTE]: ...
    def self_group(
        self: _UE, against: Optional[Any] = ...
    ) -> Union[_UE, Grouping[_TE]]: ...

class CollectionAggregate(UnaryExpression[_TE]):
    @classmethod
    def _create_any(
        cls, expr: Any
    ) -> CollectionAggregate[sqltypes.NullType]: ...
    @classmethod
    def _create_all(
        cls, expr: Any
    ) -> CollectionAggregate[sqltypes.NullType]: ...
    def operate(
        self, op: Any, *other: Any, **kwargs: Any
    ) -> ClauseElement: ...
    def reverse_operate(self, op: Any, other: Any, **kwargs: Any) -> None: ...  # type: ignore[override]

class AsBoolean(  # type: ignore[misc]
    WrapsColumnExpression[_CLE],
    UnaryExpression[sqltypes.Boolean],
    Generic[_CLE],
):
    inherit_cache: bool = ...
    element: _CLE = ...
    type: sqltypes.Boolean = ...
    operator: Any = ...
    negate: Any = ...
    modifier: Any = ...
    wraps_column_expression: bool = ...
    def __init__(self, element: _CLE, operator: Any, negate: Any) -> None: ...
    @property
    def wrapped_column_expression(self) -> _CLE: ...
    def self_group(self: _AB, against: Optional[Any] = ...) -> _AB: ...  # type: ignore[override]

class BinaryExpression(ColumnElement[_TE]):
    __visit_name__: str = ...
    left: Any = ...
    right: Any = ...
    operator: Any = ...
    type: _TE = ...  # type: ignore[assignment]
    negate: Any = ...
    modifiers: Any = ...
    @overload
    def __init__(
        self,
        left: Any,
        right: Any,
        operator: Any,
        type_: Union[_TE, Type[_TE]],
        negate: Optional[Any] = ...,
        modifiers: Optional[Any] = ...,
    ) -> None: ...
    @overload
    def __init__(
        self: BinaryExpression[sqltypes.NullType],
        left: Any,
        right: Any,
        operator: Any,
        type_: None = ...,
        negate: Optional[Any] = ...,
        modifiers: Optional[Any] = ...,
    ) -> None: ...
    def __bool__(self) -> bool: ...
    def __nonzero__(self) -> bool: ...
    @property
    def is_comparison(self) -> bool: ...
    def self_group(
        self: _BE, against: Optional[Any] = ...
    ) -> Union[_BE, Grouping[_TE]]: ...

class Slice(ColumnElement[sqltypes.NullType]):
    __visit_name__: str = ...
    start: Any = ...
    stop: Any = ...
    step: Any = ...
    type: sqltypes.NullType = ...  # type: ignore[assignment]
    def __init__(
        self,
        start: ClauseElement,
        stop: ClauseElement,
        step: ClauseElement,
        _name: Optional[Any] = ...,
    ) -> None: ...
    def self_group(self: _SL, against: Optional[Any] = ...) -> _SL: ...

class IndexExpression(BinaryExpression[_TE]): ...

class GroupedElement(ClauseElement):
    __visit_name__: str = ...
    def self_group(self: _GE, against: Optional[Any] = ...) -> _GE: ...

class Grouping(GroupedElement, ColumnElement[_TE]):  # type: ignore[misc]
    element: ClauseElement = ...
    type: _TE = ...  # type: ignore[assignment]
    @overload
    def __init__(self, element: ColumnElement[_TE]) -> None: ...
    @overload
    def __init__(
        self: Grouping[sqltypes.NullType], element: ClauseElement
    ) -> None: ...
    def __getattr__(self, attr: Any) -> Any: ...

RANGE_UNBOUNDED: langhelpers._symbol
RANGE_CURRENT: langhelpers._symbol

class Over(ColumnElement[_TE]):
    __visit_name__: str = ...
    order_by: Any = ...
    partition_by: Any = ...
    element: Any = ...
    range_: Any = ...
    rows: Any = ...
    def __init__(
        self,
        element: ColumnElement[_TE],
        partition_by: Optional[
            Union[_OverByType, Sequence[_OverByType]]
        ] = ...,
        order_by: Optional[Union[_OverByType, Sequence[_OverByType]]] = ...,
        range_: Optional[Any] = ...,
        rows: Optional[Any] = ...,
    ) -> None: ...
    def __reduce__(self) -> Any: ...
    @util.memoized_property
    def type(self) -> _TE: ...

class _WithinGroupTypeElement(Protocol[_T_co, _U_co]):
    @property
    def type(self) -> _T_co: ...
    def within_group_type(self, within_group: Any) -> _U_co: ...

class WithinGroup(ColumnElement[_TE]):
    __visit_name__: str = ...
    order_by: ClauseList[ColumnElement[Any]] = ...
    element: _WithinGroupTypeElement[Any, Any] = ...
    @overload
    def __init__(
        self: WithinGroup[_TE],
        element: _WithinGroupTypeElement[_TE, None],
        *order_by: _COLE,
    ) -> None: ...
    @overload
    def __init__(
        self: WithinGroup[_TE],
        element: _WithinGroupTypeElement[Any, _TE],
        *order_by: _COLE,
    ) -> None: ...
    def over(
        self,
        partition_by: Optional[Any] = ...,
        order_by: Optional[Any] = ...,
        range_: Optional[Any] = ...,
        rows: Optional[Any] = ...,
    ) -> Over[_TE]: ...
    @util.memoized_property
    def type(self) -> _TE: ...

class FunctionFilter(ColumnElement[_TE]):
    __visit_name__: str = ...
    criterion: Any = ...
    func: FunctionElement[_TE] = ...
    def __init__(
        self, func: FunctionElement[_TE], *criterion: ClauseElement
    ) -> None: ...
    def filter(self: _FF, *criterion: ClauseElement) -> _FF: ...
    def over(
        self,
        partition_by: Optional[Any] = ...,
        order_by: Optional[Any] = ...,
        range_: Optional[Any] = ...,
        rows: Optional[Any] = ...,
    ) -> Over[_TE]: ...
    def self_group(
        self: _FF, against: Optional[Any] = ...
    ) -> Union[_FF, Grouping[_TE]]: ...
    @util.memoized_property
    def type(self) -> _TE: ...

class Label(roles.LabeledColumnExprRole, ColumnElement[_TE]):
    __visit_name__: str = ...
    name: str = ...
    key: Any = ...
    @overload
    def __init__(
        self, name: Any, element: ColumnElement[_TE], type_: None = ...
    ) -> None: ...
    @overload
    def __init__(
        self,
        name: str,
        element: ColumnElement[Any],
        type_: Union[_TE, Type[_TE]],
    ) -> None: ...
    def __reduce__(self) -> Any: ...
    @util.memoized_property
    def type(self) -> _TE: ...
    @HasMemoized.memoized_attribute
    def element(self) -> ClauseElement: ...
    def self_group(self, against: Optional[Any] = ...) -> ClauseElement: ...  # type: ignore[override]
    @property
    def primary_key(self) -> Union[bool, ColumnSet[Any]]: ...  # type: ignore[override]
    @property
    def foreign_keys(self) -> Set[ForeignKey]: ...

class NamedColumn(ColumnElement[_TE]):
    is_literal: bool = ...
    table: Any = ...
    @util.memoized_property
    def description(self) -> util.text_type: ...

class ColumnClause(
    roles.DDLReferredColumnRole,
    roles.LabeledColumnExprRole,
    roles.StrAsPlainColumnRole,
    Immutable,
    NamedColumn[_TE],
):
    table: Any = ...
    is_literal: bool = ...
    __visit_name__: str = ...
    onupdate: Any = ...
    default: Any = ...
    server_default: Any = ...
    server_onupdate: Any = ...
    key: Any = ...
    type: Any = ...
    @overload
    def __init__(
        self: ColumnClause[sqltypes.NullType],
        text: str,
        type_: None = ...,
        is_literal: bool = ...,
        _selectable: Optional[Any] = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        text: str,
        type_: Union[_TE, Type[_TE]],
        is_literal: bool = ...,
        _selectable: Optional[Any] = ...,
    ) -> None: ...
    def get_children(self, column_tables: bool = ..., **kw: Any) -> Iterable[Any]: ...  # type: ignore[override]

class TableValuedColumn(NamedColumn[_TE]):
    __visit_name__: str = ...
    scalar_alias: Any = ...
    key: Any = ...
    type: Any = ...
    def __init__(self, scalar_alias: ClauseElement, type_: _TE) -> None: ...

class CollationClause(ColumnElement[_TE]):
    __visit_name__: str = ...
    collation: str = ...
    def __init__(self, collation: str) -> None: ...

class _IdentifiedClause(Executable, ClauseElement):
    __visit_name__: str = ...
    ident: Any = ...
    def __init__(self, ident: Any) -> None: ...

class SavepointClause(_IdentifiedClause):
    __visit_name__: str = ...

class RollbackToSavepointClause(_IdentifiedClause):
    __visit_name__: str = ...

class ReleaseSavepointClause(_IdentifiedClause):
    __visit_name__: str = ...

class quoted_name(util.MemoizedSlots, util.text_type):
    quote: Any = ...
    def __new__(cls: Type[_QN], value: Any, quote: Any) -> _QN: ...
    def __reduce__(self) -> Any: ...

class AnnotatedColumnElement(Annotated):
    def __init__(self, element: Any, values: Any) -> None: ...
    @util.memoized_property
    def name(self) -> str: ...
    @util.memoized_property
    def table(self) -> Any: ...
    @util.memoized_property
    def key(self) -> Any: ...
    @util.memoized_property
    def info(self) -> Any: ...
    @util.memoized_property
    def anon_label(self) -> Any: ...

class _truncated_label(quoted_name):
    def __new__(
        cls: Type[_QN], value: Any, quote: Optional[Any] = ...
    ) -> _QN: ...
    def __reduce__(self) -> Any: ...
    def apply_map(self: _TL, map_: Any) -> _TL: ...

class conv(_truncated_label): ...

class _anonymous_label(_truncated_label):
    @classmethod
    def safe_construct(
        cls,
        seed: int,
        body: str,
        enclosing_label: Optional[_anonymous_label] = ...,
    ) -> _anonymous_label: ...
    def __add__(self, other: Any) -> _anonymous_label: ...
    def __radd__(self, other: Any) -> _anonymous_label: ...
    def apply_map(self, map_: Any) -> Union[quoted_name, _anonymous_label]: ...  # type: ignore[override]
