from typing import Any
from typing import Dict
from typing import Tuple
from typing import Type
from typing import TypeVar

from .. import util

_A = TypeVar("_A", bound=Annotated)
_T = TypeVar("_T")

EMPTY_ANNOTATIONS: util.immutabledict[None, None]

class SupportsAnnotations: ...
class SupportsCloneAnnotations(SupportsAnnotations): ...
class SupportsWrappingAnnotations(SupportsAnnotations): ...

class Annotated:
    def __new__(cls: Type[_T], *args: Any) -> _T: ...
    __dict__: Dict[Any, Any] = ...
    def __init__(self, element: Any, values: Any) -> None: ...
    def __reduce__(self: _A) -> Tuple[Type[_A], Tuple[Any, Any]]: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    @property
    def entity_namespace(self) -> Any: ...

annotated_classes: Dict[Type[Any], Any]
