from typing import Any

from .base import _ConnDialect
from .base import Pool as Pool
from .. import exc as exc
from .. import util as util
from ..util import chop_traceback as chop_traceback
from ..util import threading as threading

class QueuePool(Pool):
    def __init__(
        self,
        creator: Any,
        pool_size: int = ...,
        max_overflow: int = ...,
        timeout: float = ...,
        use_lifo: bool = ...,
        **kw: Any,
    ) -> None: ...
    def recreate(self): ...
    def dispose(self) -> None: ...
    def status(self): ...
    def size(self): ...
    def timeout(self): ...
    def checkedin(self): ...
    def overflow(self): ...
    def checkedout(self): ...

class _AsyncConnDialect(_ConnDialect):
    is_async: bool = ...

class AsyncAdaptedQueuePool(QueuePool): ...
class FallbackAsyncAdaptedQueuePool(AsyncAdaptedQueuePool): ...

class NullPool(Pool):
    def status(self): ...
    def recreate(self): ...
    def dispose(self) -> None: ...

class SingletonThreadPool(Pool):
    size: Any = ...
    def __init__(
        self, creator: Any, pool_size: int = ..., **kw: Any
    ) -> None: ...
    def recreate(self): ...
    def dispose(self) -> None: ...
    def status(self): ...
    def connect(self): ...

class StaticPool(Pool):
    @util.memoized_property
    def connection(self): ...
    def status(self): ...
    def dispose(self) -> None: ...
    def recreate(self): ...

class AssertionPool(Pool):
    def __init__(self, *args: Any, **kw: Any) -> None: ...
    def status(self): ...
    def dispose(self) -> None: ...
    def recreate(self): ...
