from typing import Any

from . import instrumentation as instrumentation
from . import interfaces as interfaces
from . import mapperlib as mapperlib
from .attributes import QueryableAttribute as QueryableAttribute
from .query import Query as Query
from .scoping import scoped_session as scoped_session
from .session import Session as Session
from .session import sessionmaker as sessionmaker
from .. import event as event
from .. import exc as exc
from .. import util as util
from ..util.compat import inspect_getfullargspec as inspect_getfullargspec

class InstrumentationEvents(event.Events):
    def class_instrument(self, cls: Any) -> None: ...
    def class_uninstrument(self, cls: Any) -> None: ...
    def attribute_instrument(self, cls: Any, key: Any, inst: Any) -> None: ...

class _InstrumentationEventsHold:
    class_: Any = ...
    def __init__(self, class_: Any) -> None: ...
    dispatch: Any = ...

class InstanceEvents(event.Events):
    def first_init(self, manager: Any, cls: Any) -> None: ...
    def init(self, target: Any, args: Any, kwargs: Any) -> None: ...
    def init_failure(self, target: Any, args: Any, kwargs: Any) -> None: ...
    def load(self, target: Any, context: Any) -> None: ...
    def refresh(self, target: Any, context: Any, attrs: Any) -> None: ...
    def refresh_flush(
        self, target: Any, flush_context: Any, attrs: Any
    ) -> None: ...
    def expire(self, target: Any, attrs: Any) -> None: ...
    def pickle(self, target: Any, state_dict: Any) -> None: ...
    def unpickle(self, target: Any, state_dict: Any) -> None: ...

class _EventsHold(event.RefCollection):
    class_: Any = ...
    def __init__(self, class_: Any) -> None: ...
    class HoldEvents: ...
    def remove(self, event_key: Any) -> None: ...
    @classmethod
    def populate(cls, class_: Any, subject: Any) -> None: ...

class _InstanceEventsHold(_EventsHold):
    all_holds: Any = ...
    def resolve(self, class_: Any): ...
    class HoldInstanceEvents(_EventsHold.HoldEvents, InstanceEvents): ...
    dispatch: Any = ...

class MapperEvents(event.Events):
    def instrument_class(self, mapper: Any, class_: Any) -> None: ...
    def before_mapper_configured(self, mapper: Any, class_: Any) -> None: ...
    def mapper_configured(self, mapper: Any, class_: Any) -> None: ...
    def before_configured(self) -> None: ...
    def after_configured(self) -> None: ...
    def before_insert(
        self, mapper: Any, connection: Any, target: Any
    ) -> None: ...
    def after_insert(
        self, mapper: Any, connection: Any, target: Any
    ) -> None: ...
    def before_update(
        self, mapper: Any, connection: Any, target: Any
    ) -> None: ...
    def after_update(
        self, mapper: Any, connection: Any, target: Any
    ) -> None: ...
    def before_delete(
        self, mapper: Any, connection: Any, target: Any
    ) -> None: ...
    def after_delete(
        self, mapper: Any, connection: Any, target: Any
    ) -> None: ...

class _MapperEventsHold(_EventsHold):
    all_holds: Any = ...
    def resolve(self, class_: Any): ...
    class HoldMapperEvents(_EventsHold.HoldEvents, MapperEvents): ...
    dispatch: Any = ...

class SessionEvents(event.Events):
    def do_orm_execute(self, orm_execute_state: Any) -> None: ...
    def after_transaction_create(
        self, session: Any, transaction: Any
    ) -> None: ...
    def after_transaction_end(
        self, session: Any, transaction: Any
    ) -> None: ...
    def before_commit(self, session: Any) -> None: ...
    def after_commit(self, session: Any) -> None: ...
    def after_rollback(self, session: Any) -> None: ...
    def after_soft_rollback(
        self, session: Any, previous_transaction: Any
    ) -> None: ...
    def before_flush(
        self, session: Any, flush_context: Any, instances: Any
    ) -> None: ...
    def after_flush(self, session: Any, flush_context: Any) -> None: ...
    def after_flush_postexec(
        self, session: Any, flush_context: Any
    ) -> None: ...
    def after_begin(
        self, session: Any, transaction: Any, connection: Any
    ) -> None: ...
    def before_attach(self, session: Any, instance: Any) -> None: ...
    def after_attach(self, session: Any, instance: Any) -> None: ...
    def after_bulk_update(self, update_context: Any) -> None: ...
    def after_bulk_delete(self, delete_context: Any) -> None: ...
    def transient_to_pending(self, session: Any, instance: Any) -> None: ...
    def pending_to_transient(self, session: Any, instance: Any) -> None: ...
    def persistent_to_transient(self, session: Any, instance: Any) -> None: ...
    def pending_to_persistent(self, session: Any, instance: Any) -> None: ...
    def detached_to_persistent(self, session: Any, instance: Any) -> None: ...
    def loaded_as_persistent(self, session: Any, instance: Any) -> None: ...
    def persistent_to_deleted(self, session: Any, instance: Any) -> None: ...
    def deleted_to_persistent(self, session: Any, instance: Any) -> None: ...
    def deleted_to_detached(self, session: Any, instance: Any) -> None: ...
    def persistent_to_detached(self, session: Any, instance: Any) -> None: ...

class AttributeEvents(event.Events):
    def append(self, target: Any, value: Any, initiator: Any) -> None: ...
    def bulk_replace(
        self, target: Any, values: Any, initiator: Any
    ) -> None: ...
    def remove(self, target: Any, value: Any, initiator: Any) -> None: ...
    def set(
        self, target: Any, value: Any, oldvalue: Any, initiator: Any
    ) -> None: ...
    def init_scalar(self, target: Any, value: Any, dict_: Any) -> None: ...
    def init_collection(
        self, target: Any, collection: Any, collection_adapter: Any
    ) -> None: ...
    def dispose_collection(
        self, target: Any, collection: Any, collection_adapter: Any
    ) -> None: ...
    def modified(self, target: Any, initiator: Any) -> None: ...

class QueryEvents(event.Events):
    def before_compile(self, query: Any) -> None: ...
    def before_compile_update(
        self, query: Any, update_context: Any
    ) -> None: ...
    def before_compile_delete(
        self, query: Any, delete_context: Any
    ) -> None: ...
