from typing import Any

from sqlalchemy.orm import attributes as attributes
from sqlalchemy.orm import instrumentation as instrumentation
from . import clsregistry as clsregistry
from .attributes import QueryableAttribute as QueryableAttribute
from .base import InspectionAttr as InspectionAttr
from .descriptor_props import CompositeProperty as CompositeProperty
from .descriptor_props import SynonymProperty as SynonymProperty
from .interfaces import MapperProperty as MapperProperty
from .properties import ColumnProperty as ColumnProperty
from .util import class_mapper as class_mapper
from .. import event as event
from .. import exc as exc
from .. import util as util
from ..sql import expression as expression
from ..sql.schema import Column as Column
from ..sql.schema import Table as Table
from ..util import topological as topological

class _MapperConfig:
    @classmethod
    def setup_mapping(
        cls, registry: Any, cls_: Any, dict_: Any, table: Any, mapper_kw: Any
    ): ...
    cls: Any = ...
    classname: Any = ...
    properties: Any = ...
    declared_attr_reg: Any = ...
    def __init__(self, registry: Any, cls_: Any) -> None: ...
    def set_cls_attribute(self, attrname: Any, value: Any): ...

class _ImperativeMapperConfig(_MapperConfig):
    dict_: Any = ...
    local_table: Any = ...
    def __init__(
        self, registry: Any, cls_: Any, table: Any, mapper_kw: Any
    ) -> None: ...
    def map(self, mapper_kw: Any = ...): ...

class _ClassScanMapperConfig(_MapperConfig):
    dict_: Any = ...
    persist_selectable: Any = ...
    declared_columns: Any = ...
    column_copies: Any = ...
    def __init__(
        self, registry: Any, cls_: Any, dict_: Any, table: Any, mapper_kw: Any
    ) -> None: ...
    def map(self, mapper_kw: Any = ...): ...

class _DeferredMapperConfig(_ClassScanMapperConfig):
    @property
    def cls(self): ...
    @cls.setter
    def cls(self, class_: Any) -> None: ...
    @classmethod
    def has_cls(cls, class_: Any): ...
    @classmethod
    def raise_unmapped_for_cls(cls, class_: Any) -> None: ...
    @classmethod
    def config_for_cls(cls, class_: Any): ...
    @classmethod
    def classes_for_base(cls, base_cls: Any, sort: bool = ...): ...
    def map(self, mapper_kw: Any = ...): ...
