import abc
from typing import Any
from typing import Generator
from typing import Generic
from typing import TypeVar

_T = TypeVar("_T")

class StartableContext(abc.ABC, Generic[_T], metaclass=abc.ABCMeta):
    @abc.abstractmethod
    async def start(self) -> _T: ...
    def __await__(self) -> Generator[Any, None, _T]: ...
    async def __aenter__(self) -> _T: ...
    @abc.abstractmethod
    async def __aexit__(
        self, type_: Any, value: Any, traceback: Any
    ) -> None: ...

class ProxyComparable:
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
