from typing import Any
from typing import Optional

from .base import ENUM as ENUM
from .base import PGCompiler as PGCompiler
from .base import PGDialect as PGDialect
from .base import PGExecutionContext as PGExecutionContext
from .base import PGIdentifierPreparer as PGIdentifierPreparer
from .base import UUID as UUID
from .hstore import HSTORE as HSTORE
from .json import JSON as JSON
from .json import JSONB as JSONB
from ... import exc as exc
from ... import processors as processors
from ... import types as sqltypes
from ... import util as util
from ...util import collections_abc as collections_abc

logger: Any

class _PGNumeric(sqltypes.Numeric):
    def bind_processor(self, dialect: Any) -> None: ...
    def result_processor(self, dialect: Any, coltype: Any): ...

class _PGEnum(ENUM):
    def result_processor(self, dialect: Any, coltype: Any): ...

class _PGHStore(HSTORE):
    def bind_processor(self, dialect: Any): ...
    def result_processor(self, dialect: Any, coltype: Any): ...

class _PGJSON(JSON):
    def result_processor(self, dialect: Any, coltype: Any) -> None: ...

class _PGJSONB(JSONB):
    def result_processor(self, dialect: Any, coltype: Any) -> None: ...

class _PGUUID(UUID):
    def bind_processor(self, dialect: Any): ...
    def result_processor(self, dialect: Any, coltype: Any): ...

class PGExecutionContext_psycopg2(PGExecutionContext):
    def create_server_side_cursor(self): ...
    cursor_fetch_strategy: Any = ...
    def post_exec(self) -> None: ...

class PGCompiler_psycopg2(PGCompiler): ...
class PGIdentifierPreparer_psycopg2(PGIdentifierPreparer): ...

EXECUTEMANY_PLAIN: Any
EXECUTEMANY_BATCH: Any
EXECUTEMANY_VALUES: Any
EXECUTEMANY_VALUES_PLUS_BATCH: Any

class PGDialect_psycopg2(PGDialect):
    driver: str = ...
    supports_unicode_statements: bool = ...
    supports_server_side_cursors: bool = ...
    default_paramstyle: str = ...
    supports_sane_multi_rowcount: bool = ...
    execution_ctx_cls: Any = ...
    statement_compiler: Any = ...
    preparer: Any = ...
    psycopg2_version: Any = ...
    engine_config_types: Any = ...
    colspecs: Any = ...
    use_native_unicode: Any = ...
    use_native_hstore: Any = ...
    use_native_uuid: Any = ...
    supports_unicode_binds: Any = ...
    client_encoding: Any = ...
    executemany_mode: Any = ...
    insert_executemany_returning: bool = ...
    executemany_batch_page_size: Any = ...
    executemany_values_page_size: Any = ...
    def __init__(
        self,
        use_native_unicode: bool = ...,
        client_encoding: Optional[Any] = ...,
        use_native_hstore: bool = ...,
        use_native_uuid: bool = ...,
        executemany_mode: str = ...,
        executemany_batch_page_size: int = ...,
        executemany_values_page_size: int = ...,
        **kwargs: Any,
    ) -> None: ...
    def initialize(self, connection: Any) -> None: ...
    @classmethod
    def dbapi(cls): ...
    def set_isolation_level(self, connection: Any, level: Any) -> None: ...
    def set_readonly(self, connection: Any, value: Any) -> None: ...
    def get_readonly(self, connection: Any): ...
    def set_deferrable(self, connection: Any, value: Any) -> None: ...
    def get_deferrable(self, connection: Any): ...
    def on_connect(self): ...
    def do_executemany(
        self,
        cursor: Any,
        statement: Any,
        parameters: Any,
        context: Optional[Any] = ...,
    ) -> None: ...
    def create_connect_args(self, url: Any): ...
    def is_disconnect(self, e: Any, connection: Any, cursor: Any): ...

dialect = PGDialect_psycopg2
