from typing import Any
from typing import Optional

from .base import BINARY as BINARY
from .base import DATETIMEOFFSET as DATETIMEOFFSET
from .base import MSDialect as MSDialect
from .base import MSExecutionContext as MSExecutionContext
from .base import VARBINARY as VARBINARY
from ... import exc as exc
from ... import types as sqltypes
from ... import util as util
from ...connectors.pyodbc import PyODBCConnector as PyODBCConnector

class _ms_numeric_pyodbc:
    def bind_processor(self, dialect: Any): ...

class _MSNumeric_pyodbc(_ms_numeric_pyodbc, sqltypes.Numeric): ...
class _MSFloat_pyodbc(_ms_numeric_pyodbc, sqltypes.Float): ...

class _ms_binary_pyodbc:
    def bind_processor(self, dialect: Any): ...

class _ODBCDateTimeOffset(DATETIMEOFFSET):
    def bind_processor(self, dialect: Any): ...

class _VARBINARY_pyodbc(_ms_binary_pyodbc, VARBINARY): ...
class _BINARY_pyodbc(_ms_binary_pyodbc, BINARY): ...

class MSExecutionContext_pyodbc(MSExecutionContext):
    def pre_exec(self) -> None: ...
    def post_exec(self) -> None: ...

class MSDialect_pyodbc(PyODBCConnector, MSDialect):
    supports_sane_rowcount_returning: bool = ...
    execution_ctx_cls: Any = ...
    colspecs: Any = ...
    description_encoding: Any = ...
    use_scope_identity: Any = ...
    fast_executemany: Any = ...
    def __init__(
        self,
        description_encoding: Optional[Any] = ...,
        fast_executemany: bool = ...,
        **params: Any,
    ) -> None: ...
    def on_connect(self): ...
    def do_executemany(
        self,
        cursor: Any,
        statement: Any,
        parameters: Any,
        context: Optional[Any] = ...,
    ) -> None: ...
    def is_disconnect(self, e: Any, connection: Any, cursor: Any): ...

dialect = MSDialect_pyodbc
