from typing import Any
from typing import Optional

from .json import JSON as JSON
from .json import JSONIndexType as JSONIndexType
from .json import JSONPathType as JSONPathType
from ... import exc as exc
from ... import Identity as Identity
from ... import Sequence as Sequence
from ... import sql as sql
from ... import types as sqltypes
from ... import util as util
from ...engine import default as default
from ...engine import reflection as reflection
from ...sql import coercions as coercions
from ...sql import compiler as compiler
from ...sql import elements as elements
from ...sql import expression as expression
from ...sql import func as func
from ...sql import quoted_name as quoted_name
from ...sql import roles as roles
from ...types import BIGINT as BIGINT
from ...types import BINARY as BINARY
from ...types import CHAR as CHAR
from ...types import DATE as DATE
from ...types import DATETIME as DATETIME
from ...types import DECIMAL as DECIMAL
from ...types import FLOAT as FLOAT
from ...types import INTEGER as INTEGER
from ...types import NCHAR as NCHAR
from ...types import NUMERIC as NUMERIC
from ...types import NVARCHAR as NVARCHAR
from ...types import SMALLINT as SMALLINT
from ...types import TEXT as TEXT
from ...types import VARCHAR as VARCHAR
from ...util import compat as compat
from ...util import update_wrapper as update_wrapper
from ...util.langhelpers import public_factory as public_factory

MS_2017_VERSION: Any
MS_2016_VERSION: Any
MS_2014_VERSION: Any
MS_2012_VERSION: Any
MS_2008_VERSION: Any
MS_2005_VERSION: Any
MS_2000_VERSION: Any
RESERVED_WORDS: Any

class REAL(sqltypes.REAL):
    __visit_name__: str = ...
    def __init__(self, **kw: Any) -> None: ...

class TINYINT(sqltypes.Integer):
    __visit_name__: str = ...

class _MSDate(sqltypes.Date):
    def bind_processor(self, dialect: Any): ...
    def result_processor(self, dialect: Any, coltype: Any): ...

class TIME(sqltypes.TIME):
    precision: Any = ...
    def __init__(
        self, precision: Optional[Any] = ..., **kwargs: Any
    ) -> None: ...
    def bind_processor(self, dialect: Any): ...
    def result_processor(self, dialect: Any, coltype: Any): ...

class _DateTimeBase:
    def bind_processor(self, dialect: Any): ...

class _MSDateTime(_DateTimeBase, sqltypes.DateTime): ...

class SMALLDATETIME(_DateTimeBase, sqltypes.DateTime):
    __visit_name__: str = ...

class DATETIME2(_DateTimeBase, sqltypes.DateTime):
    __visit_name__: str = ...
    precision: Any = ...
    def __init__(self, precision: Optional[Any] = ..., **kw: Any) -> None: ...

class DATETIMEOFFSET(_DateTimeBase, sqltypes.DateTime):
    __visit_name__: str = ...
    precision: Any = ...
    def __init__(self, precision: Optional[Any] = ..., **kw: Any) -> None: ...

class _UnicodeLiteral:
    def literal_processor(self, dialect: Any): ...

class _MSUnicode(_UnicodeLiteral, sqltypes.Unicode): ...
class _MSUnicodeText(_UnicodeLiteral, sqltypes.UnicodeText): ...

class TIMESTAMP(sqltypes._Binary):
    __visit_name__: str = ...
    length: Any = ...
    convert_int: Any = ...
    def __init__(self, convert_int: bool = ...) -> None: ...
    def result_processor(self, dialect: Any, coltype: Any): ...

class ROWVERSION(TIMESTAMP):
    __visit_name__: str = ...

class NTEXT(sqltypes.UnicodeText):
    __visit_name__: str = ...

class VARBINARY(sqltypes.VARBINARY, sqltypes.LargeBinary):
    __visit_name__: str = ...

class IMAGE(sqltypes.LargeBinary):
    __visit_name__: str = ...

class XML(sqltypes.Text):
    __visit_name__: str = ...

class BIT(sqltypes.TypeEngine):
    __visit_name__: str = ...

class MONEY(sqltypes.TypeEngine):
    __visit_name__: str = ...

class SMALLMONEY(sqltypes.TypeEngine):
    __visit_name__: str = ...

class UNIQUEIDENTIFIER(sqltypes.TypeEngine):
    __visit_name__: str = ...

class SQL_VARIANT(sqltypes.TypeEngine):
    __visit_name__: str = ...

class TryCast(sql.elements.Cast):
    __visit_name__: str = ...
    stringify_dialect: str = ...
    def __init__(self, *arg: Any, **kw: Any) -> None: ...

try_cast: Any
MSDateTime: Any
MSDate: Any
MSReal = REAL
MSTinyInteger = TINYINT
MSTime = TIME
MSSmallDateTime = SMALLDATETIME
MSDateTime2 = DATETIME2
MSDateTimeOffset = DATETIMEOFFSET
MSText = TEXT
MSNText = NTEXT
MSString = VARCHAR
MSNVarchar = NVARCHAR
MSChar = CHAR
MSNChar = NCHAR
MSBinary = BINARY
MSVarBinary = VARBINARY
MSImage = IMAGE
MSBit = BIT
MSMoney = MONEY
MSSmallMoney = SMALLMONEY
MSUniqueIdentifier = UNIQUEIDENTIFIER
MSVariant = SQL_VARIANT
ischema_names: Any

class MSTypeCompiler(compiler.GenericTypeCompiler):
    def visit_FLOAT(self, type_: Any, **kw: Any): ...
    def visit_TINYINT(self, type_: Any, **kw: Any): ...
    def visit_DATETIMEOFFSET(self, type_: Any, **kw: Any): ...
    def visit_TIME(self, type_: Any, **kw: Any): ...
    def visit_TIMESTAMP(self, type_: Any, **kw: Any): ...
    def visit_ROWVERSION(self, type_: Any, **kw: Any): ...
    def visit_DATETIME2(self, type_: Any, **kw: Any): ...
    def visit_SMALLDATETIME(self, type_: Any, **kw: Any): ...
    def visit_unicode(self, type_: Any, **kw: Any): ...
    def visit_text(self, type_: Any, **kw: Any): ...
    def visit_unicode_text(self, type_: Any, **kw: Any): ...
    def visit_NTEXT(self, type_: Any, **kw: Any): ...
    def visit_TEXT(self, type_: Any, **kw: Any): ...
    def visit_VARCHAR(self, type_: Any, **kw: Any): ...
    def visit_CHAR(self, type_: Any, **kw: Any): ...
    def visit_NCHAR(self, type_: Any, **kw: Any): ...
    def visit_NVARCHAR(self, type_: Any, **kw: Any): ...
    def visit_date(self, type_: Any, **kw: Any): ...
    def visit_time(self, type_: Any, **kw: Any): ...
    def visit_large_binary(self, type_: Any, **kw: Any): ...
    def visit_IMAGE(self, type_: Any, **kw: Any): ...
    def visit_XML(self, type_: Any, **kw: Any): ...
    def visit_VARBINARY(self, type_: Any, **kw: Any): ...
    def visit_boolean(self, type_: Any, **kw: Any): ...
    def visit_BIT(self, type_: Any, **kw: Any): ...
    def visit_JSON(self, type_: Any, **kw: Any): ...
    def visit_MONEY(self, type_: Any, **kw: Any): ...
    def visit_SMALLMONEY(self, type_: Any, **kw: Any): ...
    def visit_UNIQUEIDENTIFIER(self, type_: Any, **kw: Any): ...
    def visit_SQL_VARIANT(self, type_: Any, **kw: Any): ...

class MSExecutionContext(default.DefaultExecutionContext):
    def pre_exec(self) -> None: ...
    cursor_fetch_strategy: Any = ...
    def post_exec(self) -> None: ...
    def get_lastrowid(self): ...
    @property
    def rowcount(self): ...
    def handle_dbapi_exception(self, e: Any) -> None: ...
    def get_result_cursor_strategy(self, result: Any): ...
    def fire_sequence(self, seq: Any, type_: Any): ...
    def get_insert_default(self, column: Any): ...

class MSSQLCompiler(compiler.SQLCompiler):
    returning_precedes_values: bool = ...
    extract_map: Any = ...
    tablealiases: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def visit_now_func(self, fn: Any, **kw: Any): ...
    def visit_current_date_func(self, fn: Any, **kw: Any): ...
    def visit_length_func(self, fn: Any, **kw: Any): ...
    def visit_char_length_func(self, fn: Any, **kw: Any): ...
    def visit_concat_op_binary(
        self, binary: Any, operator: Any, **kw: Any
    ): ...
    def visit_true(self, expr: Any, **kw: Any): ...
    def visit_false(self, expr: Any, **kw: Any): ...
    def visit_match_op_binary(self, binary: Any, operator: Any, **kw: Any): ...
    def get_select_precolumns(self, select: Any, **kw: Any): ...
    def get_from_hint_text(self, table: Any, text: Any): ...
    def get_crud_hint_text(self, table: Any, text: Any): ...
    def fetch_clause(self, cs: Any, **kwargs: Any): ...
    def limit_clause(self, cs: Any, **kwargs: Any): ...
    def visit_try_cast(self, element: Any, **kw: Any): ...
    def translate_select_structure(self, select_stmt: Any, **kwargs: Any): ...
    def visit_table(
        self,
        table: Any,
        mssql_aliased: bool = ...,
        iscrud: bool = ...,
        **kwargs: Any,
    ): ...
    def visit_alias(self, alias: Any, **kw: Any): ...
    def visit_column(
        self, column: Any, add_to_result_map: Optional[Any] = ..., **kw: Any
    ): ...
    def visit_extract(self, extract: Any, **kw: Any): ...
    def visit_savepoint(self, savepoint_stmt: Any): ...
    def visit_rollback_to_savepoint(self, savepoint_stmt: Any): ...
    def visit_binary(self, binary: Any, **kwargs: Any): ...
    def returning_clause(self, stmt: Any, returning_cols: Any): ...
    def get_cte_preamble(self, recursive: Any): ...
    def label_select_column(self, select: Any, column: Any, asfrom: Any): ...
    def for_update_clause(self, select: Any, **kw: Any): ...
    def order_by_clause(self, select: Any, **kw: Any): ...
    def update_from_clause(
        self,
        update_stmt: Any,
        from_table: Any,
        extra_froms: Any,
        from_hints: Any,
        **kw: Any,
    ): ...
    def delete_table_clause(
        self, delete_stmt: Any, from_table: Any, extra_froms: Any
    ): ...
    def delete_extra_from_clause(
        self,
        delete_stmt: Any,
        from_table: Any,
        extra_froms: Any,
        from_hints: Any,
        **kw: Any,
    ): ...
    def visit_empty_set_expr(self, type_: Any): ...
    def visit_is_distinct_from_binary(
        self, binary: Any, operator: Any, **kw: Any
    ): ...
    def visit_is_not_distinct_from_binary(
        self, binary: Any, operator: Any, **kw: Any
    ): ...
    def visit_json_getitem_op_binary(
        self, binary: Any, operator: Any, **kw: Any
    ): ...
    def visit_json_path_getitem_op_binary(
        self, binary: Any, operator: Any, **kw: Any
    ): ...
    def visit_sequence(self, seq: Any, **kw: Any): ...

class MSSQLStrictCompiler(MSSQLCompiler):
    ansi_bind_rules: bool = ...
    def visit_in_op_binary(self, binary: Any, operator: Any, **kw: Any): ...
    def visit_not_in_op_binary(
        self, binary: Any, operator: Any, **kw: Any
    ): ...
    def render_literal_value(self, value: Any, type_: Any): ...

class MSDDLCompiler(compiler.DDLCompiler):
    def get_column_specification(self, column: Any, **kwargs: Any): ...
    def visit_create_index(self, create: Any, include_schema: bool = ...): ...
    def visit_drop_index(self, drop: Any): ...
    def visit_primary_key_constraint(self, constraint: Any): ...
    def visit_unique_constraint(self, constraint: Any): ...
    def visit_computed_column(self, generated: Any): ...
    def visit_create_sequence(self, create: Any, **kw: Any): ...
    def visit_identity_column(self, identity: Any, **kw: Any): ...

class MSIdentifierPreparer(compiler.IdentifierPreparer):
    reserved_words: Any = ...
    def __init__(self, dialect: Any) -> None: ...
    def quote_schema(self, schema: Any, force: Optional[Any] = ...): ...

class MSDialect(default.DefaultDialect):
    name: str = ...
    supports_default_values: bool = ...
    supports_empty_insert: bool = ...
    execution_ctx_cls: Any = ...
    use_scope_identity: bool = ...
    max_identifier_length: int = ...
    schema_name: str = ...
    implicit_returning: bool = ...
    full_returning: bool = ...
    colspecs: Any = ...
    engine_config_types: Any = ...
    ischema_names: Any = ...
    supports_sequences: bool = ...
    sequences_optional: bool = ...
    default_sequence_base: int = ...
    supports_native_boolean: bool = ...
    non_native_boolean_check_constraint: bool = ...
    supports_unicode_binds: bool = ...
    postfetch_lastrowid: bool = ...
    legacy_schema_aliasing: bool = ...
    server_version_info: Any = ...
    statement_compiler: Any = ...
    ddl_compiler: Any = ...
    type_compiler: Any = ...
    preparer: Any = ...
    construct_arguments: Any = ...
    query_timeout: Any = ...
    deprecate_large_types: Any = ...
    isolation_level: Any = ...
    def __init__(
        self,
        query_timeout: Optional[Any] = ...,
        use_scope_identity: bool = ...,
        schema_name: str = ...,
        isolation_level: Optional[Any] = ...,
        deprecate_large_types: Optional[Any] = ...,
        json_serializer: Optional[Any] = ...,
        json_deserializer: Optional[Any] = ...,
        legacy_schema_aliasing: Optional[Any] = ...,
        **opts: Any,
    ) -> None: ...
    def do_savepoint(self, connection: Any, name: Any) -> None: ...
    def do_release_savepoint(self, connection: Any, name: Any) -> None: ...
    def set_isolation_level(self, connection: Any, level: Any) -> None: ...
    def get_isolation_level(self, connection: Any): ...
    def initialize(self, connection: Any) -> None: ...
    def on_connect(self): ...
    def has_table(
        self,
        connection: Any,
        tablename: Any,
        dbname: Any,
        owner: Any,
        schema: Any,
    ): ...
    def has_sequence(
        self,
        connection: Any,
        sequencename: Any,
        dbname: Any,
        owner: Any,
        schema: Any,
    ): ...
    def get_sequence_names(
        self, connection: Any, dbname: Any, owner: Any, schema: Any, **kw: Any
    ): ...
    def get_schema_names(self, connection: Any, **kw: Any): ...
    def get_table_names(
        self, connection: Any, dbname: Any, owner: Any, schema: Any, **kw: Any
    ): ...
    def get_view_names(
        self, connection: Any, dbname: Any, owner: Any, schema: Any, **kw: Any
    ): ...
    def get_indexes(
        self,
        connection: Any,
        tablename: Any,
        dbname: Any,
        owner: Any,
        schema: Any,
        **kw: Any,
    ): ...
    def get_view_definition(
        self,
        connection: Any,
        viewname: Any,
        dbname: Any,
        owner: Any,
        schema: Any,
        **kw: Any,
    ): ...
    def get_columns(
        self,
        connection: Any,
        tablename: Any,
        dbname: Any,
        owner: Any,
        schema: Any,
        **kw: Any,
    ): ...
    def get_pk_constraint(
        self,
        connection: Any,
        tablename: Any,
        dbname: Any,
        owner: Any,
        schema: Any,
        **kw: Any,
    ): ...
    def get_foreign_keys(
        self,
        connection: Any,
        tablename: Any,
        dbname: Any,
        owner: Any,
        schema: Any,
        **kw: Any,
    ): ...
