# fmt: off
from typing import Any
from typing import Optional

from . import attributes as attributes
from . import instrumentation as instrumentation
from . import loading as loading
from . import properties as properties
from .base import class_mapper as class_mapper
from .base import state_str as state_str
from .interfaces import EXT_SKIP as EXT_SKIP
from .interfaces import InspectionAttr as InspectionAttr
from .interfaces import MapperProperty as MapperProperty
from .interfaces import ORMEntityColumnsClauseRole as ORMEntityColumnsClauseRole
from .interfaces import ORMFromClauseRole as ORMFromClauseRole
from .path_registry import PathRegistry as PathRegistry
from .. import event as event
from .. import inspection as inspection
from .. import log as log
from .. import schema as schema
from .. import sql as sql
from .. import util as util
from ..sql import base as sql_base
from ..sql import coercions as coercions
from ..sql import expression as expression
from ..sql import operators as operators
from ..sql import roles as roles
from ..sql import visitors as visitors
from ..sql.selectable import LABEL_STYLE_TABLENAME_PLUS_COL as LABEL_STYLE_TABLENAME_PLUS_COL
from ..util import HasMemoized as HasMemoized
# fmt: on

NO_ATTRIBUTE: Any

class Mapper(
    ORMFromClauseRole,
    ORMEntityColumnsClauseRole,
    sql_base.MemoizedHasCacheKey,
    InspectionAttr,
):
    class_: Any = ...
    class_manager: Any = ...
    non_primary: Any = ...
    always_refresh: Any = ...
    version_id_prop: Any = ...
    version_id_col: Any = ...
    version_id_generator: bool = ...
    concrete: Any = ...
    single: bool = ...
    inherits: Any = ...
    local_table: Any = ...
    inherit_condition: Any = ...
    inherit_foreign_keys: Any = ...
    batch: Any = ...
    eager_defaults: Any = ...
    column_prefix: Any = ...
    polymorphic_on: Any = ...
    validators: Any = ...
    passive_updates: Any = ...
    passive_deletes: Any = ...
    legacy_is_orphan: Any = ...
    allow_partial_pks: Any = ...
    confirm_deleted_rows: bool = ...
    polymorphic_load: Any = ...
    polymorphic_identity: Any = ...
    polymorphic_map: Any = ...
    include_properties: Any = ...
    exclude_properties: Any = ...
    def __init__(
        self,
        class_: Any,
        local_table: Optional[Any] = ...,
        properties: Optional[Any] = ...,
        primary_key: Optional[Any] = ...,
        non_primary: bool = ...,
        inherits: Optional[Any] = ...,
        inherit_condition: Optional[Any] = ...,
        inherit_foreign_keys: Optional[Any] = ...,
        always_refresh: bool = ...,
        version_id_col: Optional[Any] = ...,
        version_id_generator: Optional[Any] = ...,
        polymorphic_on: Optional[Any] = ...,
        _polymorphic_map: Optional[Any] = ...,
        polymorphic_identity: Optional[Any] = ...,
        concrete: bool = ...,
        with_polymorphic: Optional[Any] = ...,
        polymorphic_load: Optional[Any] = ...,
        allow_partial_pks: bool = ...,
        batch: bool = ...,
        column_prefix: Optional[Any] = ...,
        include_properties: Optional[Any] = ...,
        exclude_properties: Optional[Any] = ...,
        passive_updates: bool = ...,
        passive_deletes: bool = ...,
        confirm_deleted_rows: bool = ...,
        eager_defaults: bool = ...,
        legacy_is_orphan: bool = ...,
        _compiled_cache_size: int = ...,
    ): ...
    is_mapper: bool = ...
    represents_outer_join: bool = ...
    @property
    def mapper(self): ...
    @property
    def entity(self): ...
    persist_selectable: Any = ...
    configured: bool = ...
    tables: Any = ...
    primary_key: Any = ...
    base_mapper: Any = ...
    columns: Any = ...
    c: Any = ...
    @property
    def mapped_table(self): ...
    def add_properties(self, dict_of_properties: Any) -> None: ...
    def add_property(self, key: Any, prop: Any) -> None: ...
    def has_property(self, key: Any): ...
    def get_property(self, key: Any, _configure_mappers: bool = ...): ...
    def get_property_by_column(self, column: Any): ...
    @property
    def iterate_properties(self): ...
    with_polymorphic_mappers: Any = ...
    @HasMemoized.memoized_instancemethod
    def __clause_element__(self): ...
    @util.memoized_property
    def select_identity_token(self): ...
    @property
    def selectable(self): ...
    @HasMemoized.memoized_attribute
    def attrs(self): ...
    @HasMemoized.memoized_attribute
    def all_orm_descriptors(self): ...
    @HasMemoized.memoized_attribute
    def synonyms(self): ...
    @property
    def entity_namespace(self): ...
    @HasMemoized.memoized_attribute
    def column_attrs(self): ...
    @HasMemoized.memoized_attribute
    def relationships(self): ...
    @HasMemoized.memoized_attribute
    def composites(self): ...
    def common_parent(self, other: Any): ...
    def is_sibling(self, other: Any): ...
    def isa(self, other: Any): ...
    def iterate_to_root(self) -> None: ...
    @HasMemoized.memoized_attribute
    def self_and_descendants(self): ...
    def polymorphic_iterator(self): ...
    def primary_mapper(self): ...
    @property
    def primary_base_mapper(self): ...
    def identity_key_from_row(
        self,
        row: Any,
        identity_token: Optional[Any] = ...,
        adapter: Optional[Any] = ...,
    ): ...
    def identity_key_from_primary_key(
        self, primary_key: Any, identity_token: Optional[Any] = ...
    ): ...
    def identity_key_from_instance(self, instance: Any): ...
    def primary_key_from_instance(self, instance: Any): ...
    def cascade_iterator(
        self, type_: Any, state: Any, halt_on: Optional[Any] = ...
    ) -> None: ...

class _OptGetColumnsNotAvailable(Exception): ...

def configure_mappers() -> None: ...
def reconstructor(fn: Any): ...
def validates(*names: Any, **kw: Any): ...

class _ColumnMapping(dict):
    mapper: Any = ...
    def __init__(self, mapper: Any) -> None: ...
    def __missing__(self, column: Any) -> None: ...
