from typing import Any

from . import attributes as attributes
from . import exc as exc
from . import sync as sync
from . import unitofwork as unitofwork
from .interfaces import MANYTOMANY as MANYTOMANY
from .interfaces import MANYTOONE as MANYTOONE
from .interfaces import ONETOMANY as ONETOMANY
from .. import sql as sql
from .. import util as util

class DependencyProcessor:
    prop: Any = ...
    cascade: Any = ...
    mapper: Any = ...
    parent: Any = ...
    secondary: Any = ...
    direction: Any = ...
    post_update: Any = ...
    passive_deletes: Any = ...
    passive_updates: Any = ...
    enable_typechecks: Any = ...
    sort_key: Any = ...
    key: Any = ...
    def __init__(self, prop: Any) -> None: ...
    @classmethod
    def from_relationship(cls, prop: Any): ...
    def hasparent(self, state: Any): ...
    def per_property_preprocessors(self, uow: Any) -> None: ...
    def per_property_flush_actions(self, uow: Any) -> None: ...
    def per_state_flush_actions(
        self, uow: Any, states: Any, isdelete: Any
    ) -> None: ...
    def presort_deletes(self, uowcommit: Any, states: Any): ...
    def presort_saves(self, uowcommit: Any, states: Any): ...
    def process_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def process_saves(self, uowcommit: Any, states: Any) -> None: ...
    def prop_has_changes(self, uowcommit: Any, states: Any, isdelete: Any): ...

class OneToManyDP(DependencyProcessor):
    def per_property_dependencies(
        self,
        uow: Any,
        parent_saves: Any,
        child_saves: Any,
        parent_deletes: Any,
        child_deletes: Any,
        after_save: Any,
        before_delete: Any,
    ) -> None: ...
    def per_state_dependencies(
        self,
        uow: Any,
        save_parent: Any,
        delete_parent: Any,
        child_action: Any,
        after_save: Any,
        before_delete: Any,
        isdelete: Any,
        childisdelete: Any,
    ) -> None: ...
    def presort_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def presort_saves(self, uowcommit: Any, states: Any) -> None: ...
    def process_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def process_saves(self, uowcommit: Any, states: Any) -> None: ...

class ManyToOneDP(DependencyProcessor):
    def __init__(self, prop: Any) -> None: ...
    def per_property_dependencies(
        self,
        uow: Any,
        parent_saves: Any,
        child_saves: Any,
        parent_deletes: Any,
        child_deletes: Any,
        after_save: Any,
        before_delete: Any,
    ) -> None: ...
    def per_state_dependencies(
        self,
        uow: Any,
        save_parent: Any,
        delete_parent: Any,
        child_action: Any,
        after_save: Any,
        before_delete: Any,
        isdelete: Any,
        childisdelete: Any,
    ) -> None: ...
    def presort_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def presort_saves(self, uowcommit: Any, states: Any) -> None: ...
    def process_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def process_saves(self, uowcommit: Any, states: Any) -> None: ...

class DetectKeySwitch(DependencyProcessor):
    def per_property_preprocessors(self, uow: Any) -> None: ...
    def per_property_flush_actions(self, uow: Any) -> None: ...
    def per_state_flush_actions(
        self, uow: Any, states: Any, isdelete: Any
    ) -> None: ...
    def presort_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def presort_saves(self, uow: Any, states: Any) -> None: ...
    def prop_has_changes(self, uow: Any, states: Any, isdelete: Any): ...
    def process_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def process_saves(self, uowcommit: Any, states: Any) -> None: ...

class ManyToManyDP(DependencyProcessor):
    def per_property_dependencies(
        self,
        uow: Any,
        parent_saves: Any,
        child_saves: Any,
        parent_deletes: Any,
        child_deletes: Any,
        after_save: Any,
        before_delete: Any,
    ) -> None: ...
    def per_state_dependencies(
        self,
        uow: Any,
        save_parent: Any,
        delete_parent: Any,
        child_action: Any,
        after_save: Any,
        before_delete: Any,
        isdelete: Any,
        childisdelete: Any,
    ) -> None: ...
    def presort_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def presort_saves(self, uowcommit: Any, states: Any) -> None: ...
    def process_deletes(self, uowcommit: Any, states: Any) -> None: ...
    def process_saves(self, uowcommit: Any, states: Any) -> None: ...
