from collections import namedtuple
from typing import Any
from typing import Generic
from typing import Optional
from typing import overload
from typing import Type
from typing import TypeVar

from . import collections as collections
from . import interfaces as interfaces
from .base import ATTR_EMPTY as ATTR_EMPTY
from .base import ATTR_WAS_SET as ATTR_WAS_SET
from .base import CALLABLES_OK as CALLABLES_OK
from .base import INIT_OK as INIT_OK
from .base import instance_dict as instance_dict
from .base import instance_state as instance_state
from .base import instance_str as instance_str
from .base import LOAD_AGAINST_COMMITTED as LOAD_AGAINST_COMMITTED
from .base import manager_of_class as manager_of_class
from .base import NEVER_SET as NEVER_SET
from .base import NO_AUTOFLUSH as NO_AUTOFLUSH
from .base import NO_CHANGE as NO_CHANGE
from .base import NO_RAISE as NO_RAISE
from .base import NO_VALUE as NO_VALUE
from .base import NON_PERSISTENT_OK as NON_PERSISTENT_OK
from .base import PASSIVE_CLASS_MISMATCH as PASSIVE_CLASS_MISMATCH
from .base import PASSIVE_NO_FETCH as PASSIVE_NO_FETCH
from .base import PASSIVE_NO_FETCH_RELATED as PASSIVE_NO_FETCH_RELATED
from .base import PASSIVE_NO_INITIALIZE as PASSIVE_NO_INITIALIZE
from .base import PASSIVE_NO_RESULT as PASSIVE_NO_RESULT
from .base import PASSIVE_OFF as PASSIVE_OFF
from .base import PASSIVE_ONLY_PERSISTENT as PASSIVE_ONLY_PERSISTENT
from .base import PASSIVE_RETURN_NO_VALUE as PASSIVE_RETURN_NO_VALUE
from .base import RELATED_OBJECT_OK as RELATED_OBJECT_OK
from .base import SQL_OK as SQL_OK
from .base import state_str as state_str
from .. import event as event
from .. import inspection as inspection
from .. import util as util
from ..sql import base as sql_base
from ..sql import ClauseElement
from ..sql import roles as roles
from ..sql import traversals as traversals
from ..sql import visitors as visitors

class QueryableAttribute(
    interfaces._MappedAttribute,
    interfaces.InspectionAttr,
    interfaces.PropComparator,
    traversals.HasCopyInternals,
    roles.JoinTargetRole,
    roles.OnClauseRole,
    sql_base.Immutable,
    sql_base.MemoizedHasCacheKey,
):
    is_attribute: bool = ...
    class_: Any = ...
    key: Any = ...
    impl: Any = ...
    comparator: Any = ...
    def __init__(
        self,
        class_: Any,
        key: Any,
        parententity: Any,
        impl: Optional[Any] = ...,
        comparator: Optional[Any] = ...,
        of_type: Optional[Any] = ...,
        extra_criteria: Any = ...,
    ) -> None: ...
    def __reduce__(self): ...
    def get_history(self, instance: Any, passive: Any = ...): ...
    @util.memoized_property
    def info(self): ...
    @util.memoized_property
    def parent(self): ...
    @util.memoized_property
    def expression(self): ...
    def __clause_element__(self): ...
    def adapt_to_entity(self, adapt_to_entity: Any): ...
    def of_type(self, entity: Any): ...
    def and_(self, *other: Any): ...
    def label(self, name: Any): ...
    def operate(self, op: Any, *other: Any, **kwargs: Any): ...
    def reverse_operate(self, op: Any, other: Any, **kwargs: Any): ...
    def hasparent(self, state: Any, optimistic: bool = ...): ...
    def __getattr__(self, key: Any): ...
    @util.memoized_property
    def property(self): ...

_T = TypeVar("_T")

class Mapped(QueryableAttribute, Generic[_T]):
    def __init__(self, type: Type[_T]) -> None: ...
    @overload
    def __get__(self, instance: None, owner: Any) -> "Mapped"[_T]: ...
    @overload
    def __get__(self, instance: object, owner: Any) -> _T: ...
    @overload
    def __set__(self, instance: Any, value: _T) -> None: ...
    @overload
    def __set__(self, instance: Any, value: ClauseElement) -> None: ...
    def __delete__(self, instance: Any) -> None: ...
    @classmethod
    def _empty_constructor(cls, arg1: Any) -> "Mapped"[_T]: ...

class InstrumentedAttribute(Mapped):
    inherit_cache: bool = ...

HasEntityNamespace = namedtuple("HasEntityNamespace", ["entity_namespace"])

def create_proxied_attribute(descriptor: Any): ...

OP_REMOVE: Any
OP_APPEND: Any
OP_REPLACE: Any
OP_BULK_REPLACE: Any
OP_MODIFIED: Any

class AttributeEvent:
    impl: Any = ...
    op: Any = ...
    parent_token: Any = ...
    def __init__(self, attribute_impl: Any, op: Any) -> None: ...
    def __eq__(self, other: Any) -> Any: ...
    @property
    def key(self): ...
    def hasparent(self, state: Any): ...

Event = AttributeEvent

class AttributeImpl:
    class_: Any = ...
    key: Any = ...
    callable_: Any = ...
    dispatch: Any = ...
    trackparent: Any = ...
    parent_token: Any = ...
    send_modified_events: Any = ...
    is_equal: Any = ...
    accepts_scalar_loader: Any = ...
    load_on_unexpire: Any = ...
    def __init__(
        self,
        class_: Any,
        key: Any,
        callable_: Any,
        dispatch: Any,
        trackparent: bool = ...,
        compare_function: Optional[Any] = ...,
        active_history: bool = ...,
        parent_token: Optional[Any] = ...,
        load_on_unexpire: bool = ...,
        send_modified_events: bool = ...,
        accepts_scalar_loader: Optional[Any] = ...,
        **kwargs: Any,
    ) -> None: ...
    active_history: Any = ...
    def hasparent(self, state: Any, optimistic: bool = ...): ...
    def sethasparent(
        self, state: Any, parent_state: Any, value: Any
    ) -> None: ...
    def get_history(
        self, state: Any, dict_: Any, passive: Any = ...
    ) -> None: ...
    def get_all_pending(
        self, state: Any, dict_: Any, passive: Any = ...
    ) -> None: ...
    def get(self, state: Any, dict_: Any, passive: Any = ...): ...
    def append(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
    ) -> None: ...
    def remove(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
    ) -> None: ...
    def pop(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
    ) -> None: ...
    def set(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
        check_old: Optional[Any] = ...,
        pop: bool = ...,
    ) -> None: ...
    def get_committed_value(
        self, state: Any, dict_: Any, passive: Any = ...
    ): ...
    def set_committed_value(self, state: Any, dict_: Any, value: Any): ...

class ScalarAttributeImpl(AttributeImpl):
    default_accepts_scalar_loader: bool = ...
    uses_objects: bool = ...
    supports_population: bool = ...
    collection: bool = ...
    dynamic: bool = ...
    def __init__(self, *arg: Any, **kw: Any) -> None: ...
    def delete(self, state: Any, dict_: Any) -> None: ...
    def get_history(self, state: Any, dict_: Any, passive: Any = ...): ...
    def set(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
        check_old: Optional[Any] = ...,
        pop: bool = ...,
    ) -> None: ...
    def fire_replace_event(
        self, state: Any, dict_: Any, value: Any, previous: Any, initiator: Any
    ): ...
    def fire_remove_event(
        self, state: Any, dict_: Any, value: Any, initiator: Any
    ) -> None: ...
    @property
    def type(self) -> None: ...

class ScalarObjectAttributeImpl(ScalarAttributeImpl):
    default_accepts_scalar_loader: bool = ...
    uses_objects: bool = ...
    supports_population: bool = ...
    collection: bool = ...
    def delete(self, state: Any, dict_: Any) -> None: ...
    def get_history(self, state: Any, dict_: Any, passive: Any = ...): ...
    def get_all_pending(self, state: Any, dict_: Any, passive: Any = ...): ...
    def set(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
        check_old: Optional[Any] = ...,
        pop: bool = ...,
    ) -> None: ...
    def fire_remove_event(
        self, state: Any, dict_: Any, value: Any, initiator: Any
    ) -> None: ...
    def fire_replace_event(
        self, state: Any, dict_: Any, value: Any, previous: Any, initiator: Any
    ): ...

class CollectionAttributeImpl(AttributeImpl):
    default_accepts_scalar_loader: bool = ...
    uses_objects: bool = ...
    supports_population: bool = ...
    collection: bool = ...
    dynamic: bool = ...
    copy: Any = ...
    collection_factory: Any = ...
    def __init__(
        self,
        class_: Any,
        key: Any,
        callable_: Any,
        dispatch: Any,
        typecallable: Optional[Any] = ...,
        trackparent: bool = ...,
        copy_function: Optional[Any] = ...,
        compare_function: Optional[Any] = ...,
        **kwargs: Any,
    ) -> None: ...
    def get_history(self, state: Any, dict_: Any, passive: Any = ...): ...
    def get_all_pending(self, state: Any, dict_: Any, passive: Any = ...): ...
    def fire_append_event(
        self, state: Any, dict_: Any, value: Any, initiator: Any
    ): ...
    def fire_pre_remove_event(
        self, state: Any, dict_: Any, initiator: Any
    ) -> None: ...
    def fire_remove_event(
        self, state: Any, dict_: Any, value: Any, initiator: Any
    ) -> None: ...
    def delete(self, state: Any, dict_: Any) -> None: ...
    def append(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
    ) -> None: ...
    def remove(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
    ) -> None: ...
    def pop(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Any,
        passive: Any = ...,
    ) -> None: ...
    def set(
        self,
        state: Any,
        dict_: Any,
        value: Any,
        initiator: Optional[Any] = ...,
        passive: Any = ...,
        check_old: Optional[Any] = ...,
        pop: bool = ...,
    ) -> None: ...
    def set_committed_value(self, state: Any, dict_: Any, value: Any): ...
    def get_collection(
        self,
        state: Any,
        dict_: Any,
        user_data: Optional[Any] = ...,
        passive: Any = ...,
    ): ...

def backref_listeners(attribute: Any, key: Any, uselist: Any): ...

class History:
    def __bool__(self): ...
    __nonzero__: Any = ...
    def empty(self): ...
    def sum(self): ...
    def non_deleted(self): ...
    def non_added(self): ...
    def has_changes(self): ...
    def as_state(self): ...
    @classmethod
    def from_scalar_attribute(
        cls, attribute: Any, state: Any, current: Any
    ): ...
    @classmethod
    def from_object_attribute(
        cls, attribute: Any, state: Any, current: Any
    ): ...
    @classmethod
    def from_collection(cls, attribute: Any, state: Any, current: Any): ...

HISTORY_BLANK: Any

def get_history(obj: Any, key: Any, passive: Any = ...): ...
def get_state_history(state: Any, key: Any, passive: Any = ...): ...
def has_parent(cls, obj: Any, key: Any, optimistic: bool = ...): ...
def register_attribute(class_: Any, key: Any, **kw: Any): ...
def register_attribute_impl(
    class_: Any,
    key: Any,
    uselist: bool = ...,
    callable_: Optional[Any] = ...,
    useobject: bool = ...,
    impl_class: Optional[Any] = ...,
    backref: Optional[Any] = ...,
    **kw: Any,
): ...
def register_descriptor(
    class_: Any,
    key: Any,
    comparator: Optional[Any] = ...,
    parententity: Optional[Any] = ...,
    doc: Optional[Any] = ...,
): ...
def unregister_attribute(class_: Any, key: Any) -> None: ...
def init_collection(obj: Any, key: Any): ...
def init_state_collection(state: Any, dict_: Any, key: Any): ...
def set_committed_value(instance: Any, key: Any, value: Any) -> None: ...
def set_attribute(
    instance: Any, key: Any, value: Any, initiator: Optional[Any] = ...
) -> None: ...
def get_attribute(instance: Any, key: Any): ...
def del_attribute(instance: Any, key: Any) -> None: ...
def flag_modified(instance: Any, key: Any) -> None: ...
def flag_dirty(instance: Any) -> None: ...
