from typing import Any

from .. import event as event
from .. import types as types
from ..orm import Mapper as Mapper
from ..orm import mapper as mapper
from ..orm import object_mapper as object_mapper
from ..orm.attributes import flag_modified as flag_modified
from ..sql.base import SchemaEventTarget as SchemaEventTarget
from ..util import memoized_property as memoized_property

class MutableBase:
    @classmethod
    def coerce(cls, key: Any, value: Any) -> None: ...

class Mutable(MutableBase):
    def changed(self) -> None: ...
    @classmethod
    def associate_with_attribute(cls, attribute: Any) -> None: ...
    @classmethod
    def associate_with(cls, sqltype: Any) -> None: ...
    @classmethod
    def as_mutable(cls, sqltype: Any): ...

class MutableComposite(MutableBase):
    def changed(self) -> None: ...

class MutableDict(Mutable, dict):
    def __setitem__(self, key: Any, value: Any) -> None: ...
    def setdefault(self, key: Any, value: Any): ...
    def __delitem__(self, key: Any) -> None: ...
    def update(self, *a: Any, **kw: Any) -> None: ...
    def pop(self, *arg: Any): ...
    def popitem(self): ...
    def clear(self) -> None: ...
    @classmethod
    def coerce(cls, key: Any, value: Any): ...

class MutableList(Mutable, list):
    def __reduce_ex__(self, proto: Any): ...
    def __setitem__(self, index: Any, value: Any) -> None: ...
    def __setslice__(self, start: Any, end: Any, value: Any) -> None: ...
    def __delitem__(self, index: Any) -> None: ...
    def __delslice__(self, start: Any, end: Any) -> None: ...
    def pop(self, *arg: Any): ...
    def append(self, x: Any) -> None: ...
    def extend(self, x: Any) -> None: ...
    def __iadd__(self, x: Any): ...
    def insert(self, i: Any, x: Any) -> None: ...
    def remove(self, i: Any) -> None: ...
    def clear(self) -> None: ...
    def sort(self, **kw: Any) -> None: ...
    def reverse(self) -> None: ...
    @classmethod
    def coerce(cls, index: Any, value: Any): ...

class MutableSet(Mutable, set):
    def update(self, *arg: Any) -> None: ...
    def intersection_update(self, *arg: Any) -> None: ...
    def difference_update(self, *arg: Any) -> None: ...
    def symmetric_difference_update(self, *arg: Any) -> None: ...
    def __ior__(self, other: Any): ...
    def __iand__(self, other: Any): ...
    def __ixor__(self, other: Any): ...
    def __isub__(self, other: Any): ...
    def add(self, elem: Any) -> None: ...
    def remove(self, elem: Any) -> None: ...
    def discard(self, elem: Any) -> None: ...
    def pop(self, *arg: Any): ...
    def clear(self) -> None: ...
    @classmethod
    def coerce(cls, index: Any, value: Any): ...
    def __reduce_ex__(self, proto: Any): ...
