from typing import Any
from typing import Collection
from typing import Generic
from typing import ItemsView
from typing import Iterator
from typing import KeysView
from typing import List
from typing import Mapping
from typing import Sequence
from typing import Tuple
from typing import Type
from typing import TypeVar
from typing import ValuesView

from .result import ResultMetaData
from .result import RMKeyView

_T = TypeVar("_T")

MD_INDEX: int

def rowproxy_reconstructor(cls: Type[_T], state: Any) -> _T: ...

KEY_INTEGER_ONLY: int
KEY_OBJECTS_ONLY: int
KEY_OBJECTS_BUT_WARN: int
KEY_OBJECTS_NO_WARN: int

class BaseRow:
    def __init__(
        self,
        parent: ResultMetaData,
        processors: Any,
        keymap: Any,
        key_style: Any,
        data: Any,
    ) -> None: ...
    def __reduce__(self) -> Any: ...
    def __iter__(self) -> Iterator[Any]: ...
    def __len__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __getitem__(self, key: Any) -> Any: ...
    def __getattr__(self, name: Any) -> Any: ...

class Row(BaseRow, Sequence[Any]):
    @property
    def _mapping(self) -> RowMapping: ...
    def __contains__(self, key: Any) -> bool: ...
    def __hash__(self) -> int: ...
    def __lt__(self, other: Any) -> bool: ...
    def __le__(self, other: Any) -> bool: ...
    def __ge__(self, other: Any) -> bool: ...
    def __gt__(self, other: Any) -> bool: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def keys(self) -> List[str]: ...

class LegacyRow(Row):
    def __contains__(self, key: Any) -> bool: ...
    def __getitem__(self, key: Any) -> Any: ...
    def has_key(self, key: str) -> bool: ...
    def items(self) -> List[Tuple[str, Any]]: ...
    def iterkeys(self) -> Iterator[str]: ...
    def itervalues(self) -> Iterator[Any]: ...
    def values(self) -> List[Any]: ...

BaseRowProxy = BaseRow
RowProxy = Row

class ROMappingView(  # type: ignore[misc]
    KeysView[str],
    ValuesView[Any],
    ItemsView[str, Any],
    Generic[_T],
):
    def __init__(self, mapping: RowMapping, items: Collection[_T]) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Tuple[str, _T]]: ...  # type: ignore[override]
    def __contains__(self, item: Any) -> bool: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...

class RowMapping(BaseRow, Mapping[str, Any]):
    def __getitem__(self, key: str) -> Any: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
    def __contains__(self, key: Any) -> bool: ...
    def items(self) -> ROMappingView[Tuple[str, Any]]: ...  # type: ignore[override]
    def keys(self) -> RMKeyView: ...
    def values(self) -> ROMappingView[Any]: ...
