from typing import Any
from typing import Optional

from sqlalchemy import exc as exc
from sqlalchemy import sql as sql
from sqlalchemy import types as sqltypes
from sqlalchemy import util as util
from sqlalchemy.engine import default as default
from sqlalchemy.engine import reflection as reflection
from sqlalchemy.sql import compiler as compiler
from sqlalchemy.sql import expression as expression
from sqlalchemy.types import BIGINT as BIGINT
from sqlalchemy.types import BLOB as BLOB
from sqlalchemy.types import DATE as DATE
from sqlalchemy.types import FLOAT as FLOAT
from sqlalchemy.types import INTEGER as INTEGER
from sqlalchemy.types import Integer as Integer
from sqlalchemy.types import NUMERIC as NUMERIC
from sqlalchemy.types import SMALLINT as SMALLINT
from sqlalchemy.types import TEXT as TEXT
from sqlalchemy.types import TIME as TIME
from sqlalchemy.types import TIMESTAMP as TIMESTAMP

RESERVED_WORDS: Any

class _StringType(sqltypes.String):
    charset: Any = ...
    def __init__(self, charset: Optional[Any] = ..., **kw: Any) -> None: ...

class VARCHAR(_StringType, sqltypes.VARCHAR):
    __visit_name__: str = ...
    def __init__(self, length: Optional[Any] = ..., **kwargs: Any) -> None: ...

class CHAR(_StringType, sqltypes.CHAR):
    __visit_name__: str = ...
    def __init__(self, length: Optional[Any] = ..., **kwargs: Any) -> None: ...

class _FBDateTime(sqltypes.DateTime):
    def bind_processor(self, dialect: Any): ...

colspecs: Any
ischema_names: Any

class FBTypeCompiler(compiler.GenericTypeCompiler):
    def visit_boolean(self, type_: Any, **kw: Any): ...
    def visit_datetime(self, type_: Any, **kw: Any): ...
    def visit_TEXT(self, type_: Any, **kw: Any): ...
    def visit_BLOB(self, type_: Any, **kw: Any): ...
    def visit_CHAR(self, type_: Any, **kw: Any): ...
    def visit_VARCHAR(self, type_: Any, **kw: Any): ...

class FBCompiler(sql.compiler.SQLCompiler):
    ansi_bind_rules: bool = ...
    def visit_now_func(self, fn: Any, **kw: Any): ...
    def visit_startswith_op_binary(
        self, binary: Any, operator: Any, **kw: Any
    ): ...
    def visit_not_startswith_op_binary(
        self, binary: Any, operator: Any, **kw: Any
    ): ...
    def visit_mod_binary(self, binary: Any, operator: Any, **kw: Any): ...
    def visit_alias(self, alias: Any, asfrom: bool = ..., **kwargs: Any): ...
    def visit_substring_func(self, func: Any, **kw: Any): ...
    def visit_length_func(self, function: Any, **kw: Any): ...
    visit_char_length_func: Any = ...
    def function_argspec(self, func: Any, **kw: Any): ...
    def default_from(self): ...
    def visit_sequence(self, seq: Any, **kw: Any): ...
    def get_select_precolumns(self, select: Any, **kw: Any): ...
    def limit_clause(self, select: Any, **kw: Any): ...
    def returning_clause(self, stmt: Any, returning_cols: Any): ...

class FBDDLCompiler(sql.compiler.DDLCompiler):
    def visit_create_sequence(self, create: Any): ...
    def visit_drop_sequence(self, drop: Any): ...
    def visit_computed_column(self, generated: Any): ...

class FBIdentifierPreparer(sql.compiler.IdentifierPreparer):
    reserved_words: Any = ...
    illegal_initial_characters: Any = ...
    def __init__(self, dialect: Any) -> None: ...

class FBExecutionContext(default.DefaultExecutionContext):
    def fire_sequence(self, seq: Any, type_: Any): ...

class FBDialect(default.DefaultDialect):
    name: str = ...
    max_identifier_length: int = ...
    supports_sequences: bool = ...
    sequences_optional: bool = ...
    supports_default_values: bool = ...
    postfetch_lastrowid: bool = ...
    supports_native_boolean: bool = ...
    requires_name_normalize: bool = ...
    supports_empty_insert: bool = ...
    statement_compiler: Any = ...
    ddl_compiler: Any = ...
    preparer: Any = ...
    type_compiler: Any = ...
    execution_ctx_cls: Any = ...
    colspecs: Any = ...
    ischema_names: Any = ...
    construct_arguments: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    implicit_returning: Any = ...
    def initialize(self, connection: Any) -> None: ...
    def has_table(
        self, connection: Any, table_name: Any, schema: Optional[Any] = ...
    ): ...
    def has_sequence(
        self, connection: Any, sequence_name: Any, schema: Optional[Any] = ...
    ): ...
    def get_table_names(
        self, connection: Any, schema: Optional[Any] = ..., **kw: Any
    ): ...
    def get_view_names(
        self, connection: Any, schema: Optional[Any] = ..., **kw: Any
    ): ...
    def get_view_definition(
        self,
        connection: Any,
        view_name: Any,
        schema: Optional[Any] = ...,
        **kw: Any,
    ): ...
    def get_pk_constraint(
        self,
        connection: Any,
        table_name: Any,
        schema: Optional[Any] = ...,
        **kw: Any,
    ): ...
    def get_column_sequence(
        self,
        connection: Any,
        table_name: Any,
        column_name: Any,
        schema: Optional[Any] = ...,
        **kw: Any,
    ): ...
    def get_columns(
        self,
        connection: Any,
        table_name: Any,
        schema: Optional[Any] = ...,
        **kw: Any,
    ): ...
    def get_foreign_keys(
        self,
        connection: Any,
        table_name: Any,
        schema: Optional[Any] = ...,
        **kw: Any,
    ): ...
    def get_indexes(
        self,
        connection: Any,
        table_name: Any,
        schema: Optional[Any] = ...,
        **kw: Any,
    ): ...
