#!/usr/bin/env python
# -*- coding:utf-8 -*-
# @Author: Niccolò Bonacchi
# @Date: Friday, October 30th 2020, 10:42:49 am
import unittest

import ibllib.io.extractors.ephys_passive as passive
import numpy as np


class TestsPassiveExtractor(unittest.TestCase):
    def setUp(self):
        pass

    def test_load_passive_stim_meta(self):
        meta = passive._load_passive_stim_meta()
        self.assertTrue(isinstance(meta, dict))

    def test_interpolate_rf_mapping_stimulus(self):
        idxs_up = np.array([0, 4, 8])
        idxs_dn = np.array([1, 5, 9])
        times = np.array([0, 1, 4, 5, 8, 9])
        Xq = np.arange(15)
        t_bin = 1  # Use 1 so can compare directly Xq and Tq
        Tq = passive._interpolate_rf_mapping_stimulus(
            idxs_up=idxs_up, idxs_dn=idxs_dn, times=times, Xq=Xq, t_bin=t_bin
        )
        self.assertTrue(np.array_equal(Tq, Xq))

    def tearDown(self):
        pass


if __name__ == "__main__":
    unittest.main(exit=False, verbosity=2)
