import numpy as np

TIP_SIZE_UM = 200

SYNC_PIN_OUT = {'3A': {"pin01": 0,
                       "pin02": 1,
                       "pin03": 2,
                       "pin04": 3,
                       "pin05": None,
                       "pin06": 4,
                       "pin07": 5,
                       "pin08": 6,
                       "pin09": 7,
                       "pin10": None,
                       "pin11": 8,
                       "pin12": 9,
                       "pin13": 10,
                       "pin14": 11,
                       "pin15": None,
                       "pin16": 12,
                       "pin17": 13,
                       "pin18": 14,
                       "pin19": 15,
                       "pin20": None,
                       "pin21": None,
                       "pin22": None,
                       "pin23": None,
                       "pin24": None
                       },
                '3B': {"P0.0": 0,
                       "P0.1": 1,
                       "P0.2": 2,
                       "P0.3": 3,
                       "P0.4": 4,
                       "P0.5": 5,
                       "P0.6": 6,
                       "P0.7": 7,
                       }
                }

# after moving to ks2.5, this should be deprecated
SITES_COORDINATES = np.array([
    [43., 20.],
    [11., 20.],
    [59., 40.],
    [27., 40.],
    [43., 60.],
    [11., 60.],
    [59., 80.],
    [27., 80.],
    [43., 100.],
    [11., 100.],
    [59., 120.],
    [27., 120.],
    [43., 140.],
    [11., 140.],
    [59., 160.],
    [27., 160.],
    [43., 180.],
    [11., 180.],
    [59., 200.],
    [27., 200.],
    [43., 220.],
    [11., 220.],
    [59., 240.],
    [27., 240.],
    [43., 260.],
    [11., 260.],
    [59., 280.],
    [27., 280.],
    [43., 300.],
    [11., 300.],
    [59., 320.],
    [27., 320.],
    [43., 340.],
    [11., 340.],
    [59., 360.],
    [27., 360.],
    [11., 380.],
    [59., 400.],
    [27., 400.],
    [43., 420.],
    [11., 420.],
    [59., 440.],
    [27., 440.],
    [43., 460.],
    [11., 460.],
    [59., 480.],
    [27., 480.],
    [43., 500.],
    [11., 500.],
    [59., 520.],
    [27., 520.],
    [43., 540.],
    [11., 540.],
    [59., 560.],
    [27., 560.],
    [43., 580.],
    [11., 580.],
    [59., 600.],
    [27., 600.],
    [43., 620.],
    [11., 620.],
    [59., 640.],
    [27., 640.],
    [43., 660.],
    [11., 660.],
    [59., 680.],
    [27., 680.],
    [43., 700.],
    [11., 700.],
    [59., 720.],
    [27., 720.],
    [43., 740.],
    [11., 740.],
    [59., 760.],
    [43., 780.],
    [11., 780.],
    [59., 800.],
    [27., 800.],
    [43., 820.],
    [11., 820.],
    [59., 840.],
    [27., 840.],
    [43., 860.],
    [11., 860.],
    [59., 880.],
    [27., 880.],
    [43., 900.],
    [11., 900.],
    [59., 920.],
    [27., 920.],
    [43., 940.],
    [11., 940.],
    [59., 960.],
    [27., 960.],
    [43., 980.],
    [11., 980.],
    [59., 1000.],
    [27., 1000.],
    [43., 1020.],
    [11., 1020.],
    [59., 1040.],
    [27., 1040.],
    [43., 1060.],
    [11., 1060.],
    [59., 1080.],
    [27., 1080.],
    [43., 1100.],
    [11., 1100.],
    [59., 1120.],
    [27., 1120.],
    [11., 1140.],
    [59., 1160.],
    [27., 1160.],
    [43., 1180.],
    [11., 1180.],
    [59., 1200.],
    [27., 1200.],
    [43., 1220.],
    [11., 1220.],
    [59., 1240.],
    [27., 1240.],
    [43., 1260.],
    [11., 1260.],
    [59., 1280.],
    [27., 1280.],
    [43., 1300.],
    [11., 1300.],
    [59., 1320.],
    [27., 1320.],
    [43., 1340.],
    [11., 1340.],
    [59., 1360.],
    [27., 1360.],
    [43., 1380.],
    [11., 1380.],
    [59., 1400.],
    [27., 1400.],
    [43., 1420.],
    [11., 1420.],
    [59., 1440.],
    [27., 1440.],
    [43., 1460.],
    [11., 1460.],
    [59., 1480.],
    [27., 1480.],
    [43., 1500.],
    [11., 1500.],
    [59., 1520.],
    [43., 1540.],
    [11., 1540.],
    [59., 1560.],
    [27., 1560.],
    [43., 1580.],
    [11., 1580.],
    [59., 1600.],
    [27., 1600.],
    [43., 1620.],
    [11., 1620.],
    [59., 1640.],
    [27., 1640.],
    [43., 1660.],
    [11., 1660.],
    [59., 1680.],
    [27., 1680.],
    [43., 1700.],
    [11., 1700.],
    [59., 1720.],
    [27., 1720.],
    [43., 1740.],
    [11., 1740.],
    [59., 1760.],
    [27., 1760.],
    [43., 1780.],
    [11., 1780.],
    [59., 1800.],
    [27., 1800.],
    [43., 1820.],
    [11., 1820.],
    [59., 1840.],
    [27., 1840.],
    [43., 1860.],
    [11., 1860.],
    [59., 1880.],
    [27., 1880.],
    [11., 1900.],
    [59., 1920.],
    [27., 1920.],
    [43., 1940.],
    [11., 1940.],
    [59., 1960.],
    [27., 1960.],
    [43., 1980.],
    [11., 1980.],
    [59., 2000.],
    [27., 2000.],
    [43., 2020.],
    [11., 2020.],
    [59., 2040.],
    [27., 2040.],
    [43., 2060.],
    [11., 2060.],
    [59., 2080.],
    [27., 2080.],
    [43., 2100.],
    [11., 2100.],
    [59., 2120.],
    [27., 2120.],
    [43., 2140.],
    [11., 2140.],
    [59., 2160.],
    [27., 2160.],
    [43., 2180.],
    [11., 2180.],
    [59., 2200.],
    [27., 2200.],
    [43., 2220.],
    [11., 2220.],
    [59., 2240.],
    [27., 2240.],
    [43., 2260.],
    [11., 2260.],
    [59., 2280.],
    [43., 2300.],
    [11., 2300.],
    [59., 2320.],
    [27., 2320.],
    [43., 2340.],
    [11., 2340.],
    [59., 2360.],
    [27., 2360.],
    [43., 2380.],
    [11., 2380.],
    [59., 2400.],
    [27., 2400.],
    [43., 2420.],
    [11., 2420.],
    [59., 2440.],
    [27., 2440.],
    [43., 2460.],
    [11., 2460.],
    [59., 2480.],
    [27., 2480.],
    [43., 2500.],
    [11., 2500.],
    [59., 2520.],
    [27., 2520.],
    [43., 2540.],
    [11., 2540.],
    [59., 2560.],
    [27., 2560.],
    [43., 2580.],
    [11., 2580.],
    [59., 2600.],
    [27., 2600.],
    [43., 2620.],
    [11., 2620.],
    [59., 2640.],
    [27., 2640.],
    [11., 2660.],
    [59., 2680.],
    [27., 2680.],
    [43., 2700.],
    [11., 2700.],
    [59., 2720.],
    [27., 2720.],
    [43., 2740.],
    [11., 2740.],
    [59., 2760.],
    [27., 2760.],
    [43., 2780.],
    [11., 2780.],
    [59., 2800.],
    [27., 2800.],
    [43., 2820.],
    [11., 2820.],
    [59., 2840.],
    [27., 2840.],
    [43., 2860.],
    [11., 2860.],
    [59., 2880.],
    [27., 2880.],
    [43., 2900.],
    [11., 2900.],
    [59., 2920.],
    [27., 2920.],
    [43., 2940.],
    [11., 2940.],
    [59., 2960.],
    [27., 2960.],
    [43., 2980.],
    [11., 2980.],
    [59., 3000.],
    [27., 3000.],
    [43., 3020.],
    [11., 3020.],
    [59., 3040.],
    [43., 3060.],
    [11., 3060.],
    [59., 3080.],
    [27., 3080.],
    [43., 3100.],
    [11., 3100.],
    [59., 3120.],
    [27., 3120.],
    [43., 3140.],
    [11., 3140.],
    [59., 3160.],
    [27., 3160.],
    [43., 3180.],
    [11., 3180.],
    [59., 3200.],
    [27., 3200.],
    [43., 3220.],
    [11., 3220.],
    [59., 3240.],
    [27., 3240.],
    [43., 3260.],
    [11., 3260.],
    [59., 3280.],
    [27., 3280.],
    [43., 3300.],
    [11., 3300.],
    [59., 3320.],
    [27., 3320.],
    [43., 3340.],
    [11., 3340.],
    [59., 3360.],
    [27., 3360.],
    [43., 3380.],
    [11., 3380.],
    [59., 3400.],
    [27., 3400.],
    [11., 3420.],
    [59., 3440.],
    [27., 3440.],
    [43., 3460.],
    [11., 3460.],
    [59., 3480.],
    [27., 3480.],
    [43., 3500.],
    [11., 3500.],
    [59., 3520.],
    [27., 3520.],
    [43., 3540.],
    [11., 3540.],
    [59., 3560.],
    [27., 3560.],
    [43., 3580.],
    [11., 3580.],
    [59., 3600.],
    [27., 3600.],
    [43., 3620.],
    [11., 3620.],
    [59., 3640.],
    [27., 3640.],
    [43., 3660.],
    [11., 3660.],
    [59., 3680.],
    [27., 3680.],
    [43., 3700.],
    [11., 3700.],
    [59., 3720.],
    [27., 3720.],
    [43., 3740.],
    [11., 3740.],
    [59., 3760.],
    [27., 3760.],
    [43., 3780.],
    [11., 3780.],
    [59., 3800.],
    [43., 3820.],
    [11., 3820.],
    [59., 3840.],
    [27., 3840.]])

NC = 384


def rc2xy(row, col):
    "converts the row/col indices from "
    x = col * 16 + 11
    y = (row * 20) + 20
    return {'x': x, 'y': y}


def dense_layout():
    """Dictionary containing local coordinates of a Neuropixel 3 dense layout"""
    ch = {'ind': np.arange(NC),
          'col': np.tile(np.array([2, 0, 3, 1]), int(NC / 4)),
          'row': np.floor(np.arange(NC) / 2)}
    ch.update(rc2xy(ch['row'], ch['col']))
    return ch


def adc_shifts(version=1):
    """
    The sampling is serial within the same ADC, but it happens at the same time in all ADCs.
    The ADC to channel mapping is done per odd and even channels:
    ADC1: ch1, ch3, ch5, ch7...
    ADC2: ch2, ch4, ch6....
    ADC3: ch33, ch35, ch37...
    ADC4: ch34, ch36, ch38...
    Therefore, channels 1, 2, 33, 34 get sample at the same time. I hope this is more or
    less clear. In 1.0, it is similar, but there we have 32 ADC that sample each 12 channels."
    - Nick on Slack after talking to Carolina - ;-)
    """
    if version == 1:
        adc_channels = 12
        # version 1 uses 32 ADC that sample 12 channels each
    elif version == 2:
        # version 2 uses 24 ADC that sample 16 channels each
        adc_channels = 16
    adc = np.floor(np.arange(NC) / (adc_channels * 2)) * 2 + np.mod(np.arange(NC), 2)
    sample_shift = np.zeros_like(adc)
    for a in adc:
        sample_shift[adc == a] = np.arange(adc_channels) / adc_channels
    return sample_shift, adc


def trace_header(version=1):
    """
    For the dense layout used at IBL, returns a dictionary with keys
    x, y, row, col, ind, adc and sampleshift vectors corresponding to each site
    """
    h = dense_layout()
    h['sample_shift'], h['adc'] = adc_shifts(version=version)
    return h
