import numpy as np
from osgeo import gdal, osr


def setup_test_raster(filename, value, timestamp=None, srid=4326, unit=None):
    """Save value, which is an np array, to a GeoTIFF file."""
    nodata = 1e8
    value[np.isnan(value)] = nodata
    f = gdal.GetDriverByName("GTiff").Create(filename, 3, 3, 1, gdal.GDT_Float32)
    try:
        if timestamp:
            f.SetMetadataItem("TIMESTAMP", timestamp.isoformat())
        if unit:
            f.SetMetadataItem("UNIT", unit)
        if srid == 4326:
            f.SetGeoTransform((22.0, 0.01, 0, 38.0, 0, -0.01))
        elif srid == 2100:
            f.SetGeoTransform((320000, 1000, 0, 4210000, 0, -1000))
        sr = osr.SpatialReference()
        sr.ImportFromEPSG(srid)
        f.SetProjection(sr.ExportToWkt())
        f.GetRasterBand(1).SetNoDataValue(nodata)
        f.GetRasterBand(1).WriteArray(value)
    finally:
        f = None
