Copyright (c) 2020 Nico Piatkowski

pxpy
====
The python library for discrete pairwise undirected graphical models.

Inference:
* Loopy belief propagation (GPU support)
* Junction tree
* Stochastic Clenshaw-Curtis quadrature

Sampling:
* Gibbs Sampling
* Perturb+Map Sampling

Parameter learning:
* Accelerated proximal gradient
* built-in L1 / L2 regularization
* Supports arbitrary custom regularization

Structure learning:
* Chow-Liu trees
* Soft-thresolding
* High-order clique structures

Misc:
* Support for spatio-temporal compressible reparametrization (STRF)
* Runs on x86_64 (linux, windows), ARMv8 (linux), and MSP430 (bare metal)
* Basic graph drawing via graphviz
* Discretization

<https://randomfields.org>

Changelog
=========
* 1.0a45: 
* 1.0a44: Improved: Discretization
* 1.0a42: Improved: Updated some default values
* 1.0a41: Improved: Fixed subtle bug in parameter initialization
* 1.0a40: Added: Loading string data via genfromstrcsv(..) (built-in string<->int mapper)
* 1.0a36: Improved: Randomized clique search
* 1.0a29: Added: Randomized clique search
* 1.0a28: Improved: Handling NaN-values during discretization (now interpreted as missing)
* 1.0a27: Improved: Accelerated structure estimation
* 1.0a26: Improved: Progress computation. Added: Online entropy computation for large cliques
* 1.0a25: Improved: Memory management
* 1.0a24: Improved: Structure estimation, backend. Added: Third-order structure estimation; simple graphviz output
* 1.0a23: Improved: Structure estimation
* 1.0a22: Improved: Discretization engine, support for external inference engine. Added: default to 32bit computation (disable via env PX_USE64BIT)
* 1.0a21: Improved: Support for external inference engine
* 1.0a20: Added: Support for external inference engine (access via env PX_EXTINF)
* 1.0a19: Improved: Manual model creation
* 1.0a18: Added: Debug mode (linux only, enable via env PX_DEBUGMODE)
* 1.0a17: Improved: API, tests, regularization. Added: AIC and BIC computation
* 1.0a16: Improved: Memory management, access to optimizer state in optimization hooks. Added: Support for training resumption
* 1.0a15: Improved: API
* 1.0a14: Improved: Memory management
* 1.0a13: Improved: Memory management (fixed leak in conditional sampling/marginals)
* 1.0a12: Improved: Access to vertex and pairwise marginals
* 1.0a11: Added: Access to single variable marginals
* 1.0a10: Improved: Library build process
* 1.0a9:  Added: Conditional sampling
* 1.0a8:  Imroved: Maximum-a-posteriori (MAP) estimation. Added: Custom graph construction
* 1.0a7:  Added: Conditional marginal inference, support for Ising/minimal statistics
* 1.0a6:  Added: Manual model creation, support for training data with missing values (represented by pxpy.MISSING_VALUE)
* 1.0a5:  Improved: Model management
* 1.0a4:  Added: Model access in regularization and proximal hooks
* 1.0a3:  Improved: GLIBC requirement, removed libgomp dependency
* 1.0a2:  Added: Python 3.5 compatibility
* 1.0a1:  Initial release
