<p align="center">
    <img alt="Plone Logo" width="200px" src="https://raw.githubusercontent.com/plone/.github/main/plone-logo.png">
</p>

<h1 align="center">
  Plone
</h1>

<div align="center">

[![PyPI - Wheel](https://img.shields.io/pypi/wheel/plone)](https://pypi.org/project/plone/)
[![PyPI - License](https://img.shields.io/pypi/l/plone)](https://pypi.org/project/plone/)
[![PyPI - Status](https://img.shields.io/pypi/status/plone)](https://pypi.org/project/plone/)

[![GitHub contributors](https://img.shields.io/github/contributors/plone/Products.CMFPlone)](https://github.com/plone/Products.CMFPlone)
![GitHub Repo stars](https://img.shields.io/github/stars/plone/Plone?style=flat-square)

</div>

Plone is a mature, secure, and user-friendly content management system (CMS).

Plone was first released to the public on October 4, 2001.

Plone has the maturity, stability, and reliability of an application maintained by open source developers with decades of experience, while continually evolving and adapting to modern technology.

Lots of customizations can be made trough-the-web, such as creating content types, themes, workflows, and much more.
Plone may be extended and used as a framework on which to build custom CMS-like solutions.

Plone works as a

- Full-featured server-side rendered HTML CMS.
- React-based frontend for editing and viewing content, backed by a server with a REST API.
- Headless CMS server with a REST API, allowing a developer to build a custom frontend with their chosen technology.


<h2 align="center">
  Installing Plone
</h2>

Plone is available on Linux, Microsoft Windows, macOS, and BSD platforms.

Plone may be run as a container in the cloud with Docker and other Open Containers Initiative compliant platforms.
[Example Dockerfiles](https://6.docs.plone.org/install/containers/images/index.html) and base images are available.

[Install Plone by choosing an option from plone.org](https://plone.org/download)


<h2 align="center">
  Documentation
</h2>

Consult [the official Plone documentation](https://docs.plone.org) with information for different audiences.

For trainings [comprehensive Plone training material](https://training.plone.org) is available.


<h2 align="center">
  What is Plone?
</h2>

Plone is a ready-to-run content management system, offering a complete set of features needed by a wide variety of organizations.

Security is built into Plone's architecture from the ground up.
Plone offers fine-grained permission control over content and actions.

Plone is easy to set up, extremely flexible,
and provides you with a system for managing web content that is ideal for project groups, communities, websites, extranets, and intranets.

- **Plone is easy to install.**
  Several installation options are available for either your local machine or on servers in the cloud.

- **Plone empowers content editors and web application developers.**
  The Plone Team includes usability experts who have made Plone easy and attractive for content managers to add, update, and maintain content.

- **Plone is international.**
  The Plone interface has more than 35 translations, and tools exist for managing multilingual content.

- **Plone follows standards and is inclusive.**
  Plone carefully follows standards for usability and accessibility.
  Plone is compliant with WCAG 2.1 level AA and aims for ATAG 2.0 level AA.

- **Plone is open source.**
  Plone is licensed under the GNU General Public License, the same license used by Linux.
  This gives you the right to use Plone without a license fee, and to improve upon the product.

- **Plone is supported.**
  There are over two hundred active developers in the Plone Development Team around the world, and a multitude of companies that specialize in Plone development and support.

- **Plone is extensible.**
  There is a multitude of add-on products for Plone to add new features and content types.
  In addition, Plone can be scripted using web standard solutions and open source languages.

- **Plone is technology neutral.**
  Plone can interoperate with most relational database systems—both open source and commercial—and runs on a vast array of
  platforms, including Linux, Windows, macOS, and BSD.


<h2 align="center">
Technical overview
</h2>

Plone is a content management platform with its backend written in Python.
Plone has a choice of frontend, either Classic UI using server-side templates or Volto written in modern React-based JavaScript.
It builds upon Zope, an open source web application server and development system, and thus on the pluggable Zope Component Architecture (ZCA).

Python is the easy to learn, widely used, and supported open source programming language.
Python can be used to add new features to Plone and used to understand or make changes to the way that Plone works.

Plone stores its contents in Zope's built-in transactional hierarchical object database, the ZODB.
The ZODB can be connected to simple file-storages, scalable ZEO-Servers or Postgres, MySQL, and Oracle.
There are add-ons and techniques, however, to share information with other sources, such as relational databases, LDAP, filesystem
files, and so on.


<h2 align="center">
Official Resources
</h2>

* [plone.org](https://plone.org/) - Official website for developers, community, decision makers, and evaluators.
* [Plone support](https://plone.org/support) - Where to find help.
* [community.plone.org](https://community.plone.org/) - Official community forum, the best place to get help.
* [docs.plone.org](https://docs.plone.org/) - Official documentation for developers, integrators, and content editors.
* [training.plone.org](https://training.plone.org/) - Trainings for developers, integrators, content editors, and designers.
* [`plone.api`](https://docs.plone.org/develop/plone.api/docs/index.html) - Documentation for `plone.api`.
* [`plone.restapi`](https://plonerestapi.readthedocs.io/en/latest/) - Documentation for `plone.restapi`.
* [Discord](https://discord.gg/zFY3EBbjaj) - Official Plone chat, voice, and video service.

<h2 align="center">
This project is supported by
</h2>

<p align="center">
    <a href="https://plone.org/foundation/">
      <img alt="Plone Logo" width="200px" src="https://raw.githubusercontent.com/plone/.github/main/plone-foundation.png">
    </a>
</p>

<h2 align="center">
License
</h2>
The project is licensed under the GPLv2.
