# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['RepositoryFileArgs', 'RepositoryFile']

@pulumi.input_type
class RepositoryFileArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 file: pulumi.Input[str],
                 repository: pulumi.Input[str],
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_author: Optional[pulumi.Input[str]] = None,
                 commit_email: Optional[pulumi.Input[str]] = None,
                 commit_message: Optional[pulumi.Input[str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a RepositoryFile resource.
        :param pulumi.Input[str] content: The file content.
        :param pulumi.Input[str] file: The path of the file to manage.
        :param pulumi.Input[str] repository: The repository to create the file in.
        :param pulumi.Input[str] branch: Git branch (defaults to `main`).
               The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[str] commit_author: Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        :param pulumi.Input[str] commit_email: Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        :param pulumi.Input[str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[bool] overwrite_on_create: Enable overwriting existing files
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "repository", repository)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit_author is not None:
            pulumi.set(__self__, "commit_author", commit_author)
        if commit_email is not None:
            pulumi.set(__self__, "commit_email", commit_email)
        if commit_message is not None:
            pulumi.set(__self__, "commit_message", commit_message)
        if overwrite_on_create is not None:
            pulumi.set(__self__, "overwrite_on_create", overwrite_on_create)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def file(self) -> pulumi.Input[str]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: pulumi.Input[str]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        The repository to create the file in.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        Git branch (defaults to `main`).
        The branch must already exist, it will not be created if it does not already exist.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commitAuthor")
    def commit_author(self) -> Optional[pulumi.Input[str]]:
        """
        Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_author")

    @commit_author.setter
    def commit_author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_author", value)

    @property
    @pulumi.getter(name="commitEmail")
    def commit_email(self) -> Optional[pulumi.Input[str]]:
        """
        Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_email")

    @commit_email.setter
    def commit_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_email", value)

    @property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> Optional[pulumi.Input[str]]:
        """
        Commit message when adding or updating the managed file.
        """
        return pulumi.get(self, "commit_message")

    @commit_message.setter
    def commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_message", value)

    @property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable overwriting existing files
        """
        return pulumi.get(self, "overwrite_on_create")

    @overwrite_on_create.setter
    def overwrite_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite_on_create", value)


@pulumi.input_type
class _RepositoryFileState:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_author: Optional[pulumi.Input[str]] = None,
                 commit_email: Optional[pulumi.Input[str]] = None,
                 commit_message: Optional[pulumi.Input[str]] = None,
                 commit_sha: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 file: Optional[pulumi.Input[str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[bool]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 sha: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RepositoryFile resources.
        :param pulumi.Input[str] branch: Git branch (defaults to `main`).
               The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[str] commit_author: Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        :param pulumi.Input[str] commit_email: Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        :param pulumi.Input[str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[str] commit_sha: The SHA of the commit that modified the file.
        :param pulumi.Input[str] content: The file content.
        :param pulumi.Input[str] file: The path of the file to manage.
        :param pulumi.Input[bool] overwrite_on_create: Enable overwriting existing files
        :param pulumi.Input[str] repository: The repository to create the file in.
        :param pulumi.Input[str] sha: The SHA blob of the file.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit_author is not None:
            pulumi.set(__self__, "commit_author", commit_author)
        if commit_email is not None:
            pulumi.set(__self__, "commit_email", commit_email)
        if commit_message is not None:
            pulumi.set(__self__, "commit_message", commit_message)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if overwrite_on_create is not None:
            pulumi.set(__self__, "overwrite_on_create", overwrite_on_create)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if sha is not None:
            pulumi.set(__self__, "sha", sha)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        Git branch (defaults to `main`).
        The branch must already exist, it will not be created if it does not already exist.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commitAuthor")
    def commit_author(self) -> Optional[pulumi.Input[str]]:
        """
        Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_author")

    @commit_author.setter
    def commit_author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_author", value)

    @property
    @pulumi.getter(name="commitEmail")
    def commit_email(self) -> Optional[pulumi.Input[str]]:
        """
        Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_email")

    @commit_email.setter
    def commit_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_email", value)

    @property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> Optional[pulumi.Input[str]]:
        """
        Commit message when adding or updating the managed file.
        """
        return pulumi.get(self, "commit_message")

    @commit_message.setter
    def commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_message", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[str]]:
        """
        The SHA of the commit that modified the file.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable overwriting existing files
        """
        return pulumi.get(self, "overwrite_on_create")

    @overwrite_on_create.setter
    def overwrite_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite_on_create", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The repository to create the file in.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def sha(self) -> Optional[pulumi.Input[str]]:
        """
        The SHA blob of the file.
        """
        return pulumi.get(self, "sha")

    @sha.setter
    def sha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha", value)


class RepositoryFile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_author: Optional[pulumi.Input[str]] = None,
                 commit_email: Optional[pulumi.Input[str]] = None,
                 commit_message: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 file: Optional[pulumi.Input[str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[bool]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage files within a
        GitHub repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        foo_repository = github.Repository("fooRepository", auto_init=True)
        foo_repository_file = github.RepositoryFile("fooRepositoryFile",
            repository=foo_repository.name,
            branch="main",
            file=".gitignore",
            content="**/*.tfstate",
            commit_message="Managed by Terraform",
            commit_author="Terraform User",
            commit_email="terraform@example.com",
            overwrite_on_create=True)
        ```

        ## Import

        Repository files can be imported using a combination of the `repo` and `file`, e.g.

        ```sh
         $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore
        ```

         To import a file from a branch other than main, append `:` and the branch name, e.g.

        ```sh
         $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore:dev
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: Git branch (defaults to `main`).
               The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[str] commit_author: Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        :param pulumi.Input[str] commit_email: Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        :param pulumi.Input[str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[str] content: The file content.
        :param pulumi.Input[str] file: The path of the file to manage.
        :param pulumi.Input[bool] overwrite_on_create: Enable overwriting existing files
        :param pulumi.Input[str] repository: The repository to create the file in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryFileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage files within a
        GitHub repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        foo_repository = github.Repository("fooRepository", auto_init=True)
        foo_repository_file = github.RepositoryFile("fooRepositoryFile",
            repository=foo_repository.name,
            branch="main",
            file=".gitignore",
            content="**/*.tfstate",
            commit_message="Managed by Terraform",
            commit_author="Terraform User",
            commit_email="terraform@example.com",
            overwrite_on_create=True)
        ```

        ## Import

        Repository files can be imported using a combination of the `repo` and `file`, e.g.

        ```sh
         $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore
        ```

         To import a file from a branch other than main, append `:` and the branch name, e.g.

        ```sh
         $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore:dev
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryFileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryFileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[str]] = None,
                 commit_author: Optional[pulumi.Input[str]] = None,
                 commit_email: Optional[pulumi.Input[str]] = None,
                 commit_message: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 file: Optional[pulumi.Input[str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[bool]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryFileArgs.__new__(RepositoryFileArgs)

            __props__.__dict__["branch"] = branch
            __props__.__dict__["commit_author"] = commit_author
            __props__.__dict__["commit_email"] = commit_email
            __props__.__dict__["commit_message"] = commit_message
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if file is None and not opts.urn:
                raise TypeError("Missing required property 'file'")
            __props__.__dict__["file"] = file
            __props__.__dict__["overwrite_on_create"] = overwrite_on_create
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            __props__.__dict__["commit_sha"] = None
            __props__.__dict__["sha"] = None
        super(RepositoryFile, __self__).__init__(
            'github:index/repositoryFile:RepositoryFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch: Optional[pulumi.Input[str]] = None,
            commit_author: Optional[pulumi.Input[str]] = None,
            commit_email: Optional[pulumi.Input[str]] = None,
            commit_message: Optional[pulumi.Input[str]] = None,
            commit_sha: Optional[pulumi.Input[str]] = None,
            content: Optional[pulumi.Input[str]] = None,
            file: Optional[pulumi.Input[str]] = None,
            overwrite_on_create: Optional[pulumi.Input[bool]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            sha: Optional[pulumi.Input[str]] = None) -> 'RepositoryFile':
        """
        Get an existing RepositoryFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch: Git branch (defaults to `main`).
               The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[str] commit_author: Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        :param pulumi.Input[str] commit_email: Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        :param pulumi.Input[str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[str] commit_sha: The SHA of the commit that modified the file.
        :param pulumi.Input[str] content: The file content.
        :param pulumi.Input[str] file: The path of the file to manage.
        :param pulumi.Input[bool] overwrite_on_create: Enable overwriting existing files
        :param pulumi.Input[str] repository: The repository to create the file in.
        :param pulumi.Input[str] sha: The SHA blob of the file.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryFileState.__new__(_RepositoryFileState)

        __props__.__dict__["branch"] = branch
        __props__.__dict__["commit_author"] = commit_author
        __props__.__dict__["commit_email"] = commit_email
        __props__.__dict__["commit_message"] = commit_message
        __props__.__dict__["commit_sha"] = commit_sha
        __props__.__dict__["content"] = content
        __props__.__dict__["file"] = file
        __props__.__dict__["overwrite_on_create"] = overwrite_on_create
        __props__.__dict__["repository"] = repository
        __props__.__dict__["sha"] = sha
        return RepositoryFile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Output[Optional[str]]:
        """
        Git branch (defaults to `main`).
        The branch must already exist, it will not be created if it does not already exist.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="commitAuthor")
    def commit_author(self) -> pulumi.Output[Optional[str]]:
        """
        Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_author")

    @property
    @pulumi.getter(name="commitEmail")
    def commit_email(self) -> pulumi.Output[Optional[str]]:
        """
        Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_email")

    @property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> pulumi.Output[str]:
        """
        Commit message when adding or updating the managed file.
        """
        return pulumi.get(self, "commit_message")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> pulumi.Output[str]:
        """
        The SHA of the commit that modified the file.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[str]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def file(self) -> pulumi.Output[str]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable overwriting existing files
        """
        return pulumi.get(self, "overwrite_on_create")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        The repository to create the file in.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def sha(self) -> pulumi.Output[str]:
        """
        The SHA blob of the file.
        """
        return pulumi.get(self, "sha")

