# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 allow_auto_merge: Optional[pulumi.Input[bool]] = None,
                 allow_merge_commit: Optional[pulumi.Input[bool]] = None,
                 allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
                 allow_squash_merge: Optional[pulumi.Input[bool]] = None,
                 allow_update_branch: Optional[pulumi.Input[bool]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_init: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gitignore_template: Optional[pulumi.Input[str]] = None,
                 has_discussions: Optional[pulumi.Input[bool]] = None,
                 has_downloads: Optional[pulumi.Input[bool]] = None,
                 has_issues: Optional[pulumi.Input[bool]] = None,
                 has_projects: Optional[pulumi.Input[bool]] = None,
                 has_wiki: Optional[pulumi.Input[bool]] = None,
                 homepage_url: Optional[pulumi.Input[str]] = None,
                 ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
                 is_template: Optional[pulumi.Input[bool]] = None,
                 license_template: Optional[pulumi.Input[str]] = None,
                 merge_commit_message: Optional[pulumi.Input[str]] = None,
                 merge_commit_title: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input['RepositoryPagesArgs']] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 security_and_analysis: Optional[pulumi.Input['RepositorySecurityAndAnalysisArgs']] = None,
                 squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
                 squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input['RepositoryTemplateArgs']] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 vulnerability_alerts: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[bool] allow_auto_merge: Set to `true` to allow auto-merging pull requests on the repository.
        :param pulumi.Input[bool] allow_merge_commit: Set to `false` to disable merge commits on the repository.
        :param pulumi.Input[bool] allow_rebase_merge: Set to `false` to disable rebase merges on the repository.
        :param pulumi.Input[bool] allow_squash_merge: Set to `false` to disable squash merges on the repository.
        :param pulumi.Input[bool] allow_update_branch: Set to `true` to always suggest updating pull request branches.
        :param pulumi.Input[bool] archive_on_destroy: Set to `true` to archive the repository instead of deleting on destroy.
        :param pulumi.Input[bool] archived: Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        :param pulumi.Input[bool] auto_init: Set to `true` to produce an initial commit in the repository.
        :param pulumi.Input[str] default_branch: (Deprecated: Use `BranchDefault` resource instead) The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
               and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
               initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        :param pulumi.Input[bool] delete_branch_on_merge: Automatically delete head branch after a pull request is merged. Defaults to `false`.
        :param pulumi.Input[str] description: A description of the repository.
        :param pulumi.Input[str] gitignore_template: Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        :param pulumi.Input[bool] has_discussions: Set to `true` to enable GitHub Discussions on the repository. Defaults to `false`.
        :param pulumi.Input[bool] has_downloads: Set to `true` to enable the (deprecated) downloads features on the repository.
        :param pulumi.Input[bool] has_issues: Set to `true` to enable the GitHub Issues features
               on the repository.
        :param pulumi.Input[bool] has_projects: Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        :param pulumi.Input[bool] has_wiki: Set to `true` to enable the GitHub Wiki features on
               the repository.
        :param pulumi.Input[str] homepage_url: URL of a page describing the project.
        :param pulumi.Input[bool] ignore_vulnerability_alerts_during_read: Set to `true` to not call the vulnerability alerts endpoint so the resource can also be used without admin permissions during read.
        :param pulumi.Input[bool] is_template: Set to `true` to tell GitHub that this is a template repository.
        :param pulumi.Input[str] license_template: Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        :param pulumi.Input[str] merge_commit_message: Can be `PR_BODY`, `PR_TITLE`, or `BLANK` for a default merge commit message.
        :param pulumi.Input[str] merge_commit_title: Can be `PR_TITLE` or `MERGE_MESSAGE` for a default merge commit title.
        :param pulumi.Input[str] name: The name of the repository.
        :param pulumi.Input['RepositoryPagesArgs'] pages: The repository's GitHub Pages configuration. See GitHub Pages Configuration below for details.
        :param pulumi.Input[bool] private: Set to `true` to create a private repository.
               Repositories are created as public (e.g. open source) by default.
        :param pulumi.Input['RepositorySecurityAndAnalysisArgs'] security_and_analysis: The repository's [security and analysis](https://docs.github.com/en/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository) configuration. See Security and Analysis Configuration below for details.
        :param pulumi.Input[str] squash_merge_commit_message: Can be `PR_BODY`, `COMMIT_MESSAGES`, or `BLANK` for a default squash merge commit message.
        :param pulumi.Input[str] squash_merge_commit_title: Can be `PR_TITLE` or `COMMIT_OR_PR_TITLE` for a default squash merge commit title.
        :param pulumi.Input['RepositoryTemplateArgs'] template: Use a template repository to create this resource. See Template Repositories below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The list of topics of the repository.
        :param pulumi.Input[str] visibility: Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be `internal`. The `visibility` parameter overrides the `private` parameter.
        :param pulumi.Input[bool] vulnerability_alerts: Set to `true` to enable security alerts for vulnerable dependencies. Enabling requires alerts to be enabled on the owner level. (Note for importing: GitHub enables the alerts on public repos but disables them on private repos by default.) See [GitHub Documentation](https://help.github.com/en/github/managing-security-vulnerabilities/about-security-alerts-for-vulnerable-dependencies) for details. Note that vulnerability alerts have not been successfully tested on any GitHub Enterprise instance and may be unavailable in those settings.
        """
        if allow_auto_merge is not None:
            pulumi.set(__self__, "allow_auto_merge", allow_auto_merge)
        if allow_merge_commit is not None:
            pulumi.set(__self__, "allow_merge_commit", allow_merge_commit)
        if allow_rebase_merge is not None:
            pulumi.set(__self__, "allow_rebase_merge", allow_rebase_merge)
        if allow_squash_merge is not None:
            pulumi.set(__self__, "allow_squash_merge", allow_squash_merge)
        if allow_update_branch is not None:
            pulumi.set(__self__, "allow_update_branch", allow_update_branch)
        if archive_on_destroy is not None:
            pulumi.set(__self__, "archive_on_destroy", archive_on_destroy)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if auto_init is not None:
            pulumi.set(__self__, "auto_init", auto_init)
        if default_branch is not None:
            warnings.warn("""Use the github_branch_default resource instead""", DeprecationWarning)
            pulumi.log.warn("""default_branch is deprecated: Use the github_branch_default resource instead""")
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if delete_branch_on_merge is not None:
            pulumi.set(__self__, "delete_branch_on_merge", delete_branch_on_merge)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gitignore_template is not None:
            pulumi.set(__self__, "gitignore_template", gitignore_template)
        if has_discussions is not None:
            pulumi.set(__self__, "has_discussions", has_discussions)
        if has_downloads is not None:
            pulumi.set(__self__, "has_downloads", has_downloads)
        if has_issues is not None:
            pulumi.set(__self__, "has_issues", has_issues)
        if has_projects is not None:
            pulumi.set(__self__, "has_projects", has_projects)
        if has_wiki is not None:
            pulumi.set(__self__, "has_wiki", has_wiki)
        if homepage_url is not None:
            pulumi.set(__self__, "homepage_url", homepage_url)
        if ignore_vulnerability_alerts_during_read is not None:
            pulumi.set(__self__, "ignore_vulnerability_alerts_during_read", ignore_vulnerability_alerts_during_read)
        if is_template is not None:
            pulumi.set(__self__, "is_template", is_template)
        if license_template is not None:
            pulumi.set(__self__, "license_template", license_template)
        if merge_commit_message is not None:
            pulumi.set(__self__, "merge_commit_message", merge_commit_message)
        if merge_commit_title is not None:
            pulumi.set(__self__, "merge_commit_title", merge_commit_title)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)
        if private is not None:
            warnings.warn("""use visibility instead""", DeprecationWarning)
            pulumi.log.warn("""private is deprecated: use visibility instead""")
        if private is not None:
            pulumi.set(__self__, "private", private)
        if security_and_analysis is not None:
            pulumi.set(__self__, "security_and_analysis", security_and_analysis)
        if squash_merge_commit_message is not None:
            pulumi.set(__self__, "squash_merge_commit_message", squash_merge_commit_message)
        if squash_merge_commit_title is not None:
            pulumi.set(__self__, "squash_merge_commit_title", squash_merge_commit_title)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if vulnerability_alerts is not None:
            pulumi.set(__self__, "vulnerability_alerts", vulnerability_alerts)

    @property
    @pulumi.getter(name="allowAutoMerge")
    def allow_auto_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to allow auto-merging pull requests on the repository.
        """
        return pulumi.get(self, "allow_auto_merge")

    @allow_auto_merge.setter
    def allow_auto_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_auto_merge", value)

    @property
    @pulumi.getter(name="allowMergeCommit")
    def allow_merge_commit(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `false` to disable merge commits on the repository.
        """
        return pulumi.get(self, "allow_merge_commit")

    @allow_merge_commit.setter
    def allow_merge_commit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_merge_commit", value)

    @property
    @pulumi.getter(name="allowRebaseMerge")
    def allow_rebase_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `false` to disable rebase merges on the repository.
        """
        return pulumi.get(self, "allow_rebase_merge")

    @allow_rebase_merge.setter
    def allow_rebase_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_rebase_merge", value)

    @property
    @pulumi.getter(name="allowSquashMerge")
    def allow_squash_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `false` to disable squash merges on the repository.
        """
        return pulumi.get(self, "allow_squash_merge")

    @allow_squash_merge.setter
    def allow_squash_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_squash_merge", value)

    @property
    @pulumi.getter(name="allowUpdateBranch")
    def allow_update_branch(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to always suggest updating pull request branches.
        """
        return pulumi.get(self, "allow_update_branch")

    @allow_update_branch.setter
    def allow_update_branch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_update_branch", value)

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to archive the repository instead of deleting on destroy.
        """
        return pulumi.get(self, "archive_on_destroy")

    @archive_on_destroy.setter
    def archive_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archive_on_destroy", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="autoInit")
    def auto_init(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to produce an initial commit in the repository.
        """
        return pulumi.get(self, "auto_init")

    @auto_init.setter
    def auto_init(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_init", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        (Deprecated: Use `BranchDefault` resource instead) The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
        and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
        initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter(name="deleteBranchOnMerge")
    def delete_branch_on_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically delete head branch after a pull request is merged. Defaults to `false`.
        """
        return pulumi.get(self, "delete_branch_on_merge")

    @delete_branch_on_merge.setter
    def delete_branch_on_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_branch_on_merge", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the repository.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gitignoreTemplate")
    def gitignore_template(self) -> Optional[pulumi.Input[str]]:
        """
        Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        """
        return pulumi.get(self, "gitignore_template")

    @gitignore_template.setter
    def gitignore_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gitignore_template", value)

    @property
    @pulumi.getter(name="hasDiscussions")
    def has_discussions(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable GitHub Discussions on the repository. Defaults to `false`.
        """
        return pulumi.get(self, "has_discussions")

    @has_discussions.setter
    def has_discussions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_discussions", value)

    @property
    @pulumi.getter(name="hasDownloads")
    def has_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable the (deprecated) downloads features on the repository.
        """
        return pulumi.get(self, "has_downloads")

    @has_downloads.setter
    def has_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_downloads", value)

    @property
    @pulumi.getter(name="hasIssues")
    def has_issues(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable the GitHub Issues features
        on the repository.
        """
        return pulumi.get(self, "has_issues")

    @has_issues.setter
    def has_issues(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_issues", value)

    @property
    @pulumi.getter(name="hasProjects")
    def has_projects(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        """
        return pulumi.get(self, "has_projects")

    @has_projects.setter
    def has_projects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_projects", value)

    @property
    @pulumi.getter(name="hasWiki")
    def has_wiki(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable the GitHub Wiki features on
        the repository.
        """
        return pulumi.get(self, "has_wiki")

    @has_wiki.setter
    def has_wiki(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_wiki", value)

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of a page describing the project.
        """
        return pulumi.get(self, "homepage_url")

    @homepage_url.setter
    def homepage_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "homepage_url", value)

    @property
    @pulumi.getter(name="ignoreVulnerabilityAlertsDuringRead")
    def ignore_vulnerability_alerts_during_read(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to not call the vulnerability alerts endpoint so the resource can also be used without admin permissions during read.
        """
        return pulumi.get(self, "ignore_vulnerability_alerts_during_read")

    @ignore_vulnerability_alerts_during_read.setter
    def ignore_vulnerability_alerts_during_read(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_vulnerability_alerts_during_read", value)

    @property
    @pulumi.getter(name="isTemplate")
    def is_template(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to tell GitHub that this is a template repository.
        """
        return pulumi.get(self, "is_template")

    @is_template.setter
    def is_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_template", value)

    @property
    @pulumi.getter(name="licenseTemplate")
    def license_template(self) -> Optional[pulumi.Input[str]]:
        """
        Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        """
        return pulumi.get(self, "license_template")

    @license_template.setter
    def license_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_template", value)

    @property
    @pulumi.getter(name="mergeCommitMessage")
    def merge_commit_message(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `PR_BODY`, `PR_TITLE`, or `BLANK` for a default merge commit message.
        """
        return pulumi.get(self, "merge_commit_message")

    @merge_commit_message.setter
    def merge_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_message", value)

    @property
    @pulumi.getter(name="mergeCommitTitle")
    def merge_commit_title(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `PR_TITLE` or `MERGE_MESSAGE` for a default merge commit title.
        """
        return pulumi.get(self, "merge_commit_title")

    @merge_commit_title.setter
    def merge_commit_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_title", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pages(self) -> Optional[pulumi.Input['RepositoryPagesArgs']]:
        """
        The repository's GitHub Pages configuration. See GitHub Pages Configuration below for details.
        """
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: Optional[pulumi.Input['RepositoryPagesArgs']]):
        pulumi.set(self, "pages", value)

    @property
    @pulumi.getter
    def private(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to create a private repository.
        Repositories are created as public (e.g. open source) by default.
        """
        return pulumi.get(self, "private")

    @private.setter
    def private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private", value)

    @property
    @pulumi.getter(name="securityAndAnalysis")
    def security_and_analysis(self) -> Optional[pulumi.Input['RepositorySecurityAndAnalysisArgs']]:
        """
        The repository's [security and analysis](https://docs.github.com/en/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository) configuration. See Security and Analysis Configuration below for details.
        """
        return pulumi.get(self, "security_and_analysis")

    @security_and_analysis.setter
    def security_and_analysis(self, value: Optional[pulumi.Input['RepositorySecurityAndAnalysisArgs']]):
        pulumi.set(self, "security_and_analysis", value)

    @property
    @pulumi.getter(name="squashMergeCommitMessage")
    def squash_merge_commit_message(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `PR_BODY`, `COMMIT_MESSAGES`, or `BLANK` for a default squash merge commit message.
        """
        return pulumi.get(self, "squash_merge_commit_message")

    @squash_merge_commit_message.setter
    def squash_merge_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_merge_commit_message", value)

    @property
    @pulumi.getter(name="squashMergeCommitTitle")
    def squash_merge_commit_title(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `PR_TITLE` or `COMMIT_OR_PR_TITLE` for a default squash merge commit title.
        """
        return pulumi.get(self, "squash_merge_commit_title")

    @squash_merge_commit_title.setter
    def squash_merge_commit_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_merge_commit_title", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['RepositoryTemplateArgs']]:
        """
        Use a template repository to create this resource. See Template Repositories below for details.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['RepositoryTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of topics of the repository.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be `internal`. The `visibility` parameter overrides the `private` parameter.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="vulnerabilityAlerts")
    def vulnerability_alerts(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable security alerts for vulnerable dependencies. Enabling requires alerts to be enabled on the owner level. (Note for importing: GitHub enables the alerts on public repos but disables them on private repos by default.) See [GitHub Documentation](https://help.github.com/en/github/managing-security-vulnerabilities/about-security-alerts-for-vulnerable-dependencies) for details. Note that vulnerability alerts have not been successfully tested on any GitHub Enterprise instance and may be unavailable in those settings.
        """
        return pulumi.get(self, "vulnerability_alerts")

    @vulnerability_alerts.setter
    def vulnerability_alerts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vulnerability_alerts", value)


@pulumi.input_type
class _RepositoryState:
    def __init__(__self__, *,
                 allow_auto_merge: Optional[pulumi.Input[bool]] = None,
                 allow_merge_commit: Optional[pulumi.Input[bool]] = None,
                 allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
                 allow_squash_merge: Optional[pulumi.Input[bool]] = None,
                 allow_update_branch: Optional[pulumi.Input[bool]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_init: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 git_clone_url: Optional[pulumi.Input[str]] = None,
                 gitignore_template: Optional[pulumi.Input[str]] = None,
                 has_discussions: Optional[pulumi.Input[bool]] = None,
                 has_downloads: Optional[pulumi.Input[bool]] = None,
                 has_issues: Optional[pulumi.Input[bool]] = None,
                 has_projects: Optional[pulumi.Input[bool]] = None,
                 has_wiki: Optional[pulumi.Input[bool]] = None,
                 homepage_url: Optional[pulumi.Input[str]] = None,
                 html_url: Optional[pulumi.Input[str]] = None,
                 http_clone_url: Optional[pulumi.Input[str]] = None,
                 ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
                 is_template: Optional[pulumi.Input[bool]] = None,
                 license_template: Optional[pulumi.Input[str]] = None,
                 merge_commit_message: Optional[pulumi.Input[str]] = None,
                 merge_commit_title: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_id: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input['RepositoryPagesArgs']] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 repo_id: Optional[pulumi.Input[int]] = None,
                 security_and_analysis: Optional[pulumi.Input['RepositorySecurityAndAnalysisArgs']] = None,
                 squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
                 squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
                 ssh_clone_url: Optional[pulumi.Input[str]] = None,
                 svn_url: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input['RepositoryTemplateArgs']] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 vulnerability_alerts: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Repository resources.
        :param pulumi.Input[bool] allow_auto_merge: Set to `true` to allow auto-merging pull requests on the repository.
        :param pulumi.Input[bool] allow_merge_commit: Set to `false` to disable merge commits on the repository.
        :param pulumi.Input[bool] allow_rebase_merge: Set to `false` to disable rebase merges on the repository.
        :param pulumi.Input[bool] allow_squash_merge: Set to `false` to disable squash merges on the repository.
        :param pulumi.Input[bool] allow_update_branch: Set to `true` to always suggest updating pull request branches.
        :param pulumi.Input[bool] archive_on_destroy: Set to `true` to archive the repository instead of deleting on destroy.
        :param pulumi.Input[bool] archived: Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        :param pulumi.Input[bool] auto_init: Set to `true` to produce an initial commit in the repository.
        :param pulumi.Input[str] default_branch: (Deprecated: Use `BranchDefault` resource instead) The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
               and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
               initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        :param pulumi.Input[bool] delete_branch_on_merge: Automatically delete head branch after a pull request is merged. Defaults to `false`.
        :param pulumi.Input[str] description: A description of the repository.
        :param pulumi.Input[str] full_name: A string of the form "orgname/reponame".
        :param pulumi.Input[str] git_clone_url: URL that can be provided to `git clone` to clone the repository anonymously via the git protocol.
        :param pulumi.Input[str] gitignore_template: Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        :param pulumi.Input[bool] has_discussions: Set to `true` to enable GitHub Discussions on the repository. Defaults to `false`.
        :param pulumi.Input[bool] has_downloads: Set to `true` to enable the (deprecated) downloads features on the repository.
        :param pulumi.Input[bool] has_issues: Set to `true` to enable the GitHub Issues features
               on the repository.
        :param pulumi.Input[bool] has_projects: Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        :param pulumi.Input[bool] has_wiki: Set to `true` to enable the GitHub Wiki features on
               the repository.
        :param pulumi.Input[str] homepage_url: URL of a page describing the project.
        :param pulumi.Input[str] html_url: The absolute URL (including scheme) of the rendered GitHub Pages site e.g. `https://username.github.io`.
        :param pulumi.Input[str] http_clone_url: URL that can be provided to `git clone` to clone the repository via HTTPS.
        :param pulumi.Input[bool] ignore_vulnerability_alerts_during_read: Set to `true` to not call the vulnerability alerts endpoint so the resource can also be used without admin permissions during read.
        :param pulumi.Input[bool] is_template: Set to `true` to tell GitHub that this is a template repository.
        :param pulumi.Input[str] license_template: Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        :param pulumi.Input[str] merge_commit_message: Can be `PR_BODY`, `PR_TITLE`, or `BLANK` for a default merge commit message.
        :param pulumi.Input[str] merge_commit_title: Can be `PR_TITLE` or `MERGE_MESSAGE` for a default merge commit title.
        :param pulumi.Input[str] name: The name of the repository.
        :param pulumi.Input[str] node_id: GraphQL global node id for use with v4 API
        :param pulumi.Input['RepositoryPagesArgs'] pages: The repository's GitHub Pages configuration. See GitHub Pages Configuration below for details.
        :param pulumi.Input[bool] private: Set to `true` to create a private repository.
               Repositories are created as public (e.g. open source) by default.
        :param pulumi.Input[int] repo_id: GitHub ID for the repository
        :param pulumi.Input['RepositorySecurityAndAnalysisArgs'] security_and_analysis: The repository's [security and analysis](https://docs.github.com/en/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository) configuration. See Security and Analysis Configuration below for details.
        :param pulumi.Input[str] squash_merge_commit_message: Can be `PR_BODY`, `COMMIT_MESSAGES`, or `BLANK` for a default squash merge commit message.
        :param pulumi.Input[str] squash_merge_commit_title: Can be `PR_TITLE` or `COMMIT_OR_PR_TITLE` for a default squash merge commit title.
        :param pulumi.Input[str] ssh_clone_url: URL that can be provided to `git clone` to clone the repository via SSH.
        :param pulumi.Input[str] svn_url: URL that can be provided to `svn checkout` to check out the repository via GitHub's Subversion protocol emulation.
        :param pulumi.Input['RepositoryTemplateArgs'] template: Use a template repository to create this resource. See Template Repositories below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The list of topics of the repository.
        :param pulumi.Input[str] visibility: Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be `internal`. The `visibility` parameter overrides the `private` parameter.
        :param pulumi.Input[bool] vulnerability_alerts: Set to `true` to enable security alerts for vulnerable dependencies. Enabling requires alerts to be enabled on the owner level. (Note for importing: GitHub enables the alerts on public repos but disables them on private repos by default.) See [GitHub Documentation](https://help.github.com/en/github/managing-security-vulnerabilities/about-security-alerts-for-vulnerable-dependencies) for details. Note that vulnerability alerts have not been successfully tested on any GitHub Enterprise instance and may be unavailable in those settings.
        """
        if allow_auto_merge is not None:
            pulumi.set(__self__, "allow_auto_merge", allow_auto_merge)
        if allow_merge_commit is not None:
            pulumi.set(__self__, "allow_merge_commit", allow_merge_commit)
        if allow_rebase_merge is not None:
            pulumi.set(__self__, "allow_rebase_merge", allow_rebase_merge)
        if allow_squash_merge is not None:
            pulumi.set(__self__, "allow_squash_merge", allow_squash_merge)
        if allow_update_branch is not None:
            pulumi.set(__self__, "allow_update_branch", allow_update_branch)
        if archive_on_destroy is not None:
            pulumi.set(__self__, "archive_on_destroy", archive_on_destroy)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if auto_init is not None:
            pulumi.set(__self__, "auto_init", auto_init)
        if default_branch is not None:
            warnings.warn("""Use the github_branch_default resource instead""", DeprecationWarning)
            pulumi.log.warn("""default_branch is deprecated: Use the github_branch_default resource instead""")
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if delete_branch_on_merge is not None:
            pulumi.set(__self__, "delete_branch_on_merge", delete_branch_on_merge)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if git_clone_url is not None:
            pulumi.set(__self__, "git_clone_url", git_clone_url)
        if gitignore_template is not None:
            pulumi.set(__self__, "gitignore_template", gitignore_template)
        if has_discussions is not None:
            pulumi.set(__self__, "has_discussions", has_discussions)
        if has_downloads is not None:
            pulumi.set(__self__, "has_downloads", has_downloads)
        if has_issues is not None:
            pulumi.set(__self__, "has_issues", has_issues)
        if has_projects is not None:
            pulumi.set(__self__, "has_projects", has_projects)
        if has_wiki is not None:
            pulumi.set(__self__, "has_wiki", has_wiki)
        if homepage_url is not None:
            pulumi.set(__self__, "homepage_url", homepage_url)
        if html_url is not None:
            pulumi.set(__self__, "html_url", html_url)
        if http_clone_url is not None:
            pulumi.set(__self__, "http_clone_url", http_clone_url)
        if ignore_vulnerability_alerts_during_read is not None:
            pulumi.set(__self__, "ignore_vulnerability_alerts_during_read", ignore_vulnerability_alerts_during_read)
        if is_template is not None:
            pulumi.set(__self__, "is_template", is_template)
        if license_template is not None:
            pulumi.set(__self__, "license_template", license_template)
        if merge_commit_message is not None:
            pulumi.set(__self__, "merge_commit_message", merge_commit_message)
        if merge_commit_title is not None:
            pulumi.set(__self__, "merge_commit_title", merge_commit_title)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)
        if private is not None:
            warnings.warn("""use visibility instead""", DeprecationWarning)
            pulumi.log.warn("""private is deprecated: use visibility instead""")
        if private is not None:
            pulumi.set(__self__, "private", private)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if security_and_analysis is not None:
            pulumi.set(__self__, "security_and_analysis", security_and_analysis)
        if squash_merge_commit_message is not None:
            pulumi.set(__self__, "squash_merge_commit_message", squash_merge_commit_message)
        if squash_merge_commit_title is not None:
            pulumi.set(__self__, "squash_merge_commit_title", squash_merge_commit_title)
        if ssh_clone_url is not None:
            pulumi.set(__self__, "ssh_clone_url", ssh_clone_url)
        if svn_url is not None:
            pulumi.set(__self__, "svn_url", svn_url)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if vulnerability_alerts is not None:
            pulumi.set(__self__, "vulnerability_alerts", vulnerability_alerts)

    @property
    @pulumi.getter(name="allowAutoMerge")
    def allow_auto_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to allow auto-merging pull requests on the repository.
        """
        return pulumi.get(self, "allow_auto_merge")

    @allow_auto_merge.setter
    def allow_auto_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_auto_merge", value)

    @property
    @pulumi.getter(name="allowMergeCommit")
    def allow_merge_commit(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `false` to disable merge commits on the repository.
        """
        return pulumi.get(self, "allow_merge_commit")

    @allow_merge_commit.setter
    def allow_merge_commit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_merge_commit", value)

    @property
    @pulumi.getter(name="allowRebaseMerge")
    def allow_rebase_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `false` to disable rebase merges on the repository.
        """
        return pulumi.get(self, "allow_rebase_merge")

    @allow_rebase_merge.setter
    def allow_rebase_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_rebase_merge", value)

    @property
    @pulumi.getter(name="allowSquashMerge")
    def allow_squash_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `false` to disable squash merges on the repository.
        """
        return pulumi.get(self, "allow_squash_merge")

    @allow_squash_merge.setter
    def allow_squash_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_squash_merge", value)

    @property
    @pulumi.getter(name="allowUpdateBranch")
    def allow_update_branch(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to always suggest updating pull request branches.
        """
        return pulumi.get(self, "allow_update_branch")

    @allow_update_branch.setter
    def allow_update_branch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_update_branch", value)

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to archive the repository instead of deleting on destroy.
        """
        return pulumi.get(self, "archive_on_destroy")

    @archive_on_destroy.setter
    def archive_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archive_on_destroy", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="autoInit")
    def auto_init(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to produce an initial commit in the repository.
        """
        return pulumi.get(self, "auto_init")

    @auto_init.setter
    def auto_init(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_init", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        (Deprecated: Use `BranchDefault` resource instead) The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
        and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
        initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter(name="deleteBranchOnMerge")
    def delete_branch_on_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically delete head branch after a pull request is merged. Defaults to `false`.
        """
        return pulumi.get(self, "delete_branch_on_merge")

    @delete_branch_on_merge.setter
    def delete_branch_on_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_branch_on_merge", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the repository.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        A string of the form "orgname/reponame".
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="gitCloneUrl")
    def git_clone_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that can be provided to `git clone` to clone the repository anonymously via the git protocol.
        """
        return pulumi.get(self, "git_clone_url")

    @git_clone_url.setter
    def git_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "git_clone_url", value)

    @property
    @pulumi.getter(name="gitignoreTemplate")
    def gitignore_template(self) -> Optional[pulumi.Input[str]]:
        """
        Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        """
        return pulumi.get(self, "gitignore_template")

    @gitignore_template.setter
    def gitignore_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gitignore_template", value)

    @property
    @pulumi.getter(name="hasDiscussions")
    def has_discussions(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable GitHub Discussions on the repository. Defaults to `false`.
        """
        return pulumi.get(self, "has_discussions")

    @has_discussions.setter
    def has_discussions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_discussions", value)

    @property
    @pulumi.getter(name="hasDownloads")
    def has_downloads(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable the (deprecated) downloads features on the repository.
        """
        return pulumi.get(self, "has_downloads")

    @has_downloads.setter
    def has_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_downloads", value)

    @property
    @pulumi.getter(name="hasIssues")
    def has_issues(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable the GitHub Issues features
        on the repository.
        """
        return pulumi.get(self, "has_issues")

    @has_issues.setter
    def has_issues(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_issues", value)

    @property
    @pulumi.getter(name="hasProjects")
    def has_projects(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        """
        return pulumi.get(self, "has_projects")

    @has_projects.setter
    def has_projects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_projects", value)

    @property
    @pulumi.getter(name="hasWiki")
    def has_wiki(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable the GitHub Wiki features on
        the repository.
        """
        return pulumi.get(self, "has_wiki")

    @has_wiki.setter
    def has_wiki(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_wiki", value)

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of a page describing the project.
        """
        return pulumi.get(self, "homepage_url")

    @homepage_url.setter
    def homepage_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "homepage_url", value)

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute URL (including scheme) of the rendered GitHub Pages site e.g. `https://username.github.io`.
        """
        return pulumi.get(self, "html_url")

    @html_url.setter
    def html_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "html_url", value)

    @property
    @pulumi.getter(name="httpCloneUrl")
    def http_clone_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that can be provided to `git clone` to clone the repository via HTTPS.
        """
        return pulumi.get(self, "http_clone_url")

    @http_clone_url.setter
    def http_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_clone_url", value)

    @property
    @pulumi.getter(name="ignoreVulnerabilityAlertsDuringRead")
    def ignore_vulnerability_alerts_during_read(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to not call the vulnerability alerts endpoint so the resource can also be used without admin permissions during read.
        """
        return pulumi.get(self, "ignore_vulnerability_alerts_during_read")

    @ignore_vulnerability_alerts_during_read.setter
    def ignore_vulnerability_alerts_during_read(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_vulnerability_alerts_during_read", value)

    @property
    @pulumi.getter(name="isTemplate")
    def is_template(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to tell GitHub that this is a template repository.
        """
        return pulumi.get(self, "is_template")

    @is_template.setter
    def is_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_template", value)

    @property
    @pulumi.getter(name="licenseTemplate")
    def license_template(self) -> Optional[pulumi.Input[str]]:
        """
        Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        """
        return pulumi.get(self, "license_template")

    @license_template.setter
    def license_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_template", value)

    @property
    @pulumi.getter(name="mergeCommitMessage")
    def merge_commit_message(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `PR_BODY`, `PR_TITLE`, or `BLANK` for a default merge commit message.
        """
        return pulumi.get(self, "merge_commit_message")

    @merge_commit_message.setter
    def merge_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_message", value)

    @property
    @pulumi.getter(name="mergeCommitTitle")
    def merge_commit_title(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `PR_TITLE` or `MERGE_MESSAGE` for a default merge commit title.
        """
        return pulumi.get(self, "merge_commit_title")

    @merge_commit_title.setter
    def merge_commit_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_title", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[str]]:
        """
        GraphQL global node id for use with v4 API
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter
    def pages(self) -> Optional[pulumi.Input['RepositoryPagesArgs']]:
        """
        The repository's GitHub Pages configuration. See GitHub Pages Configuration below for details.
        """
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: Optional[pulumi.Input['RepositoryPagesArgs']]):
        pulumi.set(self, "pages", value)

    @property
    @pulumi.getter
    def private(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to create a private repository.
        Repositories are created as public (e.g. open source) by default.
        """
        return pulumi.get(self, "private")

    @private.setter
    def private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private", value)

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input[int]]:
        """
        GitHub ID for the repository
        """
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "repo_id", value)

    @property
    @pulumi.getter(name="securityAndAnalysis")
    def security_and_analysis(self) -> Optional[pulumi.Input['RepositorySecurityAndAnalysisArgs']]:
        """
        The repository's [security and analysis](https://docs.github.com/en/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository) configuration. See Security and Analysis Configuration below for details.
        """
        return pulumi.get(self, "security_and_analysis")

    @security_and_analysis.setter
    def security_and_analysis(self, value: Optional[pulumi.Input['RepositorySecurityAndAnalysisArgs']]):
        pulumi.set(self, "security_and_analysis", value)

    @property
    @pulumi.getter(name="squashMergeCommitMessage")
    def squash_merge_commit_message(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `PR_BODY`, `COMMIT_MESSAGES`, or `BLANK` for a default squash merge commit message.
        """
        return pulumi.get(self, "squash_merge_commit_message")

    @squash_merge_commit_message.setter
    def squash_merge_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_merge_commit_message", value)

    @property
    @pulumi.getter(name="squashMergeCommitTitle")
    def squash_merge_commit_title(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `PR_TITLE` or `COMMIT_OR_PR_TITLE` for a default squash merge commit title.
        """
        return pulumi.get(self, "squash_merge_commit_title")

    @squash_merge_commit_title.setter
    def squash_merge_commit_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_merge_commit_title", value)

    @property
    @pulumi.getter(name="sshCloneUrl")
    def ssh_clone_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that can be provided to `git clone` to clone the repository via SSH.
        """
        return pulumi.get(self, "ssh_clone_url")

    @ssh_clone_url.setter
    def ssh_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_clone_url", value)

    @property
    @pulumi.getter(name="svnUrl")
    def svn_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that can be provided to `svn checkout` to check out the repository via GitHub's Subversion protocol emulation.
        """
        return pulumi.get(self, "svn_url")

    @svn_url.setter
    def svn_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "svn_url", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['RepositoryTemplateArgs']]:
        """
        Use a template repository to create this resource. See Template Repositories below for details.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['RepositoryTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of topics of the repository.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[str]]:
        """
        Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be `internal`. The `visibility` parameter overrides the `private` parameter.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="vulnerabilityAlerts")
    def vulnerability_alerts(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to enable security alerts for vulnerable dependencies. Enabling requires alerts to be enabled on the owner level. (Note for importing: GitHub enables the alerts on public repos but disables them on private repos by default.) See [GitHub Documentation](https://help.github.com/en/github/managing-security-vulnerabilities/about-security-alerts-for-vulnerable-dependencies) for details. Note that vulnerability alerts have not been successfully tested on any GitHub Enterprise instance and may be unavailable in those settings.
        """
        return pulumi.get(self, "vulnerability_alerts")

    @vulnerability_alerts.setter
    def vulnerability_alerts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vulnerability_alerts", value)


class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_auto_merge: Optional[pulumi.Input[bool]] = None,
                 allow_merge_commit: Optional[pulumi.Input[bool]] = None,
                 allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
                 allow_squash_merge: Optional[pulumi.Input[bool]] = None,
                 allow_update_branch: Optional[pulumi.Input[bool]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_init: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gitignore_template: Optional[pulumi.Input[str]] = None,
                 has_discussions: Optional[pulumi.Input[bool]] = None,
                 has_downloads: Optional[pulumi.Input[bool]] = None,
                 has_issues: Optional[pulumi.Input[bool]] = None,
                 has_projects: Optional[pulumi.Input[bool]] = None,
                 has_wiki: Optional[pulumi.Input[bool]] = None,
                 homepage_url: Optional[pulumi.Input[str]] = None,
                 ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
                 is_template: Optional[pulumi.Input[bool]] = None,
                 license_template: Optional[pulumi.Input[str]] = None,
                 merge_commit_message: Optional[pulumi.Input[str]] = None,
                 merge_commit_title: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input[pulumi.InputType['RepositoryPagesArgs']]] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 security_and_analysis: Optional[pulumi.Input[pulumi.InputType['RepositorySecurityAndAnalysisArgs']]] = None,
                 squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
                 squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['RepositoryTemplateArgs']]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 vulnerability_alerts: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage repositories within your
        GitHub organization or personal account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example",
            description="My awesome codebase",
            template=github.RepositoryTemplateArgs(
                include_all_branches=True,
                owner="github",
                repository="terraform-template-module",
            ),
            visibility="public")
        ```
        ### With GitHub Pages Enabled

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example",
            description="My awesome web page",
            pages=github.RepositoryPagesArgs(
                source=github.RepositoryPagesSourceArgs(
                    branch="master",
                    path="/docs",
                ),
            ),
            private=False)
        ```

        ## Import

        Repositories can be imported using the `name`, e.g.

        ```sh
         $ pulumi import github:index/repository:Repository terraform terraform
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_auto_merge: Set to `true` to allow auto-merging pull requests on the repository.
        :param pulumi.Input[bool] allow_merge_commit: Set to `false` to disable merge commits on the repository.
        :param pulumi.Input[bool] allow_rebase_merge: Set to `false` to disable rebase merges on the repository.
        :param pulumi.Input[bool] allow_squash_merge: Set to `false` to disable squash merges on the repository.
        :param pulumi.Input[bool] allow_update_branch: Set to `true` to always suggest updating pull request branches.
        :param pulumi.Input[bool] archive_on_destroy: Set to `true` to archive the repository instead of deleting on destroy.
        :param pulumi.Input[bool] archived: Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        :param pulumi.Input[bool] auto_init: Set to `true` to produce an initial commit in the repository.
        :param pulumi.Input[str] default_branch: (Deprecated: Use `BranchDefault` resource instead) The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
               and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
               initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        :param pulumi.Input[bool] delete_branch_on_merge: Automatically delete head branch after a pull request is merged. Defaults to `false`.
        :param pulumi.Input[str] description: A description of the repository.
        :param pulumi.Input[str] gitignore_template: Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        :param pulumi.Input[bool] has_discussions: Set to `true` to enable GitHub Discussions on the repository. Defaults to `false`.
        :param pulumi.Input[bool] has_downloads: Set to `true` to enable the (deprecated) downloads features on the repository.
        :param pulumi.Input[bool] has_issues: Set to `true` to enable the GitHub Issues features
               on the repository.
        :param pulumi.Input[bool] has_projects: Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        :param pulumi.Input[bool] has_wiki: Set to `true` to enable the GitHub Wiki features on
               the repository.
        :param pulumi.Input[str] homepage_url: URL of a page describing the project.
        :param pulumi.Input[bool] ignore_vulnerability_alerts_during_read: Set to `true` to not call the vulnerability alerts endpoint so the resource can also be used without admin permissions during read.
        :param pulumi.Input[bool] is_template: Set to `true` to tell GitHub that this is a template repository.
        :param pulumi.Input[str] license_template: Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        :param pulumi.Input[str] merge_commit_message: Can be `PR_BODY`, `PR_TITLE`, or `BLANK` for a default merge commit message.
        :param pulumi.Input[str] merge_commit_title: Can be `PR_TITLE` or `MERGE_MESSAGE` for a default merge commit title.
        :param pulumi.Input[str] name: The name of the repository.
        :param pulumi.Input[pulumi.InputType['RepositoryPagesArgs']] pages: The repository's GitHub Pages configuration. See GitHub Pages Configuration below for details.
        :param pulumi.Input[bool] private: Set to `true` to create a private repository.
               Repositories are created as public (e.g. open source) by default.
        :param pulumi.Input[pulumi.InputType['RepositorySecurityAndAnalysisArgs']] security_and_analysis: The repository's [security and analysis](https://docs.github.com/en/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository) configuration. See Security and Analysis Configuration below for details.
        :param pulumi.Input[str] squash_merge_commit_message: Can be `PR_BODY`, `COMMIT_MESSAGES`, or `BLANK` for a default squash merge commit message.
        :param pulumi.Input[str] squash_merge_commit_title: Can be `PR_TITLE` or `COMMIT_OR_PR_TITLE` for a default squash merge commit title.
        :param pulumi.Input[pulumi.InputType['RepositoryTemplateArgs']] template: Use a template repository to create this resource. See Template Repositories below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The list of topics of the repository.
        :param pulumi.Input[str] visibility: Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be `internal`. The `visibility` parameter overrides the `private` parameter.
        :param pulumi.Input[bool] vulnerability_alerts: Set to `true` to enable security alerts for vulnerable dependencies. Enabling requires alerts to be enabled on the owner level. (Note for importing: GitHub enables the alerts on public repos but disables them on private repos by default.) See [GitHub Documentation](https://help.github.com/en/github/managing-security-vulnerabilities/about-security-alerts-for-vulnerable-dependencies) for details. Note that vulnerability alerts have not been successfully tested on any GitHub Enterprise instance and may be unavailable in those settings.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RepositoryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage repositories within your
        GitHub organization or personal account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example",
            description="My awesome codebase",
            template=github.RepositoryTemplateArgs(
                include_all_branches=True,
                owner="github",
                repository="terraform-template-module",
            ),
            visibility="public")
        ```
        ### With GitHub Pages Enabled

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example",
            description="My awesome web page",
            pages=github.RepositoryPagesArgs(
                source=github.RepositoryPagesSourceArgs(
                    branch="master",
                    path="/docs",
                ),
            ),
            private=False)
        ```

        ## Import

        Repositories can be imported using the `name`, e.g.

        ```sh
         $ pulumi import github:index/repository:Repository terraform terraform
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_auto_merge: Optional[pulumi.Input[bool]] = None,
                 allow_merge_commit: Optional[pulumi.Input[bool]] = None,
                 allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
                 allow_squash_merge: Optional[pulumi.Input[bool]] = None,
                 allow_update_branch: Optional[pulumi.Input[bool]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_init: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gitignore_template: Optional[pulumi.Input[str]] = None,
                 has_discussions: Optional[pulumi.Input[bool]] = None,
                 has_downloads: Optional[pulumi.Input[bool]] = None,
                 has_issues: Optional[pulumi.Input[bool]] = None,
                 has_projects: Optional[pulumi.Input[bool]] = None,
                 has_wiki: Optional[pulumi.Input[bool]] = None,
                 homepage_url: Optional[pulumi.Input[str]] = None,
                 ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
                 is_template: Optional[pulumi.Input[bool]] = None,
                 license_template: Optional[pulumi.Input[str]] = None,
                 merge_commit_message: Optional[pulumi.Input[str]] = None,
                 merge_commit_title: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input[pulumi.InputType['RepositoryPagesArgs']]] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 security_and_analysis: Optional[pulumi.Input[pulumi.InputType['RepositorySecurityAndAnalysisArgs']]] = None,
                 squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
                 squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['RepositoryTemplateArgs']]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 vulnerability_alerts: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["allow_auto_merge"] = allow_auto_merge
            __props__.__dict__["allow_merge_commit"] = allow_merge_commit
            __props__.__dict__["allow_rebase_merge"] = allow_rebase_merge
            __props__.__dict__["allow_squash_merge"] = allow_squash_merge
            __props__.__dict__["allow_update_branch"] = allow_update_branch
            __props__.__dict__["archive_on_destroy"] = archive_on_destroy
            __props__.__dict__["archived"] = archived
            __props__.__dict__["auto_init"] = auto_init
            if default_branch is not None and not opts.urn:
                warnings.warn("""Use the github_branch_default resource instead""", DeprecationWarning)
                pulumi.log.warn("""default_branch is deprecated: Use the github_branch_default resource instead""")
            __props__.__dict__["default_branch"] = default_branch
            __props__.__dict__["delete_branch_on_merge"] = delete_branch_on_merge
            __props__.__dict__["description"] = description
            __props__.__dict__["gitignore_template"] = gitignore_template
            __props__.__dict__["has_discussions"] = has_discussions
            __props__.__dict__["has_downloads"] = has_downloads
            __props__.__dict__["has_issues"] = has_issues
            __props__.__dict__["has_projects"] = has_projects
            __props__.__dict__["has_wiki"] = has_wiki
            __props__.__dict__["homepage_url"] = homepage_url
            __props__.__dict__["ignore_vulnerability_alerts_during_read"] = ignore_vulnerability_alerts_during_read
            __props__.__dict__["is_template"] = is_template
            __props__.__dict__["license_template"] = license_template
            __props__.__dict__["merge_commit_message"] = merge_commit_message
            __props__.__dict__["merge_commit_title"] = merge_commit_title
            __props__.__dict__["name"] = name
            __props__.__dict__["pages"] = pages
            if private is not None and not opts.urn:
                warnings.warn("""use visibility instead""", DeprecationWarning)
                pulumi.log.warn("""private is deprecated: use visibility instead""")
            __props__.__dict__["private"] = private
            __props__.__dict__["security_and_analysis"] = security_and_analysis
            __props__.__dict__["squash_merge_commit_message"] = squash_merge_commit_message
            __props__.__dict__["squash_merge_commit_title"] = squash_merge_commit_title
            __props__.__dict__["template"] = template
            __props__.__dict__["topics"] = topics
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["vulnerability_alerts"] = vulnerability_alerts
            __props__.__dict__["etag"] = None
            __props__.__dict__["full_name"] = None
            __props__.__dict__["git_clone_url"] = None
            __props__.__dict__["html_url"] = None
            __props__.__dict__["http_clone_url"] = None
            __props__.__dict__["node_id"] = None
            __props__.__dict__["repo_id"] = None
            __props__.__dict__["ssh_clone_url"] = None
            __props__.__dict__["svn_url"] = None
        super(Repository, __self__).__init__(
            'github:index/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_auto_merge: Optional[pulumi.Input[bool]] = None,
            allow_merge_commit: Optional[pulumi.Input[bool]] = None,
            allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
            allow_squash_merge: Optional[pulumi.Input[bool]] = None,
            allow_update_branch: Optional[pulumi.Input[bool]] = None,
            archive_on_destroy: Optional[pulumi.Input[bool]] = None,
            archived: Optional[pulumi.Input[bool]] = None,
            auto_init: Optional[pulumi.Input[bool]] = None,
            default_branch: Optional[pulumi.Input[str]] = None,
            delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            full_name: Optional[pulumi.Input[str]] = None,
            git_clone_url: Optional[pulumi.Input[str]] = None,
            gitignore_template: Optional[pulumi.Input[str]] = None,
            has_discussions: Optional[pulumi.Input[bool]] = None,
            has_downloads: Optional[pulumi.Input[bool]] = None,
            has_issues: Optional[pulumi.Input[bool]] = None,
            has_projects: Optional[pulumi.Input[bool]] = None,
            has_wiki: Optional[pulumi.Input[bool]] = None,
            homepage_url: Optional[pulumi.Input[str]] = None,
            html_url: Optional[pulumi.Input[str]] = None,
            http_clone_url: Optional[pulumi.Input[str]] = None,
            ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
            is_template: Optional[pulumi.Input[bool]] = None,
            license_template: Optional[pulumi.Input[str]] = None,
            merge_commit_message: Optional[pulumi.Input[str]] = None,
            merge_commit_title: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_id: Optional[pulumi.Input[str]] = None,
            pages: Optional[pulumi.Input[pulumi.InputType['RepositoryPagesArgs']]] = None,
            private: Optional[pulumi.Input[bool]] = None,
            repo_id: Optional[pulumi.Input[int]] = None,
            security_and_analysis: Optional[pulumi.Input[pulumi.InputType['RepositorySecurityAndAnalysisArgs']]] = None,
            squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
            squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
            ssh_clone_url: Optional[pulumi.Input[str]] = None,
            svn_url: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['RepositoryTemplateArgs']]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            visibility: Optional[pulumi.Input[str]] = None,
            vulnerability_alerts: Optional[pulumi.Input[bool]] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_auto_merge: Set to `true` to allow auto-merging pull requests on the repository.
        :param pulumi.Input[bool] allow_merge_commit: Set to `false` to disable merge commits on the repository.
        :param pulumi.Input[bool] allow_rebase_merge: Set to `false` to disable rebase merges on the repository.
        :param pulumi.Input[bool] allow_squash_merge: Set to `false` to disable squash merges on the repository.
        :param pulumi.Input[bool] allow_update_branch: Set to `true` to always suggest updating pull request branches.
        :param pulumi.Input[bool] archive_on_destroy: Set to `true` to archive the repository instead of deleting on destroy.
        :param pulumi.Input[bool] archived: Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        :param pulumi.Input[bool] auto_init: Set to `true` to produce an initial commit in the repository.
        :param pulumi.Input[str] default_branch: (Deprecated: Use `BranchDefault` resource instead) The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
               and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
               initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        :param pulumi.Input[bool] delete_branch_on_merge: Automatically delete head branch after a pull request is merged. Defaults to `false`.
        :param pulumi.Input[str] description: A description of the repository.
        :param pulumi.Input[str] full_name: A string of the form "orgname/reponame".
        :param pulumi.Input[str] git_clone_url: URL that can be provided to `git clone` to clone the repository anonymously via the git protocol.
        :param pulumi.Input[str] gitignore_template: Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        :param pulumi.Input[bool] has_discussions: Set to `true` to enable GitHub Discussions on the repository. Defaults to `false`.
        :param pulumi.Input[bool] has_downloads: Set to `true` to enable the (deprecated) downloads features on the repository.
        :param pulumi.Input[bool] has_issues: Set to `true` to enable the GitHub Issues features
               on the repository.
        :param pulumi.Input[bool] has_projects: Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        :param pulumi.Input[bool] has_wiki: Set to `true` to enable the GitHub Wiki features on
               the repository.
        :param pulumi.Input[str] homepage_url: URL of a page describing the project.
        :param pulumi.Input[str] html_url: The absolute URL (including scheme) of the rendered GitHub Pages site e.g. `https://username.github.io`.
        :param pulumi.Input[str] http_clone_url: URL that can be provided to `git clone` to clone the repository via HTTPS.
        :param pulumi.Input[bool] ignore_vulnerability_alerts_during_read: Set to `true` to not call the vulnerability alerts endpoint so the resource can also be used without admin permissions during read.
        :param pulumi.Input[bool] is_template: Set to `true` to tell GitHub that this is a template repository.
        :param pulumi.Input[str] license_template: Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        :param pulumi.Input[str] merge_commit_message: Can be `PR_BODY`, `PR_TITLE`, or `BLANK` for a default merge commit message.
        :param pulumi.Input[str] merge_commit_title: Can be `PR_TITLE` or `MERGE_MESSAGE` for a default merge commit title.
        :param pulumi.Input[str] name: The name of the repository.
        :param pulumi.Input[str] node_id: GraphQL global node id for use with v4 API
        :param pulumi.Input[pulumi.InputType['RepositoryPagesArgs']] pages: The repository's GitHub Pages configuration. See GitHub Pages Configuration below for details.
        :param pulumi.Input[bool] private: Set to `true` to create a private repository.
               Repositories are created as public (e.g. open source) by default.
        :param pulumi.Input[int] repo_id: GitHub ID for the repository
        :param pulumi.Input[pulumi.InputType['RepositorySecurityAndAnalysisArgs']] security_and_analysis: The repository's [security and analysis](https://docs.github.com/en/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository) configuration. See Security and Analysis Configuration below for details.
        :param pulumi.Input[str] squash_merge_commit_message: Can be `PR_BODY`, `COMMIT_MESSAGES`, or `BLANK` for a default squash merge commit message.
        :param pulumi.Input[str] squash_merge_commit_title: Can be `PR_TITLE` or `COMMIT_OR_PR_TITLE` for a default squash merge commit title.
        :param pulumi.Input[str] ssh_clone_url: URL that can be provided to `git clone` to clone the repository via SSH.
        :param pulumi.Input[str] svn_url: URL that can be provided to `svn checkout` to check out the repository via GitHub's Subversion protocol emulation.
        :param pulumi.Input[pulumi.InputType['RepositoryTemplateArgs']] template: Use a template repository to create this resource. See Template Repositories below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The list of topics of the repository.
        :param pulumi.Input[str] visibility: Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be `internal`. The `visibility` parameter overrides the `private` parameter.
        :param pulumi.Input[bool] vulnerability_alerts: Set to `true` to enable security alerts for vulnerable dependencies. Enabling requires alerts to be enabled on the owner level. (Note for importing: GitHub enables the alerts on public repos but disables them on private repos by default.) See [GitHub Documentation](https://help.github.com/en/github/managing-security-vulnerabilities/about-security-alerts-for-vulnerable-dependencies) for details. Note that vulnerability alerts have not been successfully tested on any GitHub Enterprise instance and may be unavailable in those settings.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryState.__new__(_RepositoryState)

        __props__.__dict__["allow_auto_merge"] = allow_auto_merge
        __props__.__dict__["allow_merge_commit"] = allow_merge_commit
        __props__.__dict__["allow_rebase_merge"] = allow_rebase_merge
        __props__.__dict__["allow_squash_merge"] = allow_squash_merge
        __props__.__dict__["allow_update_branch"] = allow_update_branch
        __props__.__dict__["archive_on_destroy"] = archive_on_destroy
        __props__.__dict__["archived"] = archived
        __props__.__dict__["auto_init"] = auto_init
        __props__.__dict__["default_branch"] = default_branch
        __props__.__dict__["delete_branch_on_merge"] = delete_branch_on_merge
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["full_name"] = full_name
        __props__.__dict__["git_clone_url"] = git_clone_url
        __props__.__dict__["gitignore_template"] = gitignore_template
        __props__.__dict__["has_discussions"] = has_discussions
        __props__.__dict__["has_downloads"] = has_downloads
        __props__.__dict__["has_issues"] = has_issues
        __props__.__dict__["has_projects"] = has_projects
        __props__.__dict__["has_wiki"] = has_wiki
        __props__.__dict__["homepage_url"] = homepage_url
        __props__.__dict__["html_url"] = html_url
        __props__.__dict__["http_clone_url"] = http_clone_url
        __props__.__dict__["ignore_vulnerability_alerts_during_read"] = ignore_vulnerability_alerts_during_read
        __props__.__dict__["is_template"] = is_template
        __props__.__dict__["license_template"] = license_template
        __props__.__dict__["merge_commit_message"] = merge_commit_message
        __props__.__dict__["merge_commit_title"] = merge_commit_title
        __props__.__dict__["name"] = name
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["pages"] = pages
        __props__.__dict__["private"] = private
        __props__.__dict__["repo_id"] = repo_id
        __props__.__dict__["security_and_analysis"] = security_and_analysis
        __props__.__dict__["squash_merge_commit_message"] = squash_merge_commit_message
        __props__.__dict__["squash_merge_commit_title"] = squash_merge_commit_title
        __props__.__dict__["ssh_clone_url"] = ssh_clone_url
        __props__.__dict__["svn_url"] = svn_url
        __props__.__dict__["template"] = template
        __props__.__dict__["topics"] = topics
        __props__.__dict__["visibility"] = visibility
        __props__.__dict__["vulnerability_alerts"] = vulnerability_alerts
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowAutoMerge")
    def allow_auto_merge(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to allow auto-merging pull requests on the repository.
        """
        return pulumi.get(self, "allow_auto_merge")

    @property
    @pulumi.getter(name="allowMergeCommit")
    def allow_merge_commit(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `false` to disable merge commits on the repository.
        """
        return pulumi.get(self, "allow_merge_commit")

    @property
    @pulumi.getter(name="allowRebaseMerge")
    def allow_rebase_merge(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `false` to disable rebase merges on the repository.
        """
        return pulumi.get(self, "allow_rebase_merge")

    @property
    @pulumi.getter(name="allowSquashMerge")
    def allow_squash_merge(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `false` to disable squash merges on the repository.
        """
        return pulumi.get(self, "allow_squash_merge")

    @property
    @pulumi.getter(name="allowUpdateBranch")
    def allow_update_branch(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to always suggest updating pull request branches.
        """
        return pulumi.get(self, "allow_update_branch")

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to archive the repository instead of deleting on destroy.
        """
        return pulumi.get(self, "archive_on_destroy")

    @property
    @pulumi.getter
    def archived(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        """
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="autoInit")
    def auto_init(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to produce an initial commit in the repository.
        """
        return pulumi.get(self, "auto_init")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Output[str]:
        """
        (Deprecated: Use `BranchDefault` resource instead) The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
        and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
        initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter(name="deleteBranchOnMerge")
    def delete_branch_on_merge(self) -> pulumi.Output[Optional[bool]]:
        """
        Automatically delete head branch after a pull request is merged. Defaults to `false`.
        """
        return pulumi.get(self, "delete_branch_on_merge")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the repository.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> pulumi.Output[str]:
        """
        A string of the form "orgname/reponame".
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter(name="gitCloneUrl")
    def git_clone_url(self) -> pulumi.Output[str]:
        """
        URL that can be provided to `git clone` to clone the repository anonymously via the git protocol.
        """
        return pulumi.get(self, "git_clone_url")

    @property
    @pulumi.getter(name="gitignoreTemplate")
    def gitignore_template(self) -> pulumi.Output[Optional[str]]:
        """
        Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        """
        return pulumi.get(self, "gitignore_template")

    @property
    @pulumi.getter(name="hasDiscussions")
    def has_discussions(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to enable GitHub Discussions on the repository. Defaults to `false`.
        """
        return pulumi.get(self, "has_discussions")

    @property
    @pulumi.getter(name="hasDownloads")
    def has_downloads(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to enable the (deprecated) downloads features on the repository.
        """
        return pulumi.get(self, "has_downloads")

    @property
    @pulumi.getter(name="hasIssues")
    def has_issues(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to enable the GitHub Issues features
        on the repository.
        """
        return pulumi.get(self, "has_issues")

    @property
    @pulumi.getter(name="hasProjects")
    def has_projects(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        """
        return pulumi.get(self, "has_projects")

    @property
    @pulumi.getter(name="hasWiki")
    def has_wiki(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to enable the GitHub Wiki features on
        the repository.
        """
        return pulumi.get(self, "has_wiki")

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> pulumi.Output[Optional[str]]:
        """
        URL of a page describing the project.
        """
        return pulumi.get(self, "homepage_url")

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> pulumi.Output[str]:
        """
        The absolute URL (including scheme) of the rendered GitHub Pages site e.g. `https://username.github.io`.
        """
        return pulumi.get(self, "html_url")

    @property
    @pulumi.getter(name="httpCloneUrl")
    def http_clone_url(self) -> pulumi.Output[str]:
        """
        URL that can be provided to `git clone` to clone the repository via HTTPS.
        """
        return pulumi.get(self, "http_clone_url")

    @property
    @pulumi.getter(name="ignoreVulnerabilityAlertsDuringRead")
    def ignore_vulnerability_alerts_during_read(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to not call the vulnerability alerts endpoint so the resource can also be used without admin permissions during read.
        """
        return pulumi.get(self, "ignore_vulnerability_alerts_during_read")

    @property
    @pulumi.getter(name="isTemplate")
    def is_template(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to tell GitHub that this is a template repository.
        """
        return pulumi.get(self, "is_template")

    @property
    @pulumi.getter(name="licenseTemplate")
    def license_template(self) -> pulumi.Output[Optional[str]]:
        """
        Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        """
        return pulumi.get(self, "license_template")

    @property
    @pulumi.getter(name="mergeCommitMessage")
    def merge_commit_message(self) -> pulumi.Output[Optional[str]]:
        """
        Can be `PR_BODY`, `PR_TITLE`, or `BLANK` for a default merge commit message.
        """
        return pulumi.get(self, "merge_commit_message")

    @property
    @pulumi.getter(name="mergeCommitTitle")
    def merge_commit_title(self) -> pulumi.Output[Optional[str]]:
        """
        Can be `PR_TITLE` or `MERGE_MESSAGE` for a default merge commit title.
        """
        return pulumi.get(self, "merge_commit_title")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[str]:
        """
        GraphQL global node id for use with v4 API
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def pages(self) -> pulumi.Output[Optional['outputs.RepositoryPages']]:
        """
        The repository's GitHub Pages configuration. See GitHub Pages Configuration below for details.
        """
        return pulumi.get(self, "pages")

    @property
    @pulumi.getter
    def private(self) -> pulumi.Output[bool]:
        """
        Set to `true` to create a private repository.
        Repositories are created as public (e.g. open source) by default.
        """
        return pulumi.get(self, "private")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> pulumi.Output[int]:
        """
        GitHub ID for the repository
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="securityAndAnalysis")
    def security_and_analysis(self) -> pulumi.Output['outputs.RepositorySecurityAndAnalysis']:
        """
        The repository's [security and analysis](https://docs.github.com/en/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository) configuration. See Security and Analysis Configuration below for details.
        """
        return pulumi.get(self, "security_and_analysis")

    @property
    @pulumi.getter(name="squashMergeCommitMessage")
    def squash_merge_commit_message(self) -> pulumi.Output[Optional[str]]:
        """
        Can be `PR_BODY`, `COMMIT_MESSAGES`, or `BLANK` for a default squash merge commit message.
        """
        return pulumi.get(self, "squash_merge_commit_message")

    @property
    @pulumi.getter(name="squashMergeCommitTitle")
    def squash_merge_commit_title(self) -> pulumi.Output[Optional[str]]:
        """
        Can be `PR_TITLE` or `COMMIT_OR_PR_TITLE` for a default squash merge commit title.
        """
        return pulumi.get(self, "squash_merge_commit_title")

    @property
    @pulumi.getter(name="sshCloneUrl")
    def ssh_clone_url(self) -> pulumi.Output[str]:
        """
        URL that can be provided to `git clone` to clone the repository via SSH.
        """
        return pulumi.get(self, "ssh_clone_url")

    @property
    @pulumi.getter(name="svnUrl")
    def svn_url(self) -> pulumi.Output[str]:
        """
        URL that can be provided to `svn checkout` to check out the repository via GitHub's Subversion protocol emulation.
        """
        return pulumi.get(self, "svn_url")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.RepositoryTemplate']]:
        """
        Use a template repository to create this resource. See Template Repositories below for details.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of topics of the repository.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[str]:
        """
        Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be `internal`. The `visibility` parameter overrides the `private` parameter.
        """
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter(name="vulnerabilityAlerts")
    def vulnerability_alerts(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to enable security alerts for vulnerable dependencies. Enabling requires alerts to be enabled on the owner level. (Note for importing: GitHub enables the alerts on public repos but disables them on private repos by default.) See [GitHub Documentation](https://help.github.com/en/github/managing-security-vulnerabilities/about-security-alerts-for-vulnerable-dependencies) for details. Note that vulnerability alerts have not been successfully tested on any GitHub Enterprise instance and may be unavailable in those settings.
        """
        return pulumi.get(self, "vulnerability_alerts")

