# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'ActionsOrganizationPermissionsAllowedActionsConfig',
    'ActionsOrganizationPermissionsEnabledRepositoriesConfig',
    'ActionsRepositoryPermissionsAllowedActionsConfig',
    'BranchProtectionRequiredPullRequestReview',
    'BranchProtectionRequiredStatusCheck',
    'BranchProtectionV3RequiredPullRequestReviews',
    'BranchProtectionV3RequiredStatusChecks',
    'BranchProtectionV3Restrictions',
    'OrganizationWebhookConfiguration',
    'RepositoryEnvironmentDeploymentBranchPolicy',
    'RepositoryEnvironmentReviewer',
    'RepositoryPages',
    'RepositoryPagesSource',
    'RepositorySecurityAndAnalysis',
    'RepositorySecurityAndAnalysisAdvancedSecurity',
    'RepositorySecurityAndAnalysisSecretScanning',
    'RepositorySecurityAndAnalysisSecretScanningPushProtection',
    'RepositoryTemplate',
    'RepositoryWebhookConfiguration',
    'TeamMembersMember',
    'TeamSettingsReviewRequestDelegation',
    'TeamSyncGroupMappingGroup',
    'GetActionsOrganizationSecretsSecretResult',
    'GetActionsSecretsSecretResult',
    'GetCollaboratorsCollaboratorResult',
    'GetDependabotOrganizationSecretsSecretResult',
    'GetDependabotSecretsSecretResult',
    'GetExternalGroupsExternalGroupResult',
    'GetOrganizationIpAllowListIpAllowListResult',
    'GetOrganizationTeamSyncGroupsGroupResult',
    'GetOrganizationTeamsTeamResult',
    'GetOrganizationWebhooksWebhookResult',
    'GetReleaseAssetResult',
    'GetRepositoryBranchesBranchResult',
    'GetRepositoryDeployKeysKeyResult',
    'GetRepositoryPageResult',
    'GetRepositoryPageSourceResult',
    'GetRepositoryPullRequestsResultResult',
    'GetRepositoryTeamsTeamResult',
    'GetRepositoryTemplateResult',
    'GetRepositoryWebhooksWebhookResult',
    'GetTreeEntryResult',
]

@pulumi.output_type
class ActionsOrganizationPermissionsAllowedActionsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "githubOwnedAllowed":
            suggest = "github_owned_allowed"
        elif key == "patternsAlloweds":
            suggest = "patterns_alloweds"
        elif key == "verifiedAllowed":
            suggest = "verified_allowed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionsOrganizationPermissionsAllowedActionsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionsOrganizationPermissionsAllowedActionsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionsOrganizationPermissionsAllowedActionsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 github_owned_allowed: bool,
                 patterns_alloweds: Optional[Sequence[str]] = None,
                 verified_allowed: Optional[bool] = None):
        """
        :param bool github_owned_allowed: Whether GitHub-owned actions are allowed in the organization.
        :param Sequence[str] patterns_alloweds: Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, monalisa/octocat@*, monalisa/octocat@v2, monalisa/*."
        :param bool verified_allowed: Whether actions in GitHub Marketplace from verified creators are allowed. Set to true to allow all GitHub Marketplace actions by verified creators.
        """
        pulumi.set(__self__, "github_owned_allowed", github_owned_allowed)
        if patterns_alloweds is not None:
            pulumi.set(__self__, "patterns_alloweds", patterns_alloweds)
        if verified_allowed is not None:
            pulumi.set(__self__, "verified_allowed", verified_allowed)

    @property
    @pulumi.getter(name="githubOwnedAllowed")
    def github_owned_allowed(self) -> bool:
        """
        Whether GitHub-owned actions are allowed in the organization.
        """
        return pulumi.get(self, "github_owned_allowed")

    @property
    @pulumi.getter(name="patternsAlloweds")
    def patterns_alloweds(self) -> Optional[Sequence[str]]:
        """
        Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, monalisa/octocat@*, monalisa/octocat@v2, monalisa/*."
        """
        return pulumi.get(self, "patterns_alloweds")

    @property
    @pulumi.getter(name="verifiedAllowed")
    def verified_allowed(self) -> Optional[bool]:
        """
        Whether actions in GitHub Marketplace from verified creators are allowed. Set to true to allow all GitHub Marketplace actions by verified creators.
        """
        return pulumi.get(self, "verified_allowed")


@pulumi.output_type
class ActionsOrganizationPermissionsEnabledRepositoriesConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryIds":
            suggest = "repository_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionsOrganizationPermissionsEnabledRepositoriesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionsOrganizationPermissionsEnabledRepositoriesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionsOrganizationPermissionsEnabledRepositoriesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_ids: Sequence[int]):
        """
        :param Sequence[int] repository_ids: List of repository IDs to enable for GitHub Actions.
        """
        pulumi.set(__self__, "repository_ids", repository_ids)

    @property
    @pulumi.getter(name="repositoryIds")
    def repository_ids(self) -> Sequence[int]:
        """
        List of repository IDs to enable for GitHub Actions.
        """
        return pulumi.get(self, "repository_ids")


@pulumi.output_type
class ActionsRepositoryPermissionsAllowedActionsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "githubOwnedAllowed":
            suggest = "github_owned_allowed"
        elif key == "patternsAlloweds":
            suggest = "patterns_alloweds"
        elif key == "verifiedAllowed":
            suggest = "verified_allowed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionsRepositoryPermissionsAllowedActionsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionsRepositoryPermissionsAllowedActionsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionsRepositoryPermissionsAllowedActionsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 github_owned_allowed: bool,
                 patterns_alloweds: Optional[Sequence[str]] = None,
                 verified_allowed: Optional[bool] = None):
        """
        :param bool github_owned_allowed: Whether GitHub-owned actions are allowed in the repository.
        :param Sequence[str] patterns_alloweds: Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, monalisa/octocat@*, monalisa/octocat@v2, monalisa/*."
        :param bool verified_allowed: Whether actions in GitHub Marketplace from verified creators are allowed. Set to true to allow all GitHub Marketplace actions by verified creators.
        """
        pulumi.set(__self__, "github_owned_allowed", github_owned_allowed)
        if patterns_alloweds is not None:
            pulumi.set(__self__, "patterns_alloweds", patterns_alloweds)
        if verified_allowed is not None:
            pulumi.set(__self__, "verified_allowed", verified_allowed)

    @property
    @pulumi.getter(name="githubOwnedAllowed")
    def github_owned_allowed(self) -> bool:
        """
        Whether GitHub-owned actions are allowed in the repository.
        """
        return pulumi.get(self, "github_owned_allowed")

    @property
    @pulumi.getter(name="patternsAlloweds")
    def patterns_alloweds(self) -> Optional[Sequence[str]]:
        """
        Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, monalisa/octocat@*, monalisa/octocat@v2, monalisa/*."
        """
        return pulumi.get(self, "patterns_alloweds")

    @property
    @pulumi.getter(name="verifiedAllowed")
    def verified_allowed(self) -> Optional[bool]:
        """
        Whether actions in GitHub Marketplace from verified creators are allowed. Set to true to allow all GitHub Marketplace actions by verified creators.
        """
        return pulumi.get(self, "verified_allowed")


@pulumi.output_type
class BranchProtectionRequiredPullRequestReview(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dismissStaleReviews":
            suggest = "dismiss_stale_reviews"
        elif key == "dismissalRestrictions":
            suggest = "dismissal_restrictions"
        elif key == "pullRequestBypassers":
            suggest = "pull_request_bypassers"
        elif key == "requireCodeOwnerReviews":
            suggest = "require_code_owner_reviews"
        elif key == "requireLastPushApproval":
            suggest = "require_last_push_approval"
        elif key == "requiredApprovingReviewCount":
            suggest = "required_approving_review_count"
        elif key == "restrictDismissals":
            suggest = "restrict_dismissals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchProtectionRequiredPullRequestReview. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchProtectionRequiredPullRequestReview.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchProtectionRequiredPullRequestReview.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dismiss_stale_reviews: Optional[bool] = None,
                 dismissal_restrictions: Optional[Sequence[str]] = None,
                 pull_request_bypassers: Optional[Sequence[str]] = None,
                 require_code_owner_reviews: Optional[bool] = None,
                 require_last_push_approval: Optional[bool] = None,
                 required_approving_review_count: Optional[int] = None,
                 restrict_dismissals: Optional[bool] = None):
        """
        :param bool dismiss_stale_reviews: Dismiss approved reviews automatically when a new commit is pushed. Defaults to `false`.
        :param Sequence[str] dismissal_restrictions: The list of actor Names/IDs with dismissal access. If not empty, `restrict_dismissals` is ignored. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams.
        :param Sequence[str] pull_request_bypassers: The list of actor Names/IDs that are allowed to bypass pull request requirements. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams.
        :param bool require_code_owner_reviews: Require an approved review in pull requests including files with a designated code owner. Defaults to `false`.
        :param bool require_last_push_approval: Require that The most recent push must be approved by someone other than the last pusher.  Defaults to `false`
        :param int required_approving_review_count: Require x number of approvals to satisfy branch protection requirements. If this is specified it must be a number between 0-6. This requirement matches GitHub's API, see the upstream [documentation](https://developer.github.com/v3/repos/branches/#parameters-1) for more information.
               (https://developer.github.com/v3/repos/branches/#parameters-1) for more information.
        :param bool restrict_dismissals: Restrict pull request review dismissals.
        """
        if dismiss_stale_reviews is not None:
            pulumi.set(__self__, "dismiss_stale_reviews", dismiss_stale_reviews)
        if dismissal_restrictions is not None:
            pulumi.set(__self__, "dismissal_restrictions", dismissal_restrictions)
        if pull_request_bypassers is not None:
            pulumi.set(__self__, "pull_request_bypassers", pull_request_bypassers)
        if require_code_owner_reviews is not None:
            pulumi.set(__self__, "require_code_owner_reviews", require_code_owner_reviews)
        if require_last_push_approval is not None:
            pulumi.set(__self__, "require_last_push_approval", require_last_push_approval)
        if required_approving_review_count is not None:
            pulumi.set(__self__, "required_approving_review_count", required_approving_review_count)
        if restrict_dismissals is not None:
            pulumi.set(__self__, "restrict_dismissals", restrict_dismissals)

    @property
    @pulumi.getter(name="dismissStaleReviews")
    def dismiss_stale_reviews(self) -> Optional[bool]:
        """
        Dismiss approved reviews automatically when a new commit is pushed. Defaults to `false`.
        """
        return pulumi.get(self, "dismiss_stale_reviews")

    @property
    @pulumi.getter(name="dismissalRestrictions")
    def dismissal_restrictions(self) -> Optional[Sequence[str]]:
        """
        The list of actor Names/IDs with dismissal access. If not empty, `restrict_dismissals` is ignored. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams.
        """
        return pulumi.get(self, "dismissal_restrictions")

    @property
    @pulumi.getter(name="pullRequestBypassers")
    def pull_request_bypassers(self) -> Optional[Sequence[str]]:
        """
        The list of actor Names/IDs that are allowed to bypass pull request requirements. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams.
        """
        return pulumi.get(self, "pull_request_bypassers")

    @property
    @pulumi.getter(name="requireCodeOwnerReviews")
    def require_code_owner_reviews(self) -> Optional[bool]:
        """
        Require an approved review in pull requests including files with a designated code owner. Defaults to `false`.
        """
        return pulumi.get(self, "require_code_owner_reviews")

    @property
    @pulumi.getter(name="requireLastPushApproval")
    def require_last_push_approval(self) -> Optional[bool]:
        """
        Require that The most recent push must be approved by someone other than the last pusher.  Defaults to `false`
        """
        return pulumi.get(self, "require_last_push_approval")

    @property
    @pulumi.getter(name="requiredApprovingReviewCount")
    def required_approving_review_count(self) -> Optional[int]:
        """
        Require x number of approvals to satisfy branch protection requirements. If this is specified it must be a number between 0-6. This requirement matches GitHub's API, see the upstream [documentation](https://developer.github.com/v3/repos/branches/#parameters-1) for more information.
        (https://developer.github.com/v3/repos/branches/#parameters-1) for more information.
        """
        return pulumi.get(self, "required_approving_review_count")

    @property
    @pulumi.getter(name="restrictDismissals")
    def restrict_dismissals(self) -> Optional[bool]:
        """
        Restrict pull request review dismissals.
        """
        return pulumi.get(self, "restrict_dismissals")


@pulumi.output_type
class BranchProtectionRequiredStatusCheck(dict):
    def __init__(__self__, *,
                 contexts: Optional[Sequence[str]] = None,
                 strict: Optional[bool] = None):
        """
        :param Sequence[str] contexts: The list of status checks to require in order to merge into this branch. No status checks are required by default.
        :param bool strict: Require branches to be up to date before merging. Defaults to `false`.
        """
        if contexts is not None:
            pulumi.set(__self__, "contexts", contexts)
        if strict is not None:
            pulumi.set(__self__, "strict", strict)

    @property
    @pulumi.getter
    def contexts(self) -> Optional[Sequence[str]]:
        """
        The list of status checks to require in order to merge into this branch. No status checks are required by default.
        """
        return pulumi.get(self, "contexts")

    @property
    @pulumi.getter
    def strict(self) -> Optional[bool]:
        """
        Require branches to be up to date before merging. Defaults to `false`.
        """
        return pulumi.get(self, "strict")


@pulumi.output_type
class BranchProtectionV3RequiredPullRequestReviews(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dismissStaleReviews":
            suggest = "dismiss_stale_reviews"
        elif key == "dismissalTeams":
            suggest = "dismissal_teams"
        elif key == "dismissalUsers":
            suggest = "dismissal_users"
        elif key == "includeAdmins":
            suggest = "include_admins"
        elif key == "requireCodeOwnerReviews":
            suggest = "require_code_owner_reviews"
        elif key == "requiredApprovingReviewCount":
            suggest = "required_approving_review_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchProtectionV3RequiredPullRequestReviews. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchProtectionV3RequiredPullRequestReviews.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchProtectionV3RequiredPullRequestReviews.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dismiss_stale_reviews: Optional[bool] = None,
                 dismissal_teams: Optional[Sequence[str]] = None,
                 dismissal_users: Optional[Sequence[str]] = None,
                 include_admins: Optional[bool] = None,
                 require_code_owner_reviews: Optional[bool] = None,
                 required_approving_review_count: Optional[int] = None):
        """
        :param bool dismiss_stale_reviews: Dismiss approved reviews automatically when a new commit is pushed. Defaults to `false`.
        :param Sequence[str] dismissal_teams: The list of team slugs with dismissal access.
               Always use `slug` of the team, **not** its name. Each team already **has** to have access to the repository.
        :param Sequence[str] dismissal_users: The list of user logins with dismissal access
        :param bool require_code_owner_reviews: Require an approved review in pull requests including files with a designated code owner. Defaults to `false`.
        :param int required_approving_review_count: Require x number of approvals to satisfy branch protection requirements. If this is specified it must be a number between 0-6. This requirement matches GitHub's API, see the upstream [documentation](https://developer.github.com/v3/repos/branches/#parameters-1) for more information.
        """
        if dismiss_stale_reviews is not None:
            pulumi.set(__self__, "dismiss_stale_reviews", dismiss_stale_reviews)
        if dismissal_teams is not None:
            pulumi.set(__self__, "dismissal_teams", dismissal_teams)
        if dismissal_users is not None:
            pulumi.set(__self__, "dismissal_users", dismissal_users)
        if include_admins is not None:
            pulumi.set(__self__, "include_admins", include_admins)
        if require_code_owner_reviews is not None:
            pulumi.set(__self__, "require_code_owner_reviews", require_code_owner_reviews)
        if required_approving_review_count is not None:
            pulumi.set(__self__, "required_approving_review_count", required_approving_review_count)

    @property
    @pulumi.getter(name="dismissStaleReviews")
    def dismiss_stale_reviews(self) -> Optional[bool]:
        """
        Dismiss approved reviews automatically when a new commit is pushed. Defaults to `false`.
        """
        return pulumi.get(self, "dismiss_stale_reviews")

    @property
    @pulumi.getter(name="dismissalTeams")
    def dismissal_teams(self) -> Optional[Sequence[str]]:
        """
        The list of team slugs with dismissal access.
        Always use `slug` of the team, **not** its name. Each team already **has** to have access to the repository.
        """
        return pulumi.get(self, "dismissal_teams")

    @property
    @pulumi.getter(name="dismissalUsers")
    def dismissal_users(self) -> Optional[Sequence[str]]:
        """
        The list of user logins with dismissal access
        """
        return pulumi.get(self, "dismissal_users")

    @property
    @pulumi.getter(name="includeAdmins")
    def include_admins(self) -> Optional[bool]:
        return pulumi.get(self, "include_admins")

    @property
    @pulumi.getter(name="requireCodeOwnerReviews")
    def require_code_owner_reviews(self) -> Optional[bool]:
        """
        Require an approved review in pull requests including files with a designated code owner. Defaults to `false`.
        """
        return pulumi.get(self, "require_code_owner_reviews")

    @property
    @pulumi.getter(name="requiredApprovingReviewCount")
    def required_approving_review_count(self) -> Optional[int]:
        """
        Require x number of approvals to satisfy branch protection requirements. If this is specified it must be a number between 0-6. This requirement matches GitHub's API, see the upstream [documentation](https://developer.github.com/v3/repos/branches/#parameters-1) for more information.
        """
        return pulumi.get(self, "required_approving_review_count")


@pulumi.output_type
class BranchProtectionV3RequiredStatusChecks(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeAdmins":
            suggest = "include_admins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchProtectionV3RequiredStatusChecks. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchProtectionV3RequiredStatusChecks.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchProtectionV3RequiredStatusChecks.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 checks: Optional[Sequence[str]] = None,
                 contexts: Optional[Sequence[str]] = None,
                 include_admins: Optional[bool] = None,
                 strict: Optional[bool] = None):
        """
        :param Sequence[str] checks: The list of status checks to require in order to merge into this branch. No status checks are required by default. Checks should be strings containing the context and app_id like so "context:app_id".
        :param Sequence[str] contexts: [**DEPRECATED**] (Optional) The list of status checks to require in order to merge into this branch. No status checks are required by default.
        :param bool strict: Require branches to be up to date before merging. Defaults to `false`.
        """
        if checks is not None:
            pulumi.set(__self__, "checks", checks)
        if contexts is not None:
            pulumi.set(__self__, "contexts", contexts)
        if include_admins is not None:
            pulumi.set(__self__, "include_admins", include_admins)
        if strict is not None:
            pulumi.set(__self__, "strict", strict)

    @property
    @pulumi.getter
    def checks(self) -> Optional[Sequence[str]]:
        """
        The list of status checks to require in order to merge into this branch. No status checks are required by default. Checks should be strings containing the context and app_id like so "context:app_id".
        """
        return pulumi.get(self, "checks")

    @property
    @pulumi.getter
    def contexts(self) -> Optional[Sequence[str]]:
        """
        [**DEPRECATED**] (Optional) The list of status checks to require in order to merge into this branch. No status checks are required by default.
        """
        return pulumi.get(self, "contexts")

    @property
    @pulumi.getter(name="includeAdmins")
    def include_admins(self) -> Optional[bool]:
        return pulumi.get(self, "include_admins")

    @property
    @pulumi.getter
    def strict(self) -> Optional[bool]:
        """
        Require branches to be up to date before merging. Defaults to `false`.
        """
        return pulumi.get(self, "strict")


@pulumi.output_type
class BranchProtectionV3Restrictions(dict):
    def __init__(__self__, *,
                 apps: Optional[Sequence[str]] = None,
                 teams: Optional[Sequence[str]] = None,
                 users: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] apps: The list of app slugs with push access.
        :param Sequence[str] teams: The list of team slugs with push access.
               Always use `slug` of the team, **not** its name. Each team already **has** to have access to the repository.
        :param Sequence[str] users: The list of user logins with push access.
        """
        if apps is not None:
            pulumi.set(__self__, "apps", apps)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def apps(self) -> Optional[Sequence[str]]:
        """
        The list of app slugs with push access.
        """
        return pulumi.get(self, "apps")

    @property
    @pulumi.getter
    def teams(self) -> Optional[Sequence[str]]:
        """
        The list of team slugs with push access.
        Always use `slug` of the team, **not** its name. Each team already **has** to have access to the repository.
        """
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter
    def users(self) -> Optional[Sequence[str]]:
        """
        The list of user logins with push access.
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class OrganizationWebhookConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "insecureSsl":
            suggest = "insecure_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationWebhookConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationWebhookConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationWebhookConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: str,
                 content_type: Optional[str] = None,
                 insecure_ssl: Optional[bool] = None,
                 secret: Optional[str] = None):
        """
        :param str url: URL of the webhook
        """
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if insecure_ssl is not None:
            pulumi.set(__self__, "insecure_ssl", insecure_ssl)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL of the webhook
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="insecureSsl")
    def insecure_ssl(self) -> Optional[bool]:
        return pulumi.get(self, "insecure_ssl")

    @property
    @pulumi.getter
    def secret(self) -> Optional[str]:
        return pulumi.get(self, "secret")


@pulumi.output_type
class RepositoryEnvironmentDeploymentBranchPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customBranchPolicies":
            suggest = "custom_branch_policies"
        elif key == "protectedBranches":
            suggest = "protected_branches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryEnvironmentDeploymentBranchPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryEnvironmentDeploymentBranchPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryEnvironmentDeploymentBranchPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_branch_policies: bool,
                 protected_branches: bool):
        """
        :param bool custom_branch_policies: Whether only branches that match the specified name patterns can deploy to this environment.
        :param bool protected_branches: Whether only branches with branch protection rules can deploy to this environment.
        """
        pulumi.set(__self__, "custom_branch_policies", custom_branch_policies)
        pulumi.set(__self__, "protected_branches", protected_branches)

    @property
    @pulumi.getter(name="customBranchPolicies")
    def custom_branch_policies(self) -> bool:
        """
        Whether only branches that match the specified name patterns can deploy to this environment.
        """
        return pulumi.get(self, "custom_branch_policies")

    @property
    @pulumi.getter(name="protectedBranches")
    def protected_branches(self) -> bool:
        """
        Whether only branches with branch protection rules can deploy to this environment.
        """
        return pulumi.get(self, "protected_branches")


@pulumi.output_type
class RepositoryEnvironmentReviewer(dict):
    def __init__(__self__, *,
                 teams: Optional[Sequence[int]] = None,
                 users: Optional[Sequence[int]] = None):
        """
        :param Sequence[int] teams: Up to 6 IDs for teams who may review jobs that reference the environment. Reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
        :param Sequence[int] users: Up to 6 IDs for users who may review jobs that reference the environment. Reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
        """
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def teams(self) -> Optional[Sequence[int]]:
        """
        Up to 6 IDs for teams who may review jobs that reference the environment. Reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
        """
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter
    def users(self) -> Optional[Sequence[int]]:
        """
        Up to 6 IDs for users who may review jobs that reference the environment. Reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class RepositoryPages(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlUrl":
            suggest = "html_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryPages. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryPages.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryPages.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: 'outputs.RepositoryPagesSource',
                 cname: Optional[str] = None,
                 custom404: Optional[bool] = None,
                 html_url: Optional[str] = None,
                 status: Optional[str] = None,
                 url: Optional[str] = None):
        """
        :param 'RepositoryPagesSourceArgs' source: The source branch and directory for the rendered Pages site. See GitHub Pages Source below for details.
        :param str cname: The custom domain for the repository. This can only be set after the repository has been created.
        :param bool custom404: Whether the rendered GitHub Pages site has a custom 404 page.
        :param str html_url: The absolute URL (including scheme) of the rendered GitHub Pages site e.g. `https://username.github.io`.
        :param str status: Set to `enabled` to enable advanced security features on the repository. Can be `enabled` or `disabled`.
        """
        pulumi.set(__self__, "source", source)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if custom404 is not None:
            pulumi.set(__self__, "custom404", custom404)
        if html_url is not None:
            pulumi.set(__self__, "html_url", html_url)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def source(self) -> 'outputs.RepositoryPagesSource':
        """
        The source branch and directory for the rendered Pages site. See GitHub Pages Source below for details.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def cname(self) -> Optional[str]:
        """
        The custom domain for the repository. This can only be set after the repository has been created.
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter
    def custom404(self) -> Optional[bool]:
        """
        Whether the rendered GitHub Pages site has a custom 404 page.
        """
        return pulumi.get(self, "custom404")

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> Optional[str]:
        """
        The absolute URL (including scheme) of the rendered GitHub Pages site e.g. `https://username.github.io`.
        """
        return pulumi.get(self, "html_url")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Set to `enabled` to enable advanced security features on the repository. Can be `enabled` or `disabled`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        return pulumi.get(self, "url")


@pulumi.output_type
class RepositoryPagesSource(dict):
    def __init__(__self__, *,
                 branch: str,
                 path: Optional[str] = None):
        """
        :param str branch: The repository branch used to publish the site's source files. (i.e. `main` or `gh-pages`.
        :param str path: The repository directory from which the site publishes (Default: `/`).
        """
        pulumi.set(__self__, "branch", branch)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        The repository branch used to publish the site's source files. (i.e. `main` or `gh-pages`.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The repository directory from which the site publishes (Default: `/`).
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class RepositorySecurityAndAnalysis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedSecurity":
            suggest = "advanced_security"
        elif key == "secretScanning":
            suggest = "secret_scanning"
        elif key == "secretScanningPushProtection":
            suggest = "secret_scanning_push_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositorySecurityAndAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositorySecurityAndAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositorySecurityAndAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_security: Optional['outputs.RepositorySecurityAndAnalysisAdvancedSecurity'] = None,
                 secret_scanning: Optional['outputs.RepositorySecurityAndAnalysisSecretScanning'] = None,
                 secret_scanning_push_protection: Optional['outputs.RepositorySecurityAndAnalysisSecretScanningPushProtection'] = None):
        """
        :param 'RepositorySecurityAndAnalysisAdvancedSecurityArgs' advanced_security: The advanced security configuration for the repository. See Advanced Security Configuration below for details. If a repository's visibility is `public`, advanced security is always enabled and cannot be changed, so this setting cannot be supplied.
        :param 'RepositorySecurityAndAnalysisSecretScanningArgs' secret_scanning: The secret scanning configuration for the repository. See Secret Scanning Configuration below for details.
        :param 'RepositorySecurityAndAnalysisSecretScanningPushProtectionArgs' secret_scanning_push_protection: The secret scanning push protection configuration for the repository. See Secret Scanning Push Protection Configuration below for details.
        """
        if advanced_security is not None:
            pulumi.set(__self__, "advanced_security", advanced_security)
        if secret_scanning is not None:
            pulumi.set(__self__, "secret_scanning", secret_scanning)
        if secret_scanning_push_protection is not None:
            pulumi.set(__self__, "secret_scanning_push_protection", secret_scanning_push_protection)

    @property
    @pulumi.getter(name="advancedSecurity")
    def advanced_security(self) -> Optional['outputs.RepositorySecurityAndAnalysisAdvancedSecurity']:
        """
        The advanced security configuration for the repository. See Advanced Security Configuration below for details. If a repository's visibility is `public`, advanced security is always enabled and cannot be changed, so this setting cannot be supplied.
        """
        return pulumi.get(self, "advanced_security")

    @property
    @pulumi.getter(name="secretScanning")
    def secret_scanning(self) -> Optional['outputs.RepositorySecurityAndAnalysisSecretScanning']:
        """
        The secret scanning configuration for the repository. See Secret Scanning Configuration below for details.
        """
        return pulumi.get(self, "secret_scanning")

    @property
    @pulumi.getter(name="secretScanningPushProtection")
    def secret_scanning_push_protection(self) -> Optional['outputs.RepositorySecurityAndAnalysisSecretScanningPushProtection']:
        """
        The secret scanning push protection configuration for the repository. See Secret Scanning Push Protection Configuration below for details.
        """
        return pulumi.get(self, "secret_scanning_push_protection")


@pulumi.output_type
class RepositorySecurityAndAnalysisAdvancedSecurity(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: Set to `enabled` to enable advanced security features on the repository. Can be `enabled` or `disabled`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Set to `enabled` to enable advanced security features on the repository. Can be `enabled` or `disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RepositorySecurityAndAnalysisSecretScanning(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: Set to `enabled` to enable advanced security features on the repository. Can be `enabled` or `disabled`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Set to `enabled` to enable advanced security features on the repository. Can be `enabled` or `disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RepositorySecurityAndAnalysisSecretScanningPushProtection(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: Set to `enabled` to enable advanced security features on the repository. Can be `enabled` or `disabled`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Set to `enabled` to enable advanced security features on the repository. Can be `enabled` or `disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RepositoryTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeAllBranches":
            suggest = "include_all_branches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner: str,
                 repository: str,
                 include_all_branches: Optional[bool] = None):
        """
        :param str owner: The GitHub organization or user the template repository is owned by.
        :param str repository: The name of the template repository.
        :param bool include_all_branches: Whether the new repository should include all the branches from the template repository (defaults to false, which includes only the default branch from the template).
        """
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "repository", repository)
        if include_all_branches is not None:
            pulumi.set(__self__, "include_all_branches", include_all_branches)

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The GitHub organization or user the template repository is owned by.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The name of the template repository.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="includeAllBranches")
    def include_all_branches(self) -> Optional[bool]:
        """
        Whether the new repository should include all the branches from the template repository (defaults to false, which includes only the default branch from the template).
        """
        return pulumi.get(self, "include_all_branches")


@pulumi.output_type
class RepositoryWebhookConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "insecureSsl":
            suggest = "insecure_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryWebhookConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryWebhookConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryWebhookConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: str,
                 content_type: Optional[str] = None,
                 insecure_ssl: Optional[bool] = None,
                 secret: Optional[str] = None):
        """
        :param str url: The URL of the webhook.
        :param str content_type: The content type for the payload. Valid values are either `form` or `json`.
        :param bool insecure_ssl: Insecure SSL boolean toggle. Defaults to `false`.
        :param str secret: The shared secret for the webhook. [See API documentation](https://developer.github.com/v3/repos/hooks/#create-a-hook).
        """
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if insecure_ssl is not None:
            pulumi.set(__self__, "insecure_ssl", insecure_ssl)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL of the webhook.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The content type for the payload. Valid values are either `form` or `json`.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="insecureSsl")
    def insecure_ssl(self) -> Optional[bool]:
        """
        Insecure SSL boolean toggle. Defaults to `false`.
        """
        return pulumi.get(self, "insecure_ssl")

    @property
    @pulumi.getter
    def secret(self) -> Optional[str]:
        """
        The shared secret for the webhook. [See API documentation](https://developer.github.com/v3/repos/hooks/#create-a-hook).
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class TeamMembersMember(dict):
    def __init__(__self__, *,
                 username: str,
                 role: Optional[str] = None):
        """
        :param str username: The user to add to the team.
        :param str role: The role of the user within the team.
               Must be one of `member` or `maintainer`. Defaults to `member`.
        """
        pulumi.set(__self__, "username", username)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user to add to the team.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role of the user within the team.
        Must be one of `member` or `maintainer`. Defaults to `member`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class TeamSettingsReviewRequestDelegation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memberCount":
            suggest = "member_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamSettingsReviewRequestDelegation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamSettingsReviewRequestDelegation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamSettingsReviewRequestDelegation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[str] = None,
                 member_count: Optional[int] = None,
                 notify: Optional[bool] = None):
        """
        :param str algorithm: The algorithm to use when assigning pull requests to team members. Supported values are `ROUND_ROBIN` and `LOAD_BALANCE`. Default value is `ROUND_ROBIN`
        :param int member_count: The number of team members to assign to a pull request
        :param bool notify: whether to notify the entire team when at least one member is also assigned to the pull request
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if member_count is not None:
            pulumi.set(__self__, "member_count", member_count)
        if notify is not None:
            pulumi.set(__self__, "notify", notify)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[str]:
        """
        The algorithm to use when assigning pull requests to team members. Supported values are `ROUND_ROBIN` and `LOAD_BALANCE`. Default value is `ROUND_ROBIN`
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="memberCount")
    def member_count(self) -> Optional[int]:
        """
        The number of team members to assign to a pull request
        """
        return pulumi.get(self, "member_count")

    @property
    @pulumi.getter
    def notify(self) -> Optional[bool]:
        """
        whether to notify the entire team when at least one member is also assigned to the pull request
        """
        return pulumi.get(self, "notify")


@pulumi.output_type
class TeamSyncGroupMappingGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupDescription":
            suggest = "group_description"
        elif key == "groupId":
            suggest = "group_id"
        elif key == "groupName":
            suggest = "group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamSyncGroupMappingGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamSyncGroupMappingGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamSyncGroupMappingGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_description: str,
                 group_id: str,
                 group_name: str):
        """
        :param str group_description: The description of the IdP group.
        :param str group_id: The ID of the IdP group.
        :param str group_name: The name of the IdP group.
        """
        pulumi.set(__self__, "group_description", group_description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> str:
        """
        The description of the IdP group.
        """
        return pulumi.get(self, "group_description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The ID of the IdP group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        The name of the IdP group.
        """
        return pulumi.get(self, "group_name")


@pulumi.output_type
class GetActionsOrganizationSecretsSecretResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 name: str,
                 updated_at: str,
                 visibility: str):
        """
        :param str created_at: Timestamp of the secret creation
        :param str name: Secret name
        :param str updated_at: Timestamp of the secret last update
        :param str visibility: Secret visibility
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Timestamp of the secret creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Secret name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Timestamp of the secret last update
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def visibility(self) -> str:
        """
        Secret visibility
        """
        return pulumi.get(self, "visibility")


@pulumi.output_type
class GetActionsSecretsSecretResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 name: str,
                 updated_at: str):
        """
        :param str created_at: Timestamp of the secret creation
        :param str name: The name of the repository.
        :param str updated_at: Timestamp of the secret last update
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Timestamp of the secret creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Timestamp of the secret last update
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetCollaboratorsCollaboratorResult(dict):
    def __init__(__self__, *,
                 events_url: str,
                 followers_url: str,
                 following_url: str,
                 gists_url: str,
                 html_url: str,
                 id: int,
                 login: str,
                 organizations_url: str,
                 permission: str,
                 received_events_url: str,
                 repos_url: str,
                 site_admin: bool,
                 starred_url: str,
                 subscriptions_url: str,
                 type: str,
                 url: str):
        """
        :param str events_url: The GitHub API URL for the collaborator's events.
        :param str followers_url: The GitHub API URL for the collaborator's followers.
        :param str following_url: The GitHub API URL for those following the collaborator.
        :param str gists_url: The GitHub API URL for the collaborator's gists.
        :param str html_url: The GitHub HTML URL for the collaborator.
        :param int id: The ID of the collaborator.
        :param str login: The collaborator's login.
        :param str organizations_url: The GitHub API URL for the collaborator's organizations.
        :param str permission: The permission of the collaborator.
        :param str received_events_url: The GitHub API URL for the collaborator's received events.
        :param str repos_url: The GitHub API URL for the collaborator's repositories.
        :param bool site_admin: Whether the user is a GitHub admin.
        :param str starred_url: The GitHub API URL for the collaborator's starred repositories.
        :param str subscriptions_url: The GitHub API URL for the collaborator's subscribed repositories.
        :param str type: The type of the collaborator (ex. `user`).
        :param str url: The GitHub API URL for the collaborator.
        """
        pulumi.set(__self__, "events_url", events_url)
        pulumi.set(__self__, "followers_url", followers_url)
        pulumi.set(__self__, "following_url", following_url)
        pulumi.set(__self__, "gists_url", gists_url)
        pulumi.set(__self__, "html_url", html_url)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "organizations_url", organizations_url)
        pulumi.set(__self__, "permission", permission)
        pulumi.set(__self__, "received_events_url", received_events_url)
        pulumi.set(__self__, "repos_url", repos_url)
        pulumi.set(__self__, "site_admin", site_admin)
        pulumi.set(__self__, "starred_url", starred_url)
        pulumi.set(__self__, "subscriptions_url", subscriptions_url)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="eventsUrl")
    def events_url(self) -> str:
        """
        The GitHub API URL for the collaborator's events.
        """
        return pulumi.get(self, "events_url")

    @property
    @pulumi.getter(name="followersUrl")
    def followers_url(self) -> str:
        """
        The GitHub API URL for the collaborator's followers.
        """
        return pulumi.get(self, "followers_url")

    @property
    @pulumi.getter(name="followingUrl")
    def following_url(self) -> str:
        """
        The GitHub API URL for those following the collaborator.
        """
        return pulumi.get(self, "following_url")

    @property
    @pulumi.getter(name="gistsUrl")
    def gists_url(self) -> str:
        """
        The GitHub API URL for the collaborator's gists.
        """
        return pulumi.get(self, "gists_url")

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> str:
        """
        The GitHub HTML URL for the collaborator.
        """
        return pulumi.get(self, "html_url")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the collaborator.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def login(self) -> str:
        """
        The collaborator's login.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter(name="organizationsUrl")
    def organizations_url(self) -> str:
        """
        The GitHub API URL for the collaborator's organizations.
        """
        return pulumi.get(self, "organizations_url")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The permission of the collaborator.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="receivedEventsUrl")
    def received_events_url(self) -> str:
        """
        The GitHub API URL for the collaborator's received events.
        """
        return pulumi.get(self, "received_events_url")

    @property
    @pulumi.getter(name="reposUrl")
    def repos_url(self) -> str:
        """
        The GitHub API URL for the collaborator's repositories.
        """
        return pulumi.get(self, "repos_url")

    @property
    @pulumi.getter(name="siteAdmin")
    def site_admin(self) -> bool:
        """
        Whether the user is a GitHub admin.
        """
        return pulumi.get(self, "site_admin")

    @property
    @pulumi.getter(name="starredUrl")
    def starred_url(self) -> str:
        """
        The GitHub API URL for the collaborator's starred repositories.
        """
        return pulumi.get(self, "starred_url")

    @property
    @pulumi.getter(name="subscriptionsUrl")
    def subscriptions_url(self) -> str:
        """
        The GitHub API URL for the collaborator's subscribed repositories.
        """
        return pulumi.get(self, "subscriptions_url")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the collaborator (ex. `user`).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The GitHub API URL for the collaborator.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetDependabotOrganizationSecretsSecretResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 name: str,
                 updated_at: str,
                 visibility: str):
        """
        :param str created_at: Timestamp of the secret creation
        :param str name: Secret name
        :param str updated_at: Timestamp of the secret last update
        :param str visibility: Secret visibility
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Timestamp of the secret creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Secret name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Timestamp of the secret last update
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def visibility(self) -> str:
        """
        Secret visibility
        """
        return pulumi.get(self, "visibility")


@pulumi.output_type
class GetDependabotSecretsSecretResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 name: str,
                 updated_at: str):
        """
        :param str created_at: Timestamp of the secret creation
        :param str name: The name of the repository.
        :param str updated_at: Timestamp of the secret last update
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Timestamp of the secret creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Timestamp of the secret last update
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetExternalGroupsExternalGroupResult(dict):
    def __init__(__self__, *,
                 group_id: int,
                 group_name: str,
                 updated_at: str):
        """
        :param int group_id: the ID of the group.
        :param str group_name: the name of the group.
        :param str updated_at: the date the group was last updated.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        """
        the ID of the group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        the name of the group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        the date the group was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetOrganizationIpAllowListIpAllowListResult(dict):
    def __init__(__self__, *,
                 allow_list_value: str,
                 created_at: str,
                 id: str,
                 is_active: bool,
                 name: str,
                 updated_at: str):
        """
        :param str allow_list_value: A single IP address or range of IP addresses in CIDR notation.
        :param str created_at: Identifies the date and time when the object was created.
        :param str id: The ID of the IP allow list entry.
        :param bool is_active: Whether the entry is currently active.
        :param str name: The name of the IP allow list entry.
        :param str updated_at: Identifies the date and time when the object was last updated.
        """
        pulumi.set(__self__, "allow_list_value", allow_list_value)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_active", is_active)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="allowListValue")
    def allow_list_value(self) -> str:
        """
        A single IP address or range of IP addresses in CIDR notation.
        """
        return pulumi.get(self, "allow_list_value")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Identifies the date and time when the object was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the IP allow list entry.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> bool:
        """
        Whether the entry is currently active.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the IP allow list entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Identifies the date and time when the object was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetOrganizationTeamSyncGroupsGroupResult(dict):
    def __init__(__self__, *,
                 group_description: str,
                 group_id: str,
                 group_name: str):
        """
        :param str group_description: The description of the IdP group.
        :param str group_id: The ID of the IdP group.
        :param str group_name: The name of the IdP group.
        """
        pulumi.set(__self__, "group_description", group_description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> str:
        """
        The description of the IdP group.
        """
        return pulumi.get(self, "group_description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The ID of the IdP group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        The name of the IdP group.
        """
        return pulumi.get(self, "group_name")


@pulumi.output_type
class GetOrganizationTeamsTeamResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: int,
                 members: Sequence[str],
                 name: str,
                 node_id: str,
                 parent: Mapping[str, str],
                 privacy: str,
                 repositories: Sequence[str],
                 slug: str):
        """
        :param str description: the team's description.
        :param int id: the ID of the team.
        :param Sequence[str] members: List of team members. Not returned if `summary_only = true`
        :param str name: the team's full name.
        :param str node_id: the Node ID of the team.
        :param Mapping[str, str] parent: the parent team.
        :param str privacy: the team's privacy type.
        :param Sequence[str] repositories: List of team repositories. Not returned if `summary_only = true`
        :param str slug: the slug of the team.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "privacy", privacy)
        pulumi.set(__self__, "repositories", repositories)
        pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        the team's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        the ID of the team.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        List of team members. Not returned if `summary_only = true`
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        the team's full name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        the Node ID of the team.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def parent(self) -> Mapping[str, str]:
        """
        the parent team.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def privacy(self) -> str:
        """
        the team's privacy type.
        """
        return pulumi.get(self, "privacy")

    @property
    @pulumi.getter
    def repositories(self) -> Sequence[str]:
        """
        List of team repositories. Not returned if `summary_only = true`
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        the slug of the team.
        """
        return pulumi.get(self, "slug")


@pulumi.output_type
class GetOrganizationWebhooksWebhookResult(dict):
    def __init__(__self__, *,
                 active: bool,
                 id: int,
                 name: str,
                 type: str,
                 url: str):
        """
        :param bool active: `true` if the webhook is active.
        :param int id: the ID of the webhook.
        :param str name: the name of the webhook.
        :param str type: the type of the webhook.
        :param str url: the url of the webhook.
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def active(self) -> bool:
        """
        `true` if the webhook is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        the ID of the webhook.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        the name of the webhook.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        the type of the webhook.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        the url of the webhook.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetReleaseAssetResult(dict):
    def __init__(__self__, *,
                 browser_download_url: str,
                 content_type: str,
                 created_at: str,
                 id: int,
                 label: str,
                 name: str,
                 node_id: str,
                 size: int,
                 updated_at: str,
                 url: str):
        """
        :param str browser_download_url: Browser download URL
        :param str content_type: MIME type of the asset
        :param str created_at: Date the asset was created
        :param int id: ID of the asset
        :param str label: Label for the asset
        :param str name: The file name of the asset
        :param str node_id: Node ID of the asset
        :param int size: Size in byte
        :param str updated_at: Date the asset was last updated
        :param str url: URL of the asset
        """
        pulumi.set(__self__, "browser_download_url", browser_download_url)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="browserDownloadUrl")
    def browser_download_url(self) -> str:
        """
        Browser download URL
        """
        return pulumi.get(self, "browser_download_url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        MIME type of the asset
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Date the asset was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        ID of the asset
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label for the asset
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The file name of the asset
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Node ID of the asset
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Size in byte
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Date the asset was last updated
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL of the asset
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetRepositoryBranchesBranchResult(dict):
    def __init__(__self__, *,
                 name: str,
                 protected: bool):
        """
        :param str name: Name of the branch.
        :param bool protected: Whether the branch is protected.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protected", protected)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the branch.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protected(self) -> bool:
        """
        Whether the branch is protected.
        """
        return pulumi.get(self, "protected")


@pulumi.output_type
class GetRepositoryDeployKeysKeyResult(dict):
    def __init__(__self__, *,
                 id: int,
                 key: str,
                 title: str,
                 verified: bool):
        """
        :param int id: Key id
        :param str key: Key itself
        :param str title: Key title
        :param bool verified: `true` if the key was verified.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "verified", verified)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        Key id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key itself
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Key title
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def verified(self) -> bool:
        """
        `true` if the key was verified.
        """
        return pulumi.get(self, "verified")


@pulumi.output_type
class GetRepositoryPageResult(dict):
    def __init__(__self__, *,
                 cname: str,
                 custom404: bool,
                 html_url: str,
                 sources: Sequence['outputs.GetRepositoryPageSourceResult'],
                 status: str,
                 url: str):
        """
        :param str html_url: URL to the repository on the web.
        """
        pulumi.set(__self__, "cname", cname)
        pulumi.set(__self__, "custom404", custom404)
        pulumi.set(__self__, "html_url", html_url)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def cname(self) -> str:
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter
    def custom404(self) -> bool:
        return pulumi.get(self, "custom404")

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> str:
        """
        URL to the repository on the web.
        """
        return pulumi.get(self, "html_url")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetRepositoryPageSourceResult']:
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")


@pulumi.output_type
class GetRepositoryPageSourceResult(dict):
    def __init__(__self__, *,
                 branch: str,
                 path: str):
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def branch(self) -> str:
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")


@pulumi.output_type
class GetRepositoryPullRequestsResultResult(dict):
    def __init__(__self__, *,
                 base_ref: str,
                 base_sha: str,
                 body: str,
                 draft: bool,
                 head_owner: str,
                 head_ref: str,
                 head_repository: str,
                 head_sha: str,
                 labels: Sequence[str],
                 maintainer_can_modify: bool,
                 number: int,
                 opened_at: int,
                 opened_by: str,
                 state: str,
                 title: str,
                 updated_at: int):
        """
        :param str base_ref: If set, filters Pull Requests by base branch name.
        :param str base_sha: Head commit SHA of the Pull Request base.
        :param str body: Body of the Pull Request.
        :param bool draft: Indicates Whether this Pull Request is a draft.
        :param str head_owner: Owner of the Pull Request head repository.
        :param str head_ref: If set, filters Pull Requests by head user or head organization and branch name in the format of "user:ref-name" or "organization:ref-name". For example: "github:new-script-format" or "octocat:test-branch".
        :param str head_repository: Name of the Pull Request head repository.
        :param str head_sha: Head commit SHA of the Pull Request head.
        :param Sequence[str] labels: List of label names set on the Pull Request.
        :param bool maintainer_can_modify: Indicates whether the base repository maintainers can modify the Pull Request.
        :param int number: The number of the Pull Request within the repository.
        :param int opened_at: Unix timestamp indicating the Pull Request creation time.
        :param str opened_by: GitHub login of the user who opened the Pull Request.
        :param str state: If set, filters Pull Requests by state. Can be "open", "closed", or "all". Default: "open".
        :param str title: The title of the Pull Request.
        :param int updated_at: The timestamp of the last Pull Request update.
        """
        pulumi.set(__self__, "base_ref", base_ref)
        pulumi.set(__self__, "base_sha", base_sha)
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "draft", draft)
        pulumi.set(__self__, "head_owner", head_owner)
        pulumi.set(__self__, "head_ref", head_ref)
        pulumi.set(__self__, "head_repository", head_repository)
        pulumi.set(__self__, "head_sha", head_sha)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "maintainer_can_modify", maintainer_can_modify)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "opened_at", opened_at)
        pulumi.set(__self__, "opened_by", opened_by)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="baseRef")
    def base_ref(self) -> str:
        """
        If set, filters Pull Requests by base branch name.
        """
        return pulumi.get(self, "base_ref")

    @property
    @pulumi.getter(name="baseSha")
    def base_sha(self) -> str:
        """
        Head commit SHA of the Pull Request base.
        """
        return pulumi.get(self, "base_sha")

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        Body of the Pull Request.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def draft(self) -> bool:
        """
        Indicates Whether this Pull Request is a draft.
        """
        return pulumi.get(self, "draft")

    @property
    @pulumi.getter(name="headOwner")
    def head_owner(self) -> str:
        """
        Owner of the Pull Request head repository.
        """
        return pulumi.get(self, "head_owner")

    @property
    @pulumi.getter(name="headRef")
    def head_ref(self) -> str:
        """
        If set, filters Pull Requests by head user or head organization and branch name in the format of "user:ref-name" or "organization:ref-name". For example: "github:new-script-format" or "octocat:test-branch".
        """
        return pulumi.get(self, "head_ref")

    @property
    @pulumi.getter(name="headRepository")
    def head_repository(self) -> str:
        """
        Name of the Pull Request head repository.
        """
        return pulumi.get(self, "head_repository")

    @property
    @pulumi.getter(name="headSha")
    def head_sha(self) -> str:
        """
        Head commit SHA of the Pull Request head.
        """
        return pulumi.get(self, "head_sha")

    @property
    @pulumi.getter
    def labels(self) -> Sequence[str]:
        """
        List of label names set on the Pull Request.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintainerCanModify")
    def maintainer_can_modify(self) -> bool:
        """
        Indicates whether the base repository maintainers can modify the Pull Request.
        """
        return pulumi.get(self, "maintainer_can_modify")

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        The number of the Pull Request within the repository.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter(name="openedAt")
    def opened_at(self) -> int:
        """
        Unix timestamp indicating the Pull Request creation time.
        """
        return pulumi.get(self, "opened_at")

    @property
    @pulumi.getter(name="openedBy")
    def opened_by(self) -> str:
        """
        GitHub login of the user who opened the Pull Request.
        """
        return pulumi.get(self, "opened_by")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        If set, filters Pull Requests by state. Can be "open", "closed", or "all". Default: "open".
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The title of the Pull Request.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> int:
        """
        The timestamp of the last Pull Request update.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetRepositoryTeamsTeamResult(dict):
    def __init__(__self__, *,
                 name: str,
                 permission: str,
                 slug: str):
        """
        :param str name: The name of the repository.
        :param str permission: Team permission
        :param str slug: Team slug
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permission", permission)
        pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        Team permission
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        Team slug
        """
        return pulumi.get(self, "slug")


@pulumi.output_type
class GetRepositoryTemplateResult(dict):
    def __init__(__self__, *,
                 owner: str,
                 repository: str):
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def repository(self) -> str:
        return pulumi.get(self, "repository")


@pulumi.output_type
class GetRepositoryWebhooksWebhookResult(dict):
    def __init__(__self__, *,
                 active: bool,
                 id: int,
                 name: str,
                 type: str,
                 url: str):
        """
        :param bool active: `true` if the webhook is active.
        :param int id: the ID of the webhook.
        :param str name: the name of the webhook.
        :param str type: the type of the webhook.
        :param str url: the url of the webhook.
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def active(self) -> bool:
        """
        `true` if the webhook is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        the ID of the webhook.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        the name of the webhook.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        the type of the webhook.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        the url of the webhook.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetTreeEntryResult(dict):
    def __init__(__self__, *,
                 mode: str,
                 path: str,
                 sha: str,
                 size: int,
                 type: str):
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "sha", sha)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def sha(self) -> str:
        return pulumi.get(self, "sha")

    @property
    @pulumi.getter
    def size(self) -> int:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


