# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['IssueArgs', 'Issue']

@pulumi.input_type
class IssueArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[str],
                 title: pulumi.Input[str],
                 assignees: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 milestone_number: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Issue resource.
        :param pulumi.Input[str] repository: The GitHub repository name
        :param pulumi.Input[str] title: Title of the issue
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assignees: List of Logins to assign the to the issue
        :param pulumi.Input[str] body: Body of the issue
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: List of labels to attach to the issue
        :param pulumi.Input[int] milestone_number: Milestone number to assign to the issue
        """
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "title", title)
        if assignees is not None:
            pulumi.set(__self__, "assignees", assignees)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if milestone_number is not None:
            pulumi.set(__self__, "milestone_number", milestone_number)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        The GitHub repository name
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        Title of the issue
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def assignees(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Logins to assign the to the issue
        """
        return pulumi.get(self, "assignees")

    @assignees.setter
    def assignees(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "assignees", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        Body of the issue
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of labels to attach to the issue
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="milestoneNumber")
    def milestone_number(self) -> Optional[pulumi.Input[int]]:
        """
        Milestone number to assign to the issue
        """
        return pulumi.get(self, "milestone_number")

    @milestone_number.setter
    def milestone_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "milestone_number", value)


@pulumi.input_type
class _IssueState:
    def __init__(__self__, *,
                 assignees: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 issue_id: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 milestone_number: Optional[pulumi.Input[int]] = None,
                 number: Optional[pulumi.Input[int]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Issue resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assignees: List of Logins to assign the to the issue
        :param pulumi.Input[str] body: Body of the issue
        :param pulumi.Input[int] issue_id: (Computed) - The issue id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: List of labels to attach to the issue
        :param pulumi.Input[int] milestone_number: Milestone number to assign to the issue
        :param pulumi.Input[int] number: (Computed) - The issue number
        :param pulumi.Input[str] repository: The GitHub repository name
        :param pulumi.Input[str] title: Title of the issue
        """
        if assignees is not None:
            pulumi.set(__self__, "assignees", assignees)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if issue_id is not None:
            pulumi.set(__self__, "issue_id", issue_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if milestone_number is not None:
            pulumi.set(__self__, "milestone_number", milestone_number)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def assignees(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Logins to assign the to the issue
        """
        return pulumi.get(self, "assignees")

    @assignees.setter
    def assignees(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "assignees", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        Body of the issue
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="issueId")
    def issue_id(self) -> Optional[pulumi.Input[int]]:
        """
        (Computed) - The issue id
        """
        return pulumi.get(self, "issue_id")

    @issue_id.setter
    def issue_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "issue_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of labels to attach to the issue
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="milestoneNumber")
    def milestone_number(self) -> Optional[pulumi.Input[int]]:
        """
        Milestone number to assign to the issue
        """
        return pulumi.get(self, "milestone_number")

    @milestone_number.setter
    def milestone_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "milestone_number", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[int]]:
        """
        (Computed) - The issue number
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The GitHub repository name
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Title of the issue
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


class Issue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignees: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 milestone_number: Optional[pulumi.Input[int]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a GitHub issue resource.

        This resource allows you to create and manage issue within your
        GitHub repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        # Create a simple issue
        test_repository = github.Repository("testRepository",
            auto_init=True,
            has_issues=True)
        test_issue = github.Issue("testIssue",
            repository=test_repository.name,
            title="My issue title",
            body="The body of my issue")
        ```
        ### With Milestone And Project Assignment

        ```python
        import pulumi
        import pulumi_github as github

        # Create an issue with milestone and project assignment
        test_repository = github.Repository("testRepository",
            auto_init=True,
            has_issues=True)
        test_repository_milestone = github.RepositoryMilestone("testRepositoryMilestone",
            owner=test_repository.full_name.apply(lambda full_name: full_name.split("/")).apply(lambda split: split[0]),
            repository=test_repository.name,
            title="v1.0.0",
            description="General Availability",
            due_date="2022-11-22",
            state="open")
        test_issue = github.Issue("testIssue",
            repository=test_repository.name,
            title="My issue",
            body="My issue body",
            labels=[
                "bug",
                "documentation",
            ],
            assignees=["bob-github"],
            milestone_number=test_repository_milestone.number)
        ```

        ## Import

        GitHub Issues can be imported using an ID made up of `repository:number`, e.g.

        ```sh
         $ pulumi import github:index/issue:Issue issue_15 myrepo:15
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assignees: List of Logins to assign the to the issue
        :param pulumi.Input[str] body: Body of the issue
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: List of labels to attach to the issue
        :param pulumi.Input[int] milestone_number: Milestone number to assign to the issue
        :param pulumi.Input[str] repository: The GitHub repository name
        :param pulumi.Input[str] title: Title of the issue
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IssueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GitHub issue resource.

        This resource allows you to create and manage issue within your
        GitHub repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        # Create a simple issue
        test_repository = github.Repository("testRepository",
            auto_init=True,
            has_issues=True)
        test_issue = github.Issue("testIssue",
            repository=test_repository.name,
            title="My issue title",
            body="The body of my issue")
        ```
        ### With Milestone And Project Assignment

        ```python
        import pulumi
        import pulumi_github as github

        # Create an issue with milestone and project assignment
        test_repository = github.Repository("testRepository",
            auto_init=True,
            has_issues=True)
        test_repository_milestone = github.RepositoryMilestone("testRepositoryMilestone",
            owner=test_repository.full_name.apply(lambda full_name: full_name.split("/")).apply(lambda split: split[0]),
            repository=test_repository.name,
            title="v1.0.0",
            description="General Availability",
            due_date="2022-11-22",
            state="open")
        test_issue = github.Issue("testIssue",
            repository=test_repository.name,
            title="My issue",
            body="My issue body",
            labels=[
                "bug",
                "documentation",
            ],
            assignees=["bob-github"],
            milestone_number=test_repository_milestone.number)
        ```

        ## Import

        GitHub Issues can be imported using an ID made up of `repository:number`, e.g.

        ```sh
         $ pulumi import github:index/issue:Issue issue_15 myrepo:15
        ```

        :param str resource_name: The name of the resource.
        :param IssueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IssueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignees: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 milestone_number: Optional[pulumi.Input[int]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IssueArgs.__new__(IssueArgs)

            __props__.__dict__["assignees"] = assignees
            __props__.__dict__["body"] = body
            __props__.__dict__["labels"] = labels
            __props__.__dict__["milestone_number"] = milestone_number
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["etag"] = None
            __props__.__dict__["issue_id"] = None
            __props__.__dict__["number"] = None
        super(Issue, __self__).__init__(
            'github:index/issue:Issue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assignees: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            body: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            issue_id: Optional[pulumi.Input[int]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            milestone_number: Optional[pulumi.Input[int]] = None,
            number: Optional[pulumi.Input[int]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            title: Optional[pulumi.Input[str]] = None) -> 'Issue':
        """
        Get an existing Issue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] assignees: List of Logins to assign the to the issue
        :param pulumi.Input[str] body: Body of the issue
        :param pulumi.Input[int] issue_id: (Computed) - The issue id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: List of labels to attach to the issue
        :param pulumi.Input[int] milestone_number: Milestone number to assign to the issue
        :param pulumi.Input[int] number: (Computed) - The issue number
        :param pulumi.Input[str] repository: The GitHub repository name
        :param pulumi.Input[str] title: Title of the issue
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IssueState.__new__(_IssueState)

        __props__.__dict__["assignees"] = assignees
        __props__.__dict__["body"] = body
        __props__.__dict__["etag"] = etag
        __props__.__dict__["issue_id"] = issue_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["milestone_number"] = milestone_number
        __props__.__dict__["number"] = number
        __props__.__dict__["repository"] = repository
        __props__.__dict__["title"] = title
        return Issue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def assignees(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Logins to assign the to the issue
        """
        return pulumi.get(self, "assignees")

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[str]]:
        """
        Body of the issue
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="issueId")
    def issue_id(self) -> pulumi.Output[int]:
        """
        (Computed) - The issue id
        """
        return pulumi.get(self, "issue_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of labels to attach to the issue
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="milestoneNumber")
    def milestone_number(self) -> pulumi.Output[Optional[int]]:
        """
        Milestone number to assign to the issue
        """
        return pulumi.get(self, "milestone_number")

    @property
    @pulumi.getter
    def number(self) -> pulumi.Output[int]:
        """
        (Computed) - The issue number
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        The GitHub repository name
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Title of the issue
        """
        return pulumi.get(self, "title")

