# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetActionsRegistrationTokenResult',
    'AwaitableGetActionsRegistrationTokenResult',
    'get_actions_registration_token',
    'get_actions_registration_token_output',
]

@pulumi.output_type
class GetActionsRegistrationTokenResult:
    """
    A collection of values returned by getActionsRegistrationToken.
    """
    def __init__(__self__, expires_at=None, id=None, repository=None, token=None):
        if expires_at and not isinstance(expires_at, int):
            raise TypeError("Expected argument 'expires_at' to be a int")
        pulumi.set(__self__, "expires_at", expires_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        pulumi.set(__self__, "repository", repository)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> int:
        """
        The token expiration date.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def repository(self) -> str:
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token that has been retrieved.
        """
        return pulumi.get(self, "token")


class AwaitableGetActionsRegistrationTokenResult(GetActionsRegistrationTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActionsRegistrationTokenResult(
            expires_at=self.expires_at,
            id=self.id,
            repository=self.repository,
            token=self.token)


def get_actions_registration_token(repository: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActionsRegistrationTokenResult:
    """
    Use this data source to retrieve a GitHub Actions repository registration token. This token can then be used to register a self-hosted runner.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_actions_registration_token(repository="example_repo")
    ```


    :param str repository: Name of the repository to get a GitHub Actions registration token for.
    """
    __args__ = dict()
    __args__['repository'] = repository
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getActionsRegistrationToken:getActionsRegistrationToken', __args__, opts=opts, typ=GetActionsRegistrationTokenResult).value

    return AwaitableGetActionsRegistrationTokenResult(
        expires_at=__ret__.expires_at,
        id=__ret__.id,
        repository=__ret__.repository,
        token=__ret__.token)


@_utilities.lift_output_func(get_actions_registration_token)
def get_actions_registration_token_output(repository: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetActionsRegistrationTokenResult]:
    """
    Use this data source to retrieve a GitHub Actions repository registration token. This token can then be used to register a self-hosted runner.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_actions_registration_token(repository="example_repo")
    ```


    :param str repository: Name of the repository to get a GitHub Actions registration token for.
    """
    ...
