"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsyncFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const appsync_generated_1 = require("./appsync.generated");
/**
 * AppSync Functions are local functions that perform certain operations
 * onto a backend data source. Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 *
 * @resource AWS::AppSync::FunctionConfiguration
 */
class AppsyncFunction extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AppsyncFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AppsyncFunction);
            }
            throw error;
        }
        this.function = new appsync_generated_1.CfnFunctionConfiguration(this, 'Resource', {
            name: props.name,
            description: props.description,
            apiId: props.api.apiId,
            dataSourceName: props.dataSource.name,
            functionVersion: '2018-05-29',
            requestMappingTemplate: props.requestMappingTemplate?.renderTemplate(),
            responseMappingTemplate: props.responseMappingTemplate?.renderTemplate(),
        });
        this.functionName = this.function.attrName;
        this.functionArn = this.function.attrFunctionArn;
        this.functionId = this.function.attrFunctionId;
        this.dataSource = props.dataSource;
        this.function.addDependsOn(this.dataSource.ds);
        props.api.addSchemaDependency(this.function);
    }
    /**
     * Import Appsync Function from arn
     */
    static fromAppsyncFunctionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AppsyncFunctionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAppsyncFunctionAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor(s, i) {
                super(s, i);
                this.functionId = core_1.Lazy.stringValue({
                    produce: () => core_1.Fn.select(3, core_1.Fn.split('/', attrs.functionArn)),
                });
                this.functionArn = attrs.functionArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.AppsyncFunction = AppsyncFunction;
_a = JSII_RTTI_SYMBOL_1;
AppsyncFunction[_a] = { fqn: "@aws-cdk/aws-appsync.AppsyncFunction", version: "1.187.0" };
//# sourceMappingURL=data:application/json;base64,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