# Copyright 2021 The KCL Authors. All rights reserved.

from .kcl_error import (
    KCLError,
    KCLException,
    KCLSyntaxException,
    KCLRuntimeException,
    KCLCompileException,
    KCLTypeException,
    UnKnownDecoratorError,
    DeprecatedError,
    InvalidDecoratorTargetError,
    KCLNameError,
    TypeRuntimeError,
    EvaluationError,
    KCLTabError,
    InvalidSyntaxError,
    CompileError,
    CannotFindModule,
    print_kcl_error_message,
    print_kcl_warning_message,
    print_common_error_message,
    print_internal_error_message,
    report_exception,
    report_warning,
    get_exception,
    ErrType,
)

from .kcl_err_theme import KCLErrMsgTheme, KCLErrMsgThemeDefault

from .kcl_err_template import (
    ErrLevel,
    ErrFileMsg,
    FileCache,
)

from .kcl_err_msg import (
    ErrEwcode,
    KCL_ERR_MSG,
    INT_OVER_FLOW_MSG,
    FLOAT_OVER_FLOW_MSG,
    FLOAT_UNDER_FLOW_MSG,
    DEPRECATED_WARNING_MSG,
    SCHEMA_CHECK_FILE_MSG_ERR,
    SCHEMA_CHECK_FILE_MSG_COND,
    RECURSIVE_LOADING_MODULE_MSG,
    CANNOT_FIND_MODULE_MSG,
    UNIQUE_KEY_MSG,
    CANNOT_ADD_MEMBERS_MSG,
    MULTI_INHERIT_MSG,
    INDENTATION_ERROR_MSG,
    UNKNOWN_DECORATOR_MSG,
    INVALID_DECORATOR_TARGET_MSG,
    NAME_ERROR_MSG,
    INVALID_FORMAT_SPEC_MSG,
)

__all__ = [
    "ErrLevel",
    "report_exception",
    "report_warning",
    "ErrType",
    "get_exception",
    "INT_OVER_FLOW_MSG",
    "FLOAT_OVER_FLOW_MSG",
    "FLOAT_UNDER_FLOW_MSG",
    "DEPRECATED_WARNING_MSG",
    "SCHEMA_CHECK_FILE_MSG_ERR",
    "SCHEMA_CHECK_FILE_MSG_COND",
    "UNIQUE_KEY_MSG",
    "CANNOT_ADD_MEMBERS_MSG",
    "RECURSIVE_LOADING_MODULE_MSG",
    "CANNOT_FIND_MODULE_MSG",
    "MULTI_INHERIT_MSG",
    "INDENTATION_ERROR_MSG",
    "UNKNOWN_DECORATOR_MSG",
    "INVALID_DECORATOR_TARGET_MSG",
    "NAME_ERROR_MSG",
    "INVALID_FORMAT_SPEC_MSG",
    "ErrFileMsg",
    "ErrEwcode",
    "print_kcl_error_message",
    "print_kcl_warning_message",
    "print_common_error_message",
    "print_internal_error_message",
    "KCLException",
    "KCLSyntaxException",
    "KCLCompileException",
    "KCLRuntimeException",
    "KCLTypeException",
    "UnKnownDecoratorError",
    "InvalidDecoratorTargetError",
    "KCLNameError",
    "TypeRuntimeError",
    "EvaluationError",
    "KCLError",
    "DeprecatedError",
    "KCLTabError",
    "InvalidSyntaxError",
    "CompileError",
    "CannotFindModule",
    "KCLErrMsgTheme",
    "KCLErrMsgThemeDefault",
    "KCL_ERR_MSG",
    "FileCache",
]
