# -----------------------------------------------------------
# Autogenerated ODE definition from SBML file with sbmlutils.
#
#    model: {{ model.getId() }}
# -----------------------------------------------------------

# -------------------
# ids
# -------------------
xids <- c({% for id in xids %}"{{ id }}"{% if not loop.last %}, {% endif %}{% endfor %})
pids <- c({% for id in pids %}"{{ id }}"{% if not loop.last %}, {% endif %}{% endfor %})
yids <- c({% for id in yids %}"{{ id }}"{% if not loop.last %}, {% endif %}{% endfor %})

# -------------------
# initial conditions
# -------------------
x0 = c(
{% for id in xids %}
  {{ id }} = {{ x0[id] }}{% if not loop.last %},{% endif %}      # [{{ loop.index }}]
{% endfor %}
)

# -------------------
# parameters
# -------------------
p = c(
{% for id in pids %}
  {{ id }} = {{ p[id] }}{% if not loop.last %},{% endif %}      # [{{ loop.index }}]
{% endfor %}
)


# -------------------
# dmod odes
# -------------------
dxdt_dmod <- c(
    {% for id in xids %}
    {{ id }} = "{{ dx_flat[id] }}"{% if not loop.last %}, {% endif %}  # [{{ loop.index }}]
    {% endfor %}
)

y_dmod <- c(
    {% for id in yids %}
    {{ id }} = "{{ y_flat[id] }}"{% if not loop.last %}, {% endif %}  # [{{ loop.index }}]
    {% endfor %}
)



# -------------------
# odes
# -------------------
f_dxdt <- function(t, x, p){
    # ODE system
    {% for id in yids %}
    {{ id }} = {{ y[id] }}      # [{{ loop.index }}] {{ id }}
    {% endfor %}

    # ode
    list(c(
        {% for id in xids %}
        d{{ id }} = {{ dx[id] }}{% if not loop.last %},{% endif %}

        {% endfor %}
    ))
}

f_y <- function(times, x, p){
    # Calculate y

    {% for id in yids %}
    {{ id }} = {{ y[id] }}  # [{{ loop.index }}] {{ id }}
    {% endfor %}

    # --------------------------------------
    c({% for id in yids %}{{ id }}{% if not loop.last %}, {% endif %}{% endfor %})
}


f_z <- function(times, X, p){
    # calculate z
    shape <- dim(X)
    Nt <- shape[1]
    Nx <- shape[2] - 1
    Ny = length(yids)
    Nz = 1 + Nx + Ny
    Z = matrix(, nrow=Nt, ncol=Nz)
    Z[,1] = times
    for (kx in seq(Nx)){
        Z[,(1+kx)] = X[,1+kx]
    }
    for (kt in seq(Nt)){
        y = f_y(t=times[kt], x=X[kt, 2:(Nx+1)], p=p)
        Z[kt, (2+Nx):Nz] = y
    }
    colnames(Z) <- c ("time", xids, yids)
    Z
}