/**
 * (experimental) An entry in the list of packages blocked from display in the construct hub.
 *
 * @experimental
 */
export interface DenyListRule {
    /**
     * (experimental) The name of the package to block (npm).
     *
     * @experimental
     */
    readonly package: string;
    /**
     * (experimental) The package version to block (must be a valid version such as "1.0.3").
     *
     * @default - all versions of this package are blocked.
     * @experimental
     */
    readonly version?: string;
    /**
     * (experimental) The reason why this package/version is denied.
     *
     * This information will be
     * emitted to the construct hub logs.
     *
     * @experimental
     */
    readonly reason: string;
}
/**
 * (experimental) The contents of the deny list file in S3.
 *
 * @experimental
 */
export interface DenyListMap {
    /**
     * A map from "name@version" to deny list rule.
     */
    readonly [key: string]: DenyListRule;
}
