var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};

// src/__tests__/backend/deny-list/integ/trigger.prune-test.lambda.ts
__export(exports, {
  handler: () => handler
});
var AWS = __toModule(require("aws-sdk"));

// src/backend/shared/env.lambda-shared.ts
var import_process = __toModule(require("process"));
function requireEnv(name) {
  const result = import_process.env[name];
  if (!result) {
    throw new Error(`No value specified for required environment variable: ${name}`);
  }
  return result;
}

// src/__tests__/backend/deny-list/integ/trigger.prune-test.lambda.ts
var s3 = new AWS.S3();
async function handler() {
  const bucketName = requireEnv("BUCKET_NAME");
  const timeoutSec = parseInt(requireEnv("TIMEOUT_SEC"));
  const expectedKeys = JSON.parse(requireEnv("EXPECTED_KEYS"));
  const expected = canonicalRepresentation(expectedKeys);
  console.log(JSON.stringify({ expected: expectedKeys }));
  const startTime = Date.now();
  let actual;
  while ((Date.now() - startTime) / 1e3 < timeoutSec) {
    actual = canonicalRepresentation(await getAllObjectKeys(bucketName));
    console.log(JSON.stringify({ keys: actual }));
    if (actual === expected) {
      console.log("assertion succeeded");
      return;
    }
  }
  throw new Error(`assertion failed. the following objects were not deleted after ${timeoutSec}s. Actual: ${actual}. Expected: ${expected}`);
}
async function getAllObjectKeys(bucket) {
  var _a;
  let continuationToken;
  const objectKeys = new Array();
  do {
    const listRequest = {
      Bucket: bucket,
      ContinuationToken: continuationToken
    };
    console.log(JSON.stringify({ listRequest }));
    const listResponse = await s3.listObjectsV2(listRequest).promise();
    console.log(JSON.stringify({ listResponse }));
    continuationToken = listResponse.NextContinuationToken;
    for (const { Key: key } of (_a = listResponse.Contents) != null ? _a : []) {
      if (!key) {
        continue;
      }
      objectKeys.push(key);
    }
  } while (continuationToken);
  return objectKeys;
}
function canonicalRepresentation(list) {
  return JSON.stringify(list.sort());
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
