"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resolver = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const appsync_generated_1 = require("./appsync.generated");
const caching_key_1 = require("./caching-key");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_1 = require("@aws-cdk/core");
/**
 * An AppSync resolver
 */
class Resolver extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_ResolverProps(props);
        const pipelineConfig = props.pipelineConfig && props.pipelineConfig.length ?
            { functions: props.pipelineConfig.map((func) => func.functionId) }
            : undefined;
        if (pipelineConfig && props.dataSource) {
            throw new Error(`Pipeline Resolver cannot have data source. Received: ${props.dataSource.name}`);
        }
        if (((_b = props.cachingConfig) === null || _b === void 0 ? void 0 : _b.ttl) && (props.cachingConfig.ttl.toSeconds() < 1 || props.cachingConfig.ttl.toSeconds() > 3600)) {
            throw new Error(`Caching config TTL must be between 1 and 3600 seconds. Received: ${props.cachingConfig.ttl.toSeconds()}`);
        }
        if ((_c = props.cachingConfig) === null || _c === void 0 ? void 0 : _c.cachingKeys) {
            if (props.cachingConfig.cachingKeys.find(cachingKey => !core_1.Token.isUnresolved(cachingKey) && !caching_key_1.BASE_CACHING_KEYS.find(baseCachingKey => cachingKey.startsWith(baseCachingKey)))) {
                throw new Error(`Caching config keys must begin with $context.arguments, $context.source or $context.identity. Received: ${props.cachingConfig.cachingKeys}`);
            }
        }
        this.resolver = new appsync_generated_1.CfnResolver(this, 'Resource', {
            apiId: props.api.apiId,
            typeName: props.typeName,
            fieldName: props.fieldName,
            dataSourceName: props.dataSource ? props.dataSource.name : undefined,
            kind: pipelineConfig ? 'PIPELINE' : 'UNIT',
            pipelineConfig: pipelineConfig,
            requestMappingTemplate: props.requestMappingTemplate ? props.requestMappingTemplate.renderTemplate() : undefined,
            responseMappingTemplate: props.responseMappingTemplate ? props.responseMappingTemplate.renderTemplate() : undefined,
            cachingConfig: this.createCachingConfig(props.cachingConfig),
        });
        props.api.addSchemaDependency(this.resolver);
        if (props.dataSource) {
            this.resolver.addDependsOn(props.dataSource.ds);
        }
        this.arn = this.resolver.attrResolverArn;
    }
    createCachingConfig(config) {
        var _b;
        return config ? {
            cachingKeys: config.cachingKeys,
            ttl: (_b = config.ttl) === null || _b === void 0 ? void 0 : _b.toSeconds(),
        } : undefined;
    }
}
exports.Resolver = Resolver;
_a = JSII_RTTI_SYMBOL_1;
Resolver[_a] = { fqn: "@aws-cdk/aws-appsync.Resolver", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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