"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchDataSource = exports.RdsDataSource = exports.LambdaDataSource = exports.HttpDataSource = exports.DynamoDbDataSource = exports.NoneDataSource = exports.BackedDataSource = exports.BaseDataSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const appsync_function_1 = require("./appsync-function");
const appsync_generated_1 = require("./appsync.generated");
const resolver_1 = require("./resolver");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * Abstract AppSync datasource implementation. Do not use directly but use subclasses for concrete datasources
 */
class BaseDataSource extends core_2.Construct {
    constructor(scope, id, props, extended) {
        var _j, _k;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_BackedDataSourceProps(props);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_ExtendedDataSourceProps(extended);
        if (extended.type !== 'NONE') {
            this.serviceRole = props.serviceRole || new aws_iam_1.Role(this, 'ServiceRole', { assumedBy: new aws_iam_1.ServicePrincipal('appsync') });
        }
        // Replace unsupported characters from DataSource name. The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}
        const name = ((_j = props.name) !== null && _j !== void 0 ? _j : id).replace(/[\W]+/g, '');
        this.ds = new appsync_generated_1.CfnDataSource(this, 'Resource', {
            apiId: props.api.apiId,
            name: name,
            description: props.description,
            serviceRoleArn: (_k = this.serviceRole) === null || _k === void 0 ? void 0 : _k.roleArn,
            ...extended,
        });
        this.name = name;
        this.api = props.api;
    }
    /**
     * creates a new resolver for this datasource and API using the given properties
     */
    createResolver(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseResolverProps(props);
        return new resolver_1.Resolver(this, `${props.typeName}${props.fieldName}Resolver`, {
            api: this.api,
            dataSource: this,
            ...props,
        });
    }
    /**
     * creates a new appsync function for this datasource and API using the given properties
     */
    createFunction(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseAppsyncFunctionProps(props);
        return new appsync_function_1.AppsyncFunction(this, `${props.name}Function`, {
            api: this.api,
            dataSource: this,
            ...props,
        });
    }
}
exports.BaseDataSource = BaseDataSource;
_a = JSII_RTTI_SYMBOL_1;
BaseDataSource[_a] = { fqn: "@aws-cdk/aws-appsync.BaseDataSource", version: "1.146.0" };
/**
 * Abstract AppSync datasource implementation. Do not use directly but use subclasses for resource backed datasources
 */
class BackedDataSource extends BaseDataSource {
    constructor(scope, id, props, extended) {
        super(scope, id, props, extended);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_BackedDataSourceProps(props);
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_ExtendedDataSourceProps(extended);
        this.grantPrincipal = this.serviceRole;
    }
}
exports.BackedDataSource = BackedDataSource;
_b = JSII_RTTI_SYMBOL_1;
BackedDataSource[_b] = { fqn: "@aws-cdk/aws-appsync.BackedDataSource", version: "1.146.0" };
/**
 * An AppSync dummy datasource
 */
class NoneDataSource extends BaseDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'NONE',
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_NoneDataSourceProps(props);
    }
}
exports.NoneDataSource = NoneDataSource;
_c = JSII_RTTI_SYMBOL_1;
NoneDataSource[_c] = { fqn: "@aws-cdk/aws-appsync.NoneDataSource", version: "1.146.0" };
/**
 * An AppSync datasource backed by a DynamoDB table
 */
class DynamoDbDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_DYNAMODB',
            dynamoDbConfig: {
                tableName: props.table.tableName,
                awsRegion: props.table.stack.region,
                useCallerCredentials: props.useCallerCredentials,
            },
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_DynamoDbDataSourceProps(props);
        if (props.readOnlyAccess) {
            props.table.grantReadData(this);
        }
        else {
            props.table.grantReadWriteData(this);
        }
    }
}
exports.DynamoDbDataSource = DynamoDbDataSource;
_d = JSII_RTTI_SYMBOL_1;
DynamoDbDataSource[_d] = { fqn: "@aws-cdk/aws-appsync.DynamoDbDataSource", version: "1.146.0" };
/**
 * An AppSync datasource backed by a http endpoint
 */
class HttpDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_HttpDataSourceProps(props);
        const authorizationConfig = props.authorizationConfig ? {
            authorizationType: 'AWS_IAM',
            awsIamConfig: props.authorizationConfig,
        } : undefined;
        super(scope, id, props, {
            type: 'HTTP',
            httpConfig: {
                endpoint: props.endpoint,
                authorizationConfig,
            },
        });
    }
}
exports.HttpDataSource = HttpDataSource;
_e = JSII_RTTI_SYMBOL_1;
HttpDataSource[_e] = { fqn: "@aws-cdk/aws-appsync.HttpDataSource", version: "1.146.0" };
/**
 * An AppSync datasource backed by a Lambda function
 */
class LambdaDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AWS_LAMBDA',
            lambdaConfig: {
                lambdaFunctionArn: props.lambdaFunction.functionArn,
            },
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_LambdaDataSourceProps(props);
        props.lambdaFunction.grantInvoke(this);
    }
}
exports.LambdaDataSource = LambdaDataSource;
_f = JSII_RTTI_SYMBOL_1;
LambdaDataSource[_f] = { fqn: "@aws-cdk/aws-appsync.LambdaDataSource", version: "1.146.0" };
/**
 * An AppSync datasource backed by RDS
 */
class RdsDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'RELATIONAL_DATABASE',
            relationalDatabaseConfig: {
                rdsHttpEndpointConfig: {
                    awsRegion: props.serverlessCluster.stack.region,
                    dbClusterIdentifier: core_1.Lazy.string({
                        produce: () => {
                            return core_1.Stack.of(this).formatArn({
                                service: 'rds',
                                resource: `cluster:${props.serverlessCluster.clusterIdentifier}`,
                            });
                        },
                    }),
                    awsSecretStoreArn: props.secretStore.secretArn,
                    databaseName: props.databaseName,
                },
                relationalDatabaseSourceType: 'RDS_HTTP_ENDPOINT',
            },
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_RdsDataSourceProps(props);
        const clusterArn = core_1.Stack.of(this).formatArn({
            service: 'rds',
            resource: `cluster:${props.serverlessCluster.clusterIdentifier}`,
        });
        props.secretStore.grantRead(this);
        // Change to grant with RDS grant becomes implemented
        props.serverlessCluster.grantDataApiAccess(this);
        aws_iam_1.Grant.addToPrincipal({
            grantee: this,
            actions: [
                'rds-data:DeleteItems',
                'rds-data:ExecuteSql',
                'rds-data:GetItems',
                'rds-data:InsertItems',
                'rds-data:UpdateItems',
            ],
            resourceArns: [clusterArn, `${clusterArn}:*`],
            scope: this,
        });
    }
}
exports.RdsDataSource = RdsDataSource;
_g = JSII_RTTI_SYMBOL_1;
RdsDataSource[_g] = { fqn: "@aws-cdk/aws-appsync.RdsDataSource", version: "1.146.0" };
/**
 * An Appsync datasource backed by Elasticsearch
 */
class ElasticsearchDataSource extends BackedDataSource {
    constructor(scope, id, props) {
        super(scope, id, props, {
            type: 'AMAZON_ELASTICSEARCH',
            elasticsearchConfig: {
                awsRegion: props.domain.stack.region,
                endpoint: `https://${props.domain.domainEndpoint}`,
            },
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appsync_ElasticsearchDataSourceProps(props);
        props.domain.grantReadWrite(this);
    }
}
exports.ElasticsearchDataSource = ElasticsearchDataSource;
_h = JSII_RTTI_SYMBOL_1;
ElasticsearchDataSource[_h] = { fqn: "@aws-cdk/aws-appsync.ElasticsearchDataSource", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS1zb3VyY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkYXRhLXNvdXJjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFFQSw4Q0FBZ0c7QUFJaEcsd0NBQXlEO0FBRXpELHlEQUErRTtBQUMvRSwyREFBb0Q7QUFFcEQseUNBQXlEO0FBRXpELGdIQUFnSDtBQUNoSCwyQkFBMkI7QUFDM0Isd0NBQTJEO0FBNEUzRDs7R0FFRztBQUNILE1BQXNCLGNBQWUsU0FBUSxnQkFBYTtJQWF4RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCLEVBQUUsUUFBaUM7O1FBQ3ZHLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7OztRQUVqQixJQUFJLFFBQVEsQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO1lBQzVCLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsSUFBSSxJQUFJLGNBQUksQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFLEVBQUUsU0FBUyxFQUFFLElBQUksMEJBQWdCLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1NBQ3ZIO1FBQ0QsNkdBQTZHO1FBQzdHLE1BQU0sSUFBSSxHQUFHLE9BQUMsS0FBSyxDQUFDLElBQUksbUNBQUksRUFBRSxDQUFDLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUN0RCxJQUFJLENBQUMsRUFBRSxHQUFHLElBQUksaUNBQWEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzVDLEtBQUssRUFBRSxLQUFLLENBQUMsR0FBRyxDQUFDLEtBQUs7WUFDdEIsSUFBSSxFQUFFLElBQUk7WUFDVixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsY0FBYyxRQUFFLElBQUksQ0FBQyxXQUFXLDBDQUFFLE9BQU87WUFDekMsR0FBRyxRQUFRO1NBQ1osQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7UUFDakIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDO0tBQ3RCO0lBRUQ7O09BRUc7SUFDSSxjQUFjLENBQUMsS0FBd0I7O1FBQzVDLE9BQU8sSUFBSSxtQkFBUSxDQUFDLElBQUksRUFBRSxHQUFHLEtBQUssQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFNBQVMsVUFBVSxFQUFFO1lBQ3ZFLEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRztZQUNiLFVBQVUsRUFBRSxJQUFJO1lBQ2hCLEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQztLQUNKO0lBRUQ7O09BRUc7SUFDSSxjQUFjLENBQUMsS0FBK0I7O1FBQ25ELE9BQU8sSUFBSSxrQ0FBZSxDQUFDLElBQUksRUFBRSxHQUFHLEtBQUssQ0FBQyxJQUFJLFVBQVUsRUFBRTtZQUN4RCxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7WUFDYixVQUFVLEVBQUUsSUFBSTtZQUNoQixHQUFHLEtBQUs7U0FDVCxDQUFDLENBQUM7S0FDSjs7QUFwREgsd0NBcURDOzs7QUFFRDs7R0FFRztBQUNILE1BQXNCLGdCQUFpQixTQUFRLGNBQWM7SUFNM0QsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QixFQUFFLFFBQWlDO1FBQ3ZHLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQzs7O1FBRWxDLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLFdBQVksQ0FBQztLQUN6Qzs7QUFWSCw0Q0FXQzs7O0FBUUQ7O0dBRUc7QUFDSCxNQUFhLGNBQWUsU0FBUSxjQUFjO0lBQ2hELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFO1lBQ3RCLElBQUksRUFBRSxNQUFNO1NBQ2IsQ0FBQyxDQUFDOztLQUNKOztBQUxILHdDQU1DOzs7QUF3QkQ7O0dBRUc7QUFDSCxNQUFhLGtCQUFtQixTQUFRLGdCQUFnQjtJQUN0RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQThCO1FBQ3RFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRTtZQUN0QixJQUFJLEVBQUUsaUJBQWlCO1lBQ3ZCLGNBQWMsRUFBRTtnQkFDZCxTQUFTLEVBQUUsS0FBSyxDQUFDLEtBQUssQ0FBQyxTQUFTO2dCQUNoQyxTQUFTLEVBQUUsS0FBSyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsTUFBTTtnQkFDbkMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLG9CQUFvQjthQUNqRDtTQUNGLENBQUMsQ0FBQzs7UUFDSCxJQUFJLEtBQUssQ0FBQyxjQUFjLEVBQUU7WUFDeEIsS0FBSyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDakM7YUFBTTtZQUNMLEtBQUssQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDdEM7S0FDRjs7QUFmSCxnREFnQkM7OztBQW1DRDs7R0FFRztBQUNILE1BQWEsY0FBZSxTQUFRLGdCQUFnQjtJQUNsRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCOztRQUNsRSxNQUFNLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7WUFDdEQsaUJBQWlCLEVBQUUsU0FBUztZQUM1QixZQUFZLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtTQUN4QyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7UUFDZCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUU7WUFDdEIsSUFBSSxFQUFFLE1BQU07WUFDWixVQUFVLEVBQUU7Z0JBQ1YsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO2dCQUN4QixtQkFBbUI7YUFDcEI7U0FDRixDQUFDLENBQUM7S0FDSjs7QUFiSCx3Q0FjQzs7O0FBWUQ7O0dBRUc7QUFDSCxNQUFhLGdCQUFpQixTQUFRLGdCQUFnQjtJQUNwRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRTtZQUN0QixJQUFJLEVBQUUsWUFBWTtZQUNsQixZQUFZLEVBQUU7Z0JBQ1osaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGNBQWMsQ0FBQyxXQUFXO2FBQ3BEO1NBQ0YsQ0FBQyxDQUFDOztRQUNILEtBQUssQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ3hDOztBQVRILDRDQVVDOzs7QUFzQkQ7O0dBRUc7QUFDSCxNQUFhLGFBQWMsU0FBUSxnQkFBZ0I7SUFDakQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF5QjtRQUNqRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLEVBQUU7WUFDdEIsSUFBSSxFQUFFLHFCQUFxQjtZQUMzQix3QkFBd0IsRUFBRTtnQkFDeEIscUJBQXFCLEVBQUU7b0JBQ3JCLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLE1BQU07b0JBQy9DLG1CQUFtQixFQUFFLFdBQUksQ0FBQyxNQUFNLENBQUM7d0JBQy9CLE9BQU8sRUFBRSxHQUFHLEVBQUU7NEJBQ1osT0FBTyxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQztnQ0FDOUIsT0FBTyxFQUFFLEtBQUs7Z0NBQ2QsUUFBUSxFQUFFLFdBQVcsS0FBSyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFOzZCQUNqRSxDQUFDLENBQUM7d0JBQ0wsQ0FBQztxQkFDRixDQUFDO29CQUNGLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxXQUFXLENBQUMsU0FBUztvQkFDOUMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO2lCQUNqQztnQkFDRCw0QkFBNEIsRUFBRSxtQkFBbUI7YUFDbEQ7U0FDRixDQUFDLENBQUM7O1FBQ0gsTUFBTSxVQUFVLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7WUFDMUMsT0FBTyxFQUFFLEtBQUs7WUFDZCxRQUFRLEVBQUUsV0FBVyxLQUFLLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUU7U0FDakUsQ0FBQyxDQUFDO1FBQ0gsS0FBSyxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFbEMscURBQXFEO1FBRXJELEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVqRCxlQUFLLENBQUMsY0FBYyxDQUFDO1lBQ25CLE9BQU8sRUFBRSxJQUFJO1lBQ2IsT0FBTyxFQUFFO2dCQUNQLHNCQUFzQjtnQkFDdEIscUJBQXFCO2dCQUNyQixtQkFBbUI7Z0JBQ25CLHNCQUFzQjtnQkFDdEIsc0JBQXNCO2FBQ3ZCO1lBQ0QsWUFBWSxFQUFFLENBQUMsVUFBVSxFQUFFLEdBQUcsVUFBVSxJQUFJLENBQUM7WUFDN0MsS0FBSyxFQUFFLElBQUk7U0FDWixDQUFDLENBQUM7S0FDSjs7QUEzQ0gsc0NBNENDOzs7QUFZRDs7R0FFRztBQUNILE1BQWEsdUJBQXdCLFNBQVEsZ0JBQWdCO0lBQzNELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUM7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFO1lBQ3RCLElBQUksRUFBRSxzQkFBc0I7WUFDNUIsbUJBQW1CLEVBQUU7Z0JBQ25CLFNBQVMsRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxNQUFNO2dCQUNwQyxRQUFRLEVBQUUsV0FBVyxLQUFLLENBQUMsTUFBTSxDQUFDLGNBQWMsRUFBRTthQUNuRDtTQUNGLENBQUMsQ0FBQzs7UUFFSCxLQUFLLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUNuQzs7QUFYSCwwREFZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElUYWJsZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1keW5hbW9kYic7XG5pbXBvcnQgeyBJRG9tYWluIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWVsYXN0aWNzZWFyY2gnO1xuaW1wb3J0IHsgR3JhbnQsIElHcmFudGFibGUsIElQcmluY2lwYWwsIElSb2xlLCBSb2xlLCBTZXJ2aWNlUHJpbmNpcGFsIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBJRnVuY3Rpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IElTZXJ2ZXJsZXNzQ2x1c3RlciB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1yZHMnO1xuaW1wb3J0IHsgSVNlY3JldCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zZWNyZXRzbWFuYWdlcic7XG5pbXBvcnQgeyBJUmVzb2x2YWJsZSwgTGF6eSwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQmFzZUFwcHN5bmNGdW5jdGlvblByb3BzLCBBcHBzeW5jRnVuY3Rpb24gfSBmcm9tICcuL2FwcHN5bmMtZnVuY3Rpb24nO1xuaW1wb3J0IHsgQ2ZuRGF0YVNvdXJjZSB9IGZyb20gJy4vYXBwc3luYy5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSUdyYXBocWxBcGkgfSBmcm9tICcuL2dyYXBocWxhcGktYmFzZSc7XG5pbXBvcnQgeyBCYXNlUmVzb2x2ZXJQcm9wcywgUmVzb2x2ZXIgfSBmcm9tICcuL3Jlc29sdmVyJztcblxuLy8gdjIgLSBrZWVwIHRoaXMgaW1wb3J0IGFzIGEgc2VwYXJhdGUgc2VjdGlvbiB0byByZWR1Y2UgbWVyZ2UgY29uZmxpY3Qgd2hlbiBmb3J3YXJkIG1lcmdpbmcgd2l0aCB0aGUgdjIgYnJhbmNoLlxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lXG5pbXBvcnQgeyBDb25zdHJ1Y3QgYXMgQ29yZUNvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIEJhc2UgcHJvcGVydGllcyBmb3IgYW4gQXBwU3luYyBkYXRhc291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQmFzZURhdGFTb3VyY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgQVBJIHRvIGF0dGFjaCB0aGlzIGRhdGEgc291cmNlIHRvXG4gICAqL1xuICByZWFkb25seSBhcGk6IElHcmFwaHFsQXBpO1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIGRhdGEgc291cmNlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gaWQgb2YgZGF0YSBzb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiB0aGUgZGVzY3JpcHRpb24gb2YgdGhlIGRhdGEgc291cmNlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogcHJvcGVydGllcyBmb3IgYW4gQXBwU3luYyBkYXRhc291cmNlIGJhY2tlZCBieSBhIHJlc291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQmFja2VkRGF0YVNvdXJjZVByb3BzIGV4dGVuZHMgQmFzZURhdGFTb3VyY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgSUFNIHNlcnZpY2Ugcm9sZSB0byBiZSBhc3N1bWVkIGJ5IEFwcFN5bmMgdG8gaW50ZXJhY3Qgd2l0aCB0aGUgZGF0YSBzb3VyY2VcbiAgICpcbiAgICogQGRlZmF1bHQgLSAgQ3JlYXRlIGEgbmV3IHJvbGVcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VSb2xlPzogSVJvbGU7XG59XG5cbi8qKlxuICogcHJvcHMgdXNlZCBieSBpbXBsZW1lbnRhdGlvbnMgb2YgQmFzZURhdGFTb3VyY2UgdG8gcHJvdmlkZSBjb25maWd1cmF0aW9uLiBTaG91bGQgbm90IGJlIHVzZWQgZGlyZWN0bHkuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRXh0ZW5kZWREYXRhU291cmNlUHJvcHMge1xuICAvKipcbiAgICogdGhlIHR5cGUgb2YgdGhlIEFwcFN5bmMgZGF0YXNvdXJjZVxuICAgKi9cbiAgcmVhZG9ubHkgdHlwZTogc3RyaW5nO1xuICAvKipcbiAgICogY29uZmlndXJhdGlvbiBmb3IgRHluYW1vREIgRGF0YXNvdXJjZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGNvbmZpZ1xuICAgKi9cbiAgcmVhZG9ubHkgZHluYW1vRGJDb25maWc/OiBDZm5EYXRhU291cmNlLkR5bmFtb0RCQ29uZmlnUHJvcGVydHkgfCBJUmVzb2x2YWJsZTtcbiAgLyoqXG4gICAqIGNvbmZpZ3VyYXRpb24gZm9yIEVsYXN0aWNzZWFyY2ggRGF0YXNvdXJjZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGNvbmZpZ1xuICAgKi9cbiAgcmVhZG9ubHkgZWxhc3RpY3NlYXJjaENvbmZpZz86IENmbkRhdGFTb3VyY2UuRWxhc3RpY3NlYXJjaENvbmZpZ1Byb3BlcnR5IHwgSVJlc29sdmFibGU7XG4gIC8qKlxuICAgKiBjb25maWd1cmF0aW9uIGZvciBIVFRQIERhdGFzb3VyY2VcbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBjb25maWdcbiAgICovXG4gIHJlYWRvbmx5IGh0dHBDb25maWc/OiBDZm5EYXRhU291cmNlLkh0dHBDb25maWdQcm9wZXJ0eSB8IElSZXNvbHZhYmxlO1xuICAvKipcbiAgICogY29uZmlndXJhdGlvbiBmb3IgTGFtYmRhIERhdGFzb3VyY2VcbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBjb25maWdcbiAgICovXG4gIHJlYWRvbmx5IGxhbWJkYUNvbmZpZz86IENmbkRhdGFTb3VyY2UuTGFtYmRhQ29uZmlnUHJvcGVydHkgfCBJUmVzb2x2YWJsZTtcbiAgLyoqXG4gICAqIGNvbmZpZ3VyYXRpb24gZm9yIFJEUyBEYXRhc291cmNlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gY29uZmlnXG4gICAqL1xuICByZWFkb25seSByZWxhdGlvbmFsRGF0YWJhc2VDb25maWc/OiBDZm5EYXRhU291cmNlLlJlbGF0aW9uYWxEYXRhYmFzZUNvbmZpZ1Byb3BlcnR5IHwgSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQWJzdHJhY3QgQXBwU3luYyBkYXRhc291cmNlIGltcGxlbWVudGF0aW9uLiBEbyBub3QgdXNlIGRpcmVjdGx5IGJ1dCB1c2Ugc3ViY2xhc3NlcyBmb3IgY29uY3JldGUgZGF0YXNvdXJjZXNcbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEJhc2VEYXRhU291cmNlIGV4dGVuZHMgQ29yZUNvbnN0cnVjdCB7XG4gIC8qKlxuICAgKiB0aGUgbmFtZSBvZiB0aGUgZGF0YSBzb3VyY2VcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAgKiB0aGUgdW5kZXJseWluZyBDRk4gZGF0YSBzb3VyY2UgcmVzb3VyY2VcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBkczogQ2ZuRGF0YVNvdXJjZTtcblxuICBwcm90ZWN0ZWQgYXBpOiBJR3JhcGhxbEFwaTtcbiAgcHJvdGVjdGVkIHNlcnZpY2VSb2xlPzogSVJvbGU7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEJhY2tlZERhdGFTb3VyY2VQcm9wcywgZXh0ZW5kZWQ6IEV4dGVuZGVkRGF0YVNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGlmIChleHRlbmRlZC50eXBlICE9PSAnTk9ORScpIHtcbiAgICAgIHRoaXMuc2VydmljZVJvbGUgPSBwcm9wcy5zZXJ2aWNlUm9sZSB8fCBuZXcgUm9sZSh0aGlzLCAnU2VydmljZVJvbGUnLCB7IGFzc3VtZWRCeTogbmV3IFNlcnZpY2VQcmluY2lwYWwoJ2FwcHN5bmMnKSB9KTtcbiAgICB9XG4gICAgLy8gUmVwbGFjZSB1bnN1cHBvcnRlZCBjaGFyYWN0ZXJzIGZyb20gRGF0YVNvdXJjZSBuYW1lLiBUaGUgb25seSBhbGxvd2VkIHBhdHRlcm4gaXM6IHtbX0EtWmEtel1bXzAtOUEtWmEtel0qfVxuICAgIGNvbnN0IG5hbWUgPSAocHJvcHMubmFtZSA/PyBpZCkucmVwbGFjZSgvW1xcV10rL2csICcnKTtcbiAgICB0aGlzLmRzID0gbmV3IENmbkRhdGFTb3VyY2UodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgYXBpSWQ6IHByb3BzLmFwaS5hcGlJZCxcbiAgICAgIG5hbWU6IG5hbWUsXG4gICAgICBkZXNjcmlwdGlvbjogcHJvcHMuZGVzY3JpcHRpb24sXG4gICAgICBzZXJ2aWNlUm9sZUFybjogdGhpcy5zZXJ2aWNlUm9sZT8ucm9sZUFybixcbiAgICAgIC4uLmV4dGVuZGVkLFxuICAgIH0pO1xuICAgIHRoaXMubmFtZSA9IG5hbWU7XG4gICAgdGhpcy5hcGkgPSBwcm9wcy5hcGk7XG4gIH1cblxuICAvKipcbiAgICogY3JlYXRlcyBhIG5ldyByZXNvbHZlciBmb3IgdGhpcyBkYXRhc291cmNlIGFuZCBBUEkgdXNpbmcgdGhlIGdpdmVuIHByb3BlcnRpZXNcbiAgICovXG4gIHB1YmxpYyBjcmVhdGVSZXNvbHZlcihwcm9wczogQmFzZVJlc29sdmVyUHJvcHMpOiBSZXNvbHZlciB7XG4gICAgcmV0dXJuIG5ldyBSZXNvbHZlcih0aGlzLCBgJHtwcm9wcy50eXBlTmFtZX0ke3Byb3BzLmZpZWxkTmFtZX1SZXNvbHZlcmAsIHtcbiAgICAgIGFwaTogdGhpcy5hcGksXG4gICAgICBkYXRhU291cmNlOiB0aGlzLFxuICAgICAgLi4ucHJvcHMsXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogY3JlYXRlcyBhIG5ldyBhcHBzeW5jIGZ1bmN0aW9uIGZvciB0aGlzIGRhdGFzb3VyY2UgYW5kIEFQSSB1c2luZyB0aGUgZ2l2ZW4gcHJvcGVydGllc1xuICAgKi9cbiAgcHVibGljIGNyZWF0ZUZ1bmN0aW9uKHByb3BzOiBCYXNlQXBwc3luY0Z1bmN0aW9uUHJvcHMpOiBBcHBzeW5jRnVuY3Rpb24ge1xuICAgIHJldHVybiBuZXcgQXBwc3luY0Z1bmN0aW9uKHRoaXMsIGAke3Byb3BzLm5hbWV9RnVuY3Rpb25gLCB7XG4gICAgICBhcGk6IHRoaXMuYXBpLFxuICAgICAgZGF0YVNvdXJjZTogdGhpcyxcbiAgICAgIC4uLnByb3BzLFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICogQWJzdHJhY3QgQXBwU3luYyBkYXRhc291cmNlIGltcGxlbWVudGF0aW9uLiBEbyBub3QgdXNlIGRpcmVjdGx5IGJ1dCB1c2Ugc3ViY2xhc3NlcyBmb3IgcmVzb3VyY2UgYmFja2VkIGRhdGFzb3VyY2VzXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBCYWNrZWREYXRhU291cmNlIGV4dGVuZHMgQmFzZURhdGFTb3VyY2UgaW1wbGVtZW50cyBJR3JhbnRhYmxlIHtcbiAgLyoqXG4gICAqIHRoZSBwcmluY2lwYWwgb2YgdGhlIGRhdGEgc291cmNlIHRvIGJlIElHcmFudGFibGVcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBncmFudFByaW5jaXBhbDogSVByaW5jaXBhbDtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQmFja2VkRGF0YVNvdXJjZVByb3BzLCBleHRlbmRlZDogRXh0ZW5kZWREYXRhU291cmNlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzLCBleHRlbmRlZCk7XG5cbiAgICB0aGlzLmdyYW50UHJpbmNpcGFsID0gdGhpcy5zZXJ2aWNlUm9sZSE7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhbiBBcHBTeW5jIGR1bW15IGRhdGFzb3VyY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBOb25lRGF0YVNvdXJjZVByb3BzIGV4dGVuZHMgQmFzZURhdGFTb3VyY2VQcm9wcyB7XG59XG5cbi8qKlxuICogQW4gQXBwU3luYyBkdW1teSBkYXRhc291cmNlXG4gKi9cbmV4cG9ydCBjbGFzcyBOb25lRGF0YVNvdXJjZSBleHRlbmRzIEJhc2VEYXRhU291cmNlIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE5vbmVEYXRhU291cmNlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzLCB7XG4gICAgICB0eXBlOiAnTk9ORScsXG4gICAgfSk7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhbiBBcHBTeW5jIER5bmFtb0RCIGRhdGFzb3VyY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEeW5hbW9EYkRhdGFTb3VyY2VQcm9wcyBleHRlbmRzIEJhY2tlZERhdGFTb3VyY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgRHluYW1vREIgdGFibGUgYmFja2luZyB0aGlzIGRhdGEgc291cmNlXG4gICAqL1xuICByZWFkb25seSB0YWJsZTogSVRhYmxlO1xuICAvKipcbiAgICogU3BlY2lmeSB3aGV0aGVyIHRoaXMgRFMgaXMgcmVhZCBvbmx5IG9yIGhhcyByZWFkIGFuZCB3cml0ZSBwZXJtaXNzaW9ucyB0byB0aGUgRHluYW1vREIgdGFibGVcbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHJlYWRPbmx5QWNjZXNzPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIHVzZSBjcmVkZW50aWFscyBvZiBjYWxsZXIgdG8gYWNjZXNzIER5bmFtb0RCXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSB1c2VDYWxsZXJDcmVkZW50aWFscz86IGJvb2xlYW47XG59XG5cbi8qKlxuICogQW4gQXBwU3luYyBkYXRhc291cmNlIGJhY2tlZCBieSBhIER5bmFtb0RCIHRhYmxlXG4gKi9cbmV4cG9ydCBjbGFzcyBEeW5hbW9EYkRhdGFTb3VyY2UgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IER5bmFtb0RiRGF0YVNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcywge1xuICAgICAgdHlwZTogJ0FNQVpPTl9EWU5BTU9EQicsXG4gICAgICBkeW5hbW9EYkNvbmZpZzoge1xuICAgICAgICB0YWJsZU5hbWU6IHByb3BzLnRhYmxlLnRhYmxlTmFtZSxcbiAgICAgICAgYXdzUmVnaW9uOiBwcm9wcy50YWJsZS5zdGFjay5yZWdpb24sXG4gICAgICAgIHVzZUNhbGxlckNyZWRlbnRpYWxzOiBwcm9wcy51c2VDYWxsZXJDcmVkZW50aWFscyxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgaWYgKHByb3BzLnJlYWRPbmx5QWNjZXNzKSB7XG4gICAgICBwcm9wcy50YWJsZS5ncmFudFJlYWREYXRhKHRoaXMpO1xuICAgIH0gZWxzZSB7XG4gICAgICBwcm9wcy50YWJsZS5ncmFudFJlYWRXcml0ZURhdGEodGhpcyk7XG4gICAgfVxuICB9XG59XG5cbi8qKlxuICogVGhlIGF1dGhvcml6YXRpb24gY29uZmlnIGluIGNhc2UgdGhlIEhUVFAgZW5kcG9pbnQgcmVxdWlyZXMgYXV0aG9yaXphdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIEF3c0lhbUNvbmZpZyB7XG4gIC8qKlxuICAgKiBUaGUgc2lnbmluZyByZWdpb24gZm9yIEFXUyBJQU0gYXV0aG9yaXphdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgc2lnbmluZ1JlZ2lvbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgc2lnbmluZyBzZXJ2aWNlIG5hbWUgZm9yIEFXUyBJQU0gYXV0aG9yaXphdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgc2lnbmluZ1NlcnZpY2VOYW1lOiBzdHJpbmc7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYW4gQXBwU3luYyBodHRwIGRhdGFzb3VyY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwRGF0YVNvdXJjZVByb3BzIGV4dGVuZHMgQmFzZURhdGFTb3VyY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgaHR0cCBlbmRwb2ludFxuICAgKi9cbiAgcmVhZG9ubHkgZW5kcG9pbnQ6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGF1dGhvcml6YXRpb24gY29uZmlnIGluIGNhc2UgdGhlIEhUVFAgZW5kcG9pbnQgcmVxdWlyZXMgYXV0aG9yaXphdGlvblxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IGF1dGhvcml6YXRpb25Db25maWc/OiBBd3NJYW1Db25maWc7XG59XG5cbi8qKlxuICogQW4gQXBwU3luYyBkYXRhc291cmNlIGJhY2tlZCBieSBhIGh0dHAgZW5kcG9pbnRcbiAqL1xuZXhwb3J0IGNsYXNzIEh0dHBEYXRhU291cmNlIGV4dGVuZHMgQmFja2VkRGF0YVNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBIdHRwRGF0YVNvdXJjZVByb3BzKSB7XG4gICAgY29uc3QgYXV0aG9yaXphdGlvbkNvbmZpZyA9IHByb3BzLmF1dGhvcml6YXRpb25Db25maWcgPyB7XG4gICAgICBhdXRob3JpemF0aW9uVHlwZTogJ0FXU19JQU0nLFxuICAgICAgYXdzSWFtQ29uZmlnOiBwcm9wcy5hdXRob3JpemF0aW9uQ29uZmlnLFxuICAgIH0gOiB1bmRlZmluZWQ7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcywge1xuICAgICAgdHlwZTogJ0hUVFAnLFxuICAgICAgaHR0cENvbmZpZzoge1xuICAgICAgICBlbmRwb2ludDogcHJvcHMuZW5kcG9pbnQsXG4gICAgICAgIGF1dGhvcml6YXRpb25Db25maWcsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYW4gQXBwU3luYyBMYW1iZGEgZGF0YXNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIExhbWJkYURhdGFTb3VyY2VQcm9wcyBleHRlbmRzIEJhY2tlZERhdGFTb3VyY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgTGFtYmRhIGZ1bmN0aW9uIHRvIGNhbGwgdG8gaW50ZXJhY3Qgd2l0aCB0aGlzIGRhdGEgc291cmNlXG4gICAqL1xuICByZWFkb25seSBsYW1iZGFGdW5jdGlvbjogSUZ1bmN0aW9uO1xufVxuXG4vKipcbiAqIEFuIEFwcFN5bmMgZGF0YXNvdXJjZSBiYWNrZWQgYnkgYSBMYW1iZGEgZnVuY3Rpb25cbiAqL1xuZXhwb3J0IGNsYXNzIExhbWJkYURhdGFTb3VyY2UgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IExhbWJkYURhdGFTb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMsIHtcbiAgICAgIHR5cGU6ICdBV1NfTEFNQkRBJyxcbiAgICAgIGxhbWJkYUNvbmZpZzoge1xuICAgICAgICBsYW1iZGFGdW5jdGlvbkFybjogcHJvcHMubGFtYmRhRnVuY3Rpb24uZnVuY3Rpb25Bcm4sXG4gICAgICB9LFxuICAgIH0pO1xuICAgIHByb3BzLmxhbWJkYUZ1bmN0aW9uLmdyYW50SW52b2tlKHRoaXMpO1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYW4gQXBwU3luYyBSRFMgZGF0YXNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJkc0RhdGFTb3VyY2VQcm9wcyBleHRlbmRzIEJhY2tlZERhdGFTb3VyY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgc2VydmVybGVzcyBjbHVzdGVyIHRvIGNhbGwgdG8gaW50ZXJhY3Qgd2l0aCB0aGlzIGRhdGEgc291cmNlXG4gICAqL1xuICByZWFkb25seSBzZXJ2ZXJsZXNzQ2x1c3RlcjogSVNlcnZlcmxlc3NDbHVzdGVyO1xuICAvKipcbiAgICogVGhlIHNlY3JldCBjb250YWluaW5nIHRoZSBjcmVkZW50aWFscyBmb3IgdGhlIGRhdGFiYXNlXG4gICAqL1xuICByZWFkb25seSBzZWNyZXRTdG9yZTogSVNlY3JldDtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBkYXRhYmFzZSB0byB1c2Ugd2l0aGluIHRoZSBjbHVzdGVyXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZGF0YWJhc2VOYW1lPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIEFuIEFwcFN5bmMgZGF0YXNvdXJjZSBiYWNrZWQgYnkgUkRTXG4gKi9cbmV4cG9ydCBjbGFzcyBSZHNEYXRhU291cmNlIGV4dGVuZHMgQmFja2VkRGF0YVNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSZHNEYXRhU291cmNlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzLCB7XG4gICAgICB0eXBlOiAnUkVMQVRJT05BTF9EQVRBQkFTRScsXG4gICAgICByZWxhdGlvbmFsRGF0YWJhc2VDb25maWc6IHtcbiAgICAgICAgcmRzSHR0cEVuZHBvaW50Q29uZmlnOiB7XG4gICAgICAgICAgYXdzUmVnaW9uOiBwcm9wcy5zZXJ2ZXJsZXNzQ2x1c3Rlci5zdGFjay5yZWdpb24sXG4gICAgICAgICAgZGJDbHVzdGVySWRlbnRpZmllcjogTGF6eS5zdHJpbmcoe1xuICAgICAgICAgICAgcHJvZHVjZTogKCkgPT4ge1xuICAgICAgICAgICAgICByZXR1cm4gU3RhY2sub2YodGhpcykuZm9ybWF0QXJuKHtcbiAgICAgICAgICAgICAgICBzZXJ2aWNlOiAncmRzJyxcbiAgICAgICAgICAgICAgICByZXNvdXJjZTogYGNsdXN0ZXI6JHtwcm9wcy5zZXJ2ZXJsZXNzQ2x1c3Rlci5jbHVzdGVySWRlbnRpZmllcn1gLFxuICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSksXG4gICAgICAgICAgYXdzU2VjcmV0U3RvcmVBcm46IHByb3BzLnNlY3JldFN0b3JlLnNlY3JldEFybixcbiAgICAgICAgICBkYXRhYmFzZU5hbWU6IHByb3BzLmRhdGFiYXNlTmFtZSxcbiAgICAgICAgfSxcbiAgICAgICAgcmVsYXRpb25hbERhdGFiYXNlU291cmNlVHlwZTogJ1JEU19IVFRQX0VORFBPSU5UJyxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgY29uc3QgY2x1c3RlckFybiA9IFN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICBzZXJ2aWNlOiAncmRzJyxcbiAgICAgIHJlc291cmNlOiBgY2x1c3Rlcjoke3Byb3BzLnNlcnZlcmxlc3NDbHVzdGVyLmNsdXN0ZXJJZGVudGlmaWVyfWAsXG4gICAgfSk7XG4gICAgcHJvcHMuc2VjcmV0U3RvcmUuZ3JhbnRSZWFkKHRoaXMpO1xuXG4gICAgLy8gQ2hhbmdlIHRvIGdyYW50IHdpdGggUkRTIGdyYW50IGJlY29tZXMgaW1wbGVtZW50ZWRcblxuICAgIHByb3BzLnNlcnZlcmxlc3NDbHVzdGVyLmdyYW50RGF0YUFwaUFjY2Vzcyh0aGlzKTtcblxuICAgIEdyYW50LmFkZFRvUHJpbmNpcGFsKHtcbiAgICAgIGdyYW50ZWU6IHRoaXMsXG4gICAgICBhY3Rpb25zOiBbXG4gICAgICAgICdyZHMtZGF0YTpEZWxldGVJdGVtcycsXG4gICAgICAgICdyZHMtZGF0YTpFeGVjdXRlU3FsJyxcbiAgICAgICAgJ3Jkcy1kYXRhOkdldEl0ZW1zJyxcbiAgICAgICAgJ3Jkcy1kYXRhOkluc2VydEl0ZW1zJyxcbiAgICAgICAgJ3Jkcy1kYXRhOlVwZGF0ZUl0ZW1zJyxcbiAgICAgIF0sXG4gICAgICByZXNvdXJjZUFybnM6IFtjbHVzdGVyQXJuLCBgJHtjbHVzdGVyQXJufToqYF0sXG4gICAgICBzY29wZTogdGhpcyxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIFByb3Blcml0aWVzIGZvciB0aGUgRWxhc3RpY3NlYXJjaCBEYXRhIFNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEVsYXN0aWNzZWFyY2hEYXRhU291cmNlUHJvcHMgZXh0ZW5kcyBCYWNrZWREYXRhU291cmNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIGVsYXN0aWNzZWFyY2ggZG9tYWluIGNvbnRhaW5pbmcgdGhlIGVuZHBvaW50IGZvciB0aGUgZGF0YSBzb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbjogSURvbWFpbjtcbn1cblxuLyoqXG4gKiBBbiBBcHBzeW5jIGRhdGFzb3VyY2UgYmFja2VkIGJ5IEVsYXN0aWNzZWFyY2hcbiAqL1xuZXhwb3J0IGNsYXNzIEVsYXN0aWNzZWFyY2hEYXRhU291cmNlIGV4dGVuZHMgQmFja2VkRGF0YVNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFbGFzdGljc2VhcmNoRGF0YVNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcywge1xuICAgICAgdHlwZTogJ0FNQVpPTl9FTEFTVElDU0VBUkNIJyxcbiAgICAgIGVsYXN0aWNzZWFyY2hDb25maWc6IHtcbiAgICAgICAgYXdzUmVnaW9uOiBwcm9wcy5kb21haW4uc3RhY2sucmVnaW9uLFxuICAgICAgICBlbmRwb2ludDogYGh0dHBzOi8vJHtwcm9wcy5kb21haW4uZG9tYWluRW5kcG9pbnR9YCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBwcm9wcy5kb21haW4uZ3JhbnRSZWFkV3JpdGUodGhpcyk7XG4gIH1cbn0iXX0=